/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.realizer;

import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.realizer.AbstractTemplateRealizer;
import edu.columbia.ob.gen.realizer.LexicalChoice;
import edu.columbia.ob.gen.realizer.RealizerUtils;
import edu.columbia.ob.gen.util.PosTagging;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import ob.util.Counts;
import ob.util.Utils;
import ob.util.collections.Map3;

public class LanguageModelTemplateRealizer
extends AbstractTemplateRealizer {
    private String _subjectDomain;
    private boolean _useParaphrases;
    private List<TemplateRanker> _rankers = new ArrayList<TemplateRanker>();

    public LanguageModelTemplateRealizer(String subjectDomain, LexicalChoice lexicalChoice, boolean useParaphrases, boolean useDiscourseModel) {
        super(lexicalChoice, useDiscourseModel);
        this._subjectDomain = subjectDomain;
        this._useParaphrases = useParaphrases;
        this._rankers.add(this.loadLengthModel(new File(PreGenEnv.getSubjectDomainCorpusDir(this._subjectDomain), "realization_model_length")));
        this._rankers.add(this.loadPosNgramModel(new File(PreGenEnv.getSubjectDomainCorpusDir(this._subjectDomain), "realization_model_pos_ngram"), new File(PreGenEnv.getSubjectDomainCorpusDir(subjectDomain), "realization_model_pos_ngram_normalizer")));
        this._rankers.add(this.loadNgramModel(new File(PreGenEnv.getSubjectDomainCorpusDir(this._subjectDomain), "realization_model_word"), new File(PreGenEnv.getSubjectDomainCorpusDir(subjectDomain), "realization_model_word_normalizer")));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String chooseTemplate(SemanticUnit su, List<String> previousSentences) {
        void var6_9;
        if (previousSentences.isEmpty()) {
            return this.chooseFirstTemplate(su.getRelevantTemplates());
        }
        String lastSentence = previousSentences.get(previousSentences.size() - 1);
        ArrayList<List<String>> ranks = new ArrayList<List<String>>();
        for (TemplateRanker ranker : this._rankers) {
            ranks.add(this.rankTemplates(su, lastSentence, ranker));
        }
        Counts<String> rankCounts = new Counts<String>();
        for (List list : ranks) {
            int i = 0;
            while (i < list.size()) {
                int j = 0;
                while (j < i + 1) {
                    rankCounts.add((String)list.get(i));
                    ++j;
                }
                ++i;
            }
        }
        Object var6_8 = null;
        int bestCount = 0;
        for (String template : rankCounts) {
            if (rankCounts.getCount(template) <= bestCount) continue;
            bestCount = rankCounts.getCount(template);
            String string = template;
        }
        return var6_9;
    }

    private String chooseFirstTemplate(List<String> templates) {
        return templates.get(new Random().nextInt(templates.size()));
    }

    private List<String> rankTemplates(SemanticUnit su, String lastSentence, TemplateRanker ranker) {
        final HashMap<String, Double> scores = new HashMap<String, Double>();
        List<String> relevant = su.getRelevantTemplates();
        for (String template : relevant) {
            if (!this._useParaphrases && relevant.size() > 1 && RealizerUtils.isParaphraseTemplate(template)) continue;
            Double score = ranker.scoreTemplate(lastSentence, template, su.getParameters());
            score = this.adjustHeuristically(score, template);
            scores.put(template, score);
        }
        ArrayList<String> rankedTemplates = new ArrayList<String>(scores.keySet());
        Collections.sort(rankedTemplates, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return (int)Math.signum((Double)scores.get(o1) - (Double)scores.get(o2));
            }
        });
        return rankedTemplates;
    }

    private Double adjustHeuristically(Double score, String template) {
        if (RealizerUtils.isParaphraseTemplate(template)) {
            double lengthScore = Math.cbrt(8 - template.split("\\s").length);
            score = Math.pow(1.5, lengthScore);
        }
        return score;
    }

    private NgramModel loadNgramModel(File modelFile, File normalizerFile) {
        String[] tokens;
        NgramModel model = new NgramModel();
        for (String line : Utils.readLinesDynamically(modelFile.getAbsolutePath())) {
            tokens = line.split("\\t");
            model.add(tokens[0], tokens[1], Double.parseDouble(tokens[2]));
        }
        for (String line : Utils.readLinesDynamically(normalizerFile.getAbsolutePath())) {
            tokens = line.split("\\t");
            model.addNormalizer(tokens[0], Double.parseDouble(tokens[1]));
        }
        return model;
    }

    private PosNgramModel loadPosNgramModel(File modelFile, File normalizerFile) {
        String[] tokens;
        PosNgramModel model = new PosNgramModel();
        for (String line : Utils.readLinesDynamically(modelFile.getAbsolutePath())) {
            tokens = line.split("\\t");
            model.add(tokens[0], tokens[1], Double.parseDouble(tokens[2]));
        }
        for (String line : Utils.readLinesDynamically(normalizerFile.getAbsolutePath())) {
            tokens = line.split("\\t");
            model.addNormalizer(tokens[0], Double.parseDouble(tokens[1]));
        }
        return model;
    }

    private LengthModel loadLengthModel(File modelFile) {
        LengthModel model = new LengthModel();
        for (String line : Utils.readLinesDynamically(modelFile.getAbsolutePath())) {
            String[] tokens = line.split("\\t");
            model.add(Integer.parseInt(tokens[0]), Double.parseDouble(tokens[1]));
        }
        return model;
    }

    private static List<String> getWords(String sentence, List<TemplateParameter> parameters) {
        String[] tokens;
        ArrayList<String> words = new ArrayList<String>();
        while (sentence.contains("[[")) {
            sentence = String.valueOf(sentence.substring(0, sentence.indexOf("[["))) + parameters.get(Integer.parseInt(sentence.substring(sentence.indexOf("[[") + 2, sentence.indexOf("]]")))).getName() + sentence.substring(sentence.indexOf("]]") + 2);
        }
        String[] stringArray = tokens = sentence.split("\\s+");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.endsWith("'s")) {
                token = token.substring(0, token.length() - 2);
            }
            if (!(token = token.replaceAll("[^A-Za-z0-9\\-\\_]", "")).trim().isEmpty()) {
                words.add(token.toLowerCase());
            }
            ++n2;
        }
        return words;
    }

    private static class LengthModel
    implements TemplateRanker {
        private SortedMap<Integer, Double> _map = new TreeMap<Integer, Double>();

        private LengthModel() {
        }

        public void add(int currentLength, double nextAvgLength) {
            this._map.put(currentLength, nextAvgLength);
        }

        @Override
        public Double scoreTemplate(String lastSentence, String template, List<TemplateParameter> parameters) {
            List sentenceWords = LanguageModelTemplateRealizer.getWords(lastSentence, parameters);
            List templateWords = LanguageModelTemplateRealizer.getWords(template, parameters);
            int length = sentenceWords.size();
            Double nextAvg = (Double)this._map.get(length);
            while (nextAvg == null) {
                length = sentenceWords.size() > 50 ? --length : ++length;
                nextAvg = (Double)this._map.get(length);
            }
            double total = 1.0;
            int i = 1;
            while (i < 4) {
                Double nextAvgMinus;
                Double nextAvgPlus = (Double)this._map.get(length + i);
                if (nextAvgPlus != null) {
                    nextAvg = nextAvg + nextAvgPlus;
                    total += 1.0;
                }
                if ((nextAvgMinus = (Double)this._map.get(length - i)) != null) {
                    nextAvg = nextAvg + nextAvgMinus;
                    total += 1.0;
                }
                ++i;
            }
            nextAvg = nextAvg / total;
            return 1.0 / Math.abs((double)templateWords.size() - nextAvg);
        }
    }

    private static class NgramModel
    implements TemplateRanker {
        private Map3<String, String, Double> _map = new Map3();
        private Map<String, Double> _normalizerMap = new HashMap<String, Double>();

        private NgramModel() {
        }

        public void add(String gram1, String gram2, double frequency) {
            this._map.add(gram1, gram2, frequency);
        }

        public void addNormalizer(String gram, double frequency) {
            this._normalizerMap.put(gram, frequency);
        }

        @Override
        public Double scoreTemplate(String lastSentence, String template, List<TemplateParameter> parameters) {
            List sentenceWords = LanguageModelTemplateRealizer.getWords(lastSentence, null);
            List templateWords = LanguageModelTemplateRealizer.getWords(template, parameters);
            double score = 0.0;
            double normalizer = 0.0;
            for (String word1 : sentenceWords) {
                for (String word2 : templateWords) {
                    Double ngramScore = this._map.get(word1, word2);
                    Double word1Score = this._normalizerMap.get(word1);
                    Double word2Score = this._normalizerMap.get(word2);
                    if (ngramScore != null && word1Score != null && word2Score != null) {
                        ngramScore = ngramScore / word1Score;
                        ngramScore = ngramScore / word2Score;
                        score += ngramScore.doubleValue();
                    }
                    normalizer += 1.0;
                }
            }
            return score / normalizer;
        }
    }

    private static class PosNgramModel
    implements TemplateRanker {
        private Map3<String, String, Double> _map = new Map3();
        private Map<String, Double> _normalizerMap = new HashMap<String, Double>();

        private PosNgramModel() {
        }

        public void add(String gram1, String gram2, double frequency) {
            this._map.add(gram1, gram2, frequency);
        }

        public void addNormalizer(String gram, double frequency) {
            this._normalizerMap.put(gram, frequency);
        }

        @Override
        public Double scoreTemplate(String lastSentence, String template, List<TemplateParameter> parameters) {
            List sentenceWords = LanguageModelTemplateRealizer.getWords(lastSentence, parameters);
            List templateWords = LanguageModelTemplateRealizer.getWords(template, parameters);
            String[] sentencePos = PosTagging.getPos(sentenceWords.toArray(new String[sentenceWords.size()]));
            String[] templatePos = PosTagging.getPos(templateWords.toArray(new String[templateWords.size()]));
            double score = 0.0;
            double normalizer = 0.0;
            int i = 1;
            while (i < sentencePos.length) {
                String pos1 = String.valueOf(sentencePos[i - 1]) + "_" + sentencePos[i];
                int j = 1;
                while (j < templatePos.length) {
                    String pos2 = String.valueOf(templatePos[j - 1]) + "_" + templatePos[j];
                    Double ngramScore = this._map.get(pos1, pos2);
                    Double word1Score = this._normalizerMap.get(pos1);
                    Double word2Score = this._normalizerMap.get(pos2);
                    if (ngramScore != null && word1Score != null && word2Score != null) {
                        ngramScore = ngramScore / word1Score;
                        ngramScore = ngramScore / word2Score;
                        score += ngramScore.doubleValue();
                    }
                    normalizer += 1.0;
                    ++j;
                }
                ++i;
            }
            return score / normalizer;
        }
    }

    private static interface TemplateRanker {
        public Double scoreTemplate(String var1, String var2, List<TemplateParameter> var3);
    }
}

