/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.realizer;

import edu.columbia.ob.gen.core.DiscourseRelation;
import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.env.PreGenRuntime;
import edu.columbia.ob.gen.realizer.LexicalChoice;
import edu.columbia.ob.gen.realizer.Realizer;
import edu.columbia.ob.gen.realizer.RealizerUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class AbstractTemplateRealizer
implements Realizer {
    private LexicalChoice _lexicalChoice;
    private boolean _useDiscourse;

    public AbstractTemplateRealizer(LexicalChoice lexicalChoice, boolean useDiscourse) {
        this._lexicalChoice = lexicalChoice;
        this._useDiscourse = useDiscourse;
    }

    @Override
    public Collection<String> realize(Collection<Paragraph> paragraphs) {
        ArrayList<String> texts = new ArrayList<String>();
        for (Paragraph paragraph : paragraphs) {
            texts.add(this.realize(paragraph));
        }
        return texts;
    }

    public String realize(Paragraph paragraph) {
        List<SemanticUnit> sus = paragraph.getSus();
        List<DiscourseRelation> relations = paragraph.getRelations();
        ArrayList<String> sentences = new ArrayList<String>();
        String discourseMarkerTemplate = null;
        String sentenceTemplate = null;
        int skip = 0;
        int i = 0;
        while (i < sus.size()) {
            SemanticUnit su = sus.get(i);
            String template = this.chooseTemplate(su, sentences);
            if (template == null) {
                ++skip;
            } else {
                String text = this.realize(su, template);
                String string = discourseMarkerTemplate = i == 0 ? null : this.getDiscourseMarkerTemplate(relations.get(i), sus.get(i - (1 + skip)), sus.get(i), discourseMarkerTemplate, sentenceTemplate, template);
                if (discourseMarkerTemplate != null) {
                    if (discourseMarkerTemplate.startsWith("$1. ")) {
                        text = discourseMarkerTemplate.substring(4).replace("$2", text);
                    } else {
                        if (discourseMarkerTemplate.contains(".")) {
                            throw new RuntimeException("Cannot handle discourse marker template: " + discourseMarkerTemplate);
                        }
                        text = discourseMarkerTemplate.replace("$1", (CharSequence)sentences.get(sentences.size() - 1)).replace("$2", text);
                        sentences.remove(sentences.size() - 1);
                    }
                }
                sentences.add(text);
                skip = 0;
                sentenceTemplate = template;
            }
            ++i;
        }
        StringBuilder sb2 = new StringBuilder();
        for (String sentence : sentences) {
            if (!sentence.endsWith(".")) {
                sentence = String.valueOf(sentence) + ". ";
            }
            sentence = String.valueOf(sentence) + "\n";
            sb2.append(AbstractTemplateRealizer.ucFirstNonHtml(sentence));
        }
        return sb2.toString();
    }

    private String getDiscourseMarkerTemplate(DiscourseRelation discourseRelation, SemanticUnit su1, SemanticUnit su2, String previousTemplate, String su1template, String su2template) {
        if (!this._useDiscourse) {
            return null;
        }
        if (discourseRelation == null || discourseRelation.equals((Object)DiscourseRelation.norel)) {
            return null;
        }
        if (discourseRelation.equals((Object)DiscourseRelation.expansion) && !this.parameterMatch(su1, su2)) {
            return null;
        }
        if (this.containsDiscourseMarkers(su1template) || this.containsDiscourseMarkers(su2template)) {
            return null;
        }
        List<String> templates = PreGenEnv.getDiscourseMarkerTemplateMgr().getDiscourseMarkerTemplatesForRelation(discourseRelation);
        if (previousTemplate != null) {
            templates = this.removeDisruptiveTemplates(templates);
        }
        return templates.get(new Random().nextInt(templates.size()));
    }

    private boolean containsDiscourseMarkers(String template) {
        if (template.contains("although")) {
            return true;
        }
        if (template.contains("despite")) {
            return true;
        }
        if (template.contains("whereas")) {
            return true;
        }
        if (template.contains("because")) {
            return true;
        }
        return template.contains("but");
    }

    private boolean parameterMatch(SemanticUnit su1, SemanticUnit su2) {
        for (TemplateParameter p1 : su1.getParameters()) {
            if (p1.getType().equals(PreGenRuntime.getCoreType())) continue;
            for (TemplateParameter p2 : su2.getParameters()) {
                if (p2.getType().equals(PreGenRuntime.getCoreType()) || !p1.equals(p2)) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> removeDisruptiveTemplates(List<String> templates) {
        ArrayList<String> newTemplates = new ArrayList<String>();
        for (String template : templates) {
            if (template.startsWith("$1")) {
                newTemplates.add(template);
            }
            if (!template.contains(".")) continue;
            newTemplates.add(template);
        }
        return newTemplates;
    }

    protected abstract String chooseTemplate(SemanticUnit var1, List<String> var2);

    private String realize(SemanticUnit su, String template) {
        if (su.isPast() && !RealizerUtils.isParaphraseTemplate(template)) {
            template = template.replace(" is ", " was ").replace(" are ", " were ");
        }
        int i = 0;
        while (i < su.getParameters().size()) {
            template = template.replace("[[" + i + "]]", this.prepareParameter(su.getParameters().get(i).getName()));
            ++i;
        }
        String text = template = this._lexicalChoice.doLexicalChoice(template, su);
        text = text.trim();
        text = text.replaceAll("\\s+", " ");
        text = text.replace(" ,", ",");
        text = text.replace(" .", ".");
        text = text.replace(" ?", "?");
        text = text.replace(" !", "!");
        text = text.replace(" ;", ";");
        text = text.replace(" :", ":");
        text = text.replace(" `` ", " \"");
        text = text.replace(" '' ", "\" ");
        text = text.replace("''.", "").replaceAll("\\s+", " ").trim();
        text = text.replace("''.", "").replaceAll("\\s+", " ").trim();
        text = this.handlePossessives(text);
        try {
            text = this.escapePercentage(text);
            text = URLDecoder.decode(text, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        text = text.replace(" %", "%");
        text = StringEscapeUtils.unescapeJava((String)text);
        if (this.countOccurence(text, "\"") == 1) {
            text = String.valueOf(text) + "\"";
        }
        return text;
    }

    private String prepareParameter(String name) {
        if (name.indexOf("(") > 0) {
            name = name.substring(0, name.indexOf("(")).trim();
        }
        return name;
    }

    private String escapePercentage(String text) throws Exception {
        int index = text.indexOf("%");
        while (index != -1) {
            if (index >= text.length() - 2 || !this.escapeChar(text.charAt(index + 1)) || !this.escapeChar(text.charAt(index + 2))) {
                text = String.valueOf(text.substring(0, index)) + URLEncoder.encode("%", "UTF-8") + text.substring(index + 1);
            }
            index = text.indexOf("%", index + 1);
        }
        return text;
    }

    private boolean escapeChar(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c);
    }

    private int countOccurence(String text, String occurence) {
        int count = 0;
        int index = text.indexOf(occurence);
        while (index != -1) {
            ++count;
            index = text.indexOf(occurence, index + 1);
        }
        return count;
    }

    private String handlePossessives(String text) {
        int index = text.indexOf(" 's");
        while (index != -1) {
            char previousChar = text.charAt(index - 1);
            text = previousChar == 's' || previousChar == 'S' ? String.valueOf(text.substring(0, index)) + "'" + text.substring(index + " 's".length()) : String.valueOf(text.substring(0, index)) + text.substring(index + 1);
            index = text.indexOf(" 's");
        }
        return text;
    }

    public static String ucFirstNonHtml(String string) {
        int firstNonHtmlIndex = 0;
        while (string.charAt(firstNonHtmlIndex) == '<') {
            firstNonHtmlIndex = string.indexOf(">", firstNonHtmlIndex) + 1;
        }
        return String.valueOf(string.substring(0, firstNonHtmlIndex)) + string.substring(firstNonHtmlIndex, firstNonHtmlIndex + 1).toUpperCase() + string.substring(firstNonHtmlIndex + 1);
    }
}

