/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.planner;

import edu.columbia.ob.gen.core.DiscourseRelation;
import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.ParagraphImpl;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.planner.DocumentPlanner;
import edu.columbia.ob.gen.planner.PathFinder;
import edu.columbia.ob.gen.planner.RelationNgramPathFinder;
import edu.columbia.ob.gen.planner.SemanticUnitGraph;
import edu.columbia.ob.gen.planner.SemanticUnitGraphImpl;
import edu.columbia.ob.gen.planner.SemanticUnitGraphPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class DiscourseAndCoherenceDocumentPlannerOld
implements DocumentPlanner {
    private PathFinder _pathFinder = new RelationNgramPathFinder();
    private DomainInfoMgr _domainInfoMgr;

    public DiscourseAndCoherenceDocumentPlannerOld(DomainInfoMgr domainInfoMgr) {
        this._domainInfoMgr = domainInfoMgr;
    }

    @Override
    public Collection<Paragraph> getParagraphs(Collection<SemanticUnit> sus) {
        SemanticUnitGraph graph = this.makeSemanticUnitGraph(sus);
        SemanticUnitGraphPath path = this.findBestPath(graph);
        return this.makeParagraphs(path);
    }

    private Collection<Paragraph> makeParagraphs(SemanticUnitGraphPath path) {
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        ParagraphImpl paragraph = new ParagraphImpl();
        int i = 0;
        while (i < path.size()) {
            DiscourseRelation edgeRelation = path.getEdge(i);
            SemanticUnit nextSu = path.getNode(i);
            if (DiscourseRelation.norel.equals((Object)edgeRelation)) {
                paragraphs.add(paragraph);
                paragraph = new ParagraphImpl();
            }
            paragraph.addSemanticUnit(nextSu, edgeRelation);
            ++i;
        }
        paragraphs.add(paragraph);
        return paragraphs;
    }

    private SemanticUnitGraphPath findBestPath(SemanticUnitGraph graph) {
        return this._pathFinder.bestPath(graph);
    }

    private SemanticUnitGraph makeSemanticUnitGraph(Collection<SemanticUnit> sus) {
        SemanticUnitGraphImpl graph = new SemanticUnitGraphImpl(sus);
        SemanticUnit[] suArray = sus.toArray(new SemanticUnit[sus.size()]);
        int i = 0;
        while (i < suArray.length - 1) {
            int j = i + 1;
            while (j < suArray.length) {
                SemanticUnit su1 = suArray[i];
                SemanticUnit su2 = suArray[j];
                for (DiscourseRelation relation : this.getPotentialRelations(su1, su2)) {
                    graph.addEdge(su1, su2, relation);
                }
                for (DiscourseRelation relation : this.getPotentialRelations(su2, su1)) {
                    graph.addEdge(su2, su1, relation);
                }
                ++j;
            }
            ++i;
        }
        return graph;
    }

    private Collection<DiscourseRelation> getPotentialRelations(SemanticUnit su1, SemanticUnit su2) {
        HashSet<DiscourseRelation> relations = new HashSet<DiscourseRelation>();
        if (su1.getStt().equals(su2.getStt())) {
            relations.add(DiscourseRelation.expansion);
        } else {
            Collection<DiscourseRelation> fixedRelations = this._domainInfoMgr.getFixedSttRelations(su1.getStt(), su2.getStt());
            if (fixedRelations != null) {
                relations.addAll(fixedRelations);
            }
            double same = 0.0;
            for (TemplateParameter p1 : su1.getParameters()) {
                for (TemplateParameter p2 : su2.getParameters()) {
                    if (!p1.equals(p2)) continue;
                    same += 1.0;
                }
            }
            double total = (su1.getParameters().size() + su2.getParameters().size()) / 2;
            double ratio = same / total;
            if (ratio >= 0.5) {
                relations.add(DiscourseRelation.expansion);
            }
        }
        return relations;
    }
}

