/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.planner;

import edu.columbia.ob.gen.core.DiscourseRelation;
import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.ParagraphImpl;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenRuntime;
import edu.columbia.ob.gen.env.StaticVectors;
import edu.columbia.ob.gen.planner.DocumentPlanner;
import edu.columbia.ob.gen.planner.PathFinder;
import edu.columbia.ob.gen.planner.RelationNgramPathFinder;
import edu.columbia.ob.gen.planner.SemanticUnitGraph;
import edu.columbia.ob.gen.planner.SemanticUnitGraphImpl;
import edu.columbia.ob.gen.planner.SemanticUnitGraphPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ob.util.Pair;
import ob.util.Utils;

public class DiscourseAndCoherenceDocumentPlanner
implements DocumentPlanner {
    private static final double SIMILARITY_THRESHOLD = 0.5;
    private PathFinder _pathFinder;
    private DomainInfoMgr _domainInfoMgr;

    public DiscourseAndCoherenceDocumentPlanner(DomainInfoMgr domainInfoMgr) {
        this(domainInfoMgr, true);
    }

    public DiscourseAndCoherenceDocumentPlanner(DomainInfoMgr domainInfoMgr, boolean useDiscourseModel) {
        this._domainInfoMgr = domainInfoMgr;
        this._pathFinder = new RelationNgramPathFinder(useDiscourseModel);
    }

    @Override
    public Collection<Paragraph> getParagraphs(Collection<SemanticUnit> sus) {
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        Collection<Collection<SemanticUnit>> semanticSubsets = this.getSemanticSubsets(sus);
        for (Collection<SemanticUnit> subset : semanticSubsets) {
            SemanticUnitGraph graph = this.makeSemanticUnitGraph(subset);
            SemanticUnitGraphPath path = this.findBestPath(graph);
            paragraphs.addAll(this.makeParagraphs(path));
        }
        Collections.sort(paragraphs, new Comparator<Paragraph>(){

            @Override
            public int compare(Paragraph arg0, Paragraph arg1) {
                return -((int)Math.signum(this.avgPreference(arg0) - this.avgPreference(arg1)));
            }

            private double avgPreference(Paragraph p) {
                double avgPref = 0.0;
                double coreBonus = 0.0;
                for (SemanticUnit su : p.getSus()) {
                    avgPref += su.getPreferenceScore();
                    double suCoreBonus = 0.0;
                    for (TemplateParameter param : su.getParameters()) {
                        if (!param.isCoreEntity()) continue;
                        suCoreBonus += 1.0;
                    }
                    coreBonus += (suCoreBonus /= (double)su.getParameters().size());
                }
                return (avgPref + coreBonus) / (double)p.getSus().size();
            }
        });
        return paragraphs;
    }

    private Collection<Collection<SemanticUnit>> getSemanticSubsets(Collection<SemanticUnit> sus) {
        final Map<Pair<SemanticUnit>, Double> similarities = this.getSimilarities(sus);
        ArrayList<Pair<SemanticUnit>> list = new ArrayList<Pair<SemanticUnit>>(similarities.keySet());
        Collections.sort(list, new Comparator<Pair<SemanticUnit>>(){

            @Override
            public int compare(Pair<SemanticUnit> o1, Pair<SemanticUnit> o2) {
                return -((int)Math.signum((Double)similarities.get(o1) - (Double)similarities.get(o2)));
            }
        });
        HashMap<SemanticUnit, List<SemanticUnit>> membership = new HashMap<SemanticUnit, List<SemanticUnit>>();
        for (Pair pair : list) {
            Collection<SemanticUnit> group;
            if (membership.get(pair.getFirst()) == null && membership.get(pair.getSecond()) == null) {
                group = new ArrayList<SemanticUnit>();
                group.add((SemanticUnit)pair.getFirst());
                group.add((SemanticUnit)pair.getSecond());
                membership.put((SemanticUnit)pair.getFirst(), (List<SemanticUnit>)group);
                membership.put((SemanticUnit)pair.getSecond(), (List<SemanticUnit>)group);
                continue;
            }
            if (membership.get(pair.getFirst()) == null) {
                group = (Collection)membership.get(pair.getSecond());
                if (!this.matches(group, Utils.list((SemanticUnit)pair.getFirst()))) continue;
                group.add((SemanticUnit)pair.getFirst());
                membership.put((SemanticUnit)pair.getFirst(), (List<SemanticUnit>)group);
                continue;
            }
            if (membership.get(pair.getSecond()) == null) {
                group = (Collection)membership.get(pair.getFirst());
                if (!this.matches(group, Utils.list((SemanticUnit)pair.getSecond()))) continue;
                group.add((SemanticUnit)pair.getSecond());
                membership.put((SemanticUnit)pair.getSecond(), (List<SemanticUnit>)group);
                continue;
            }
            if (membership.get(pair.getFirst()) == membership.get(pair.getSecond()) || !this.matches(group = (Collection)membership.get(pair.getFirst()), (Collection)membership.get(pair.getSecond()))) continue;
            group.addAll((Collection)membership.get(pair.getSecond()));
            for (SemanticUnit su : (Collection)membership.get(pair.getSecond())) {
                membership.put(su, (List<SemanticUnit>)group);
            }
        }
        for (SemanticUnit semanticUnit : sus) {
            if (membership.get(semanticUnit) != null) continue;
            membership.put(semanticUnit, Utils.list(semanticUnit));
        }
        return new HashSet<Collection<SemanticUnit>>(membership.values());
    }

    private boolean matches(Collection<SemanticUnit> group1, Collection<SemanticUnit> group2) {
        for (SemanticUnit su1 : group1) {
            for (SemanticUnit su2 : group2) {
                if (!(this.getSuSimilarity(su1, su2) < 0.5)) continue;
                return false;
            }
        }
        return true;
    }

    private Map<Pair<SemanticUnit>, Double> getSimilarities(Collection<SemanticUnit> sus) {
        HashMap<Pair<SemanticUnit>, Double> map = new HashMap<Pair<SemanticUnit>, Double>();
        List list = (List)sus;
        int i = 0;
        while (i < list.size() - 1) {
            int j = i + 1;
            while (j < list.size()) {
                double similarity = this.getSuSimilarity((SemanticUnit)list.get(i), (SemanticUnit)list.get(j));
                if (similarity > 0.5) {
                    map.put(new Pair<SemanticUnit>((SemanticUnit)list.get(i), (SemanticUnit)list.get(j)), similarity);
                }
                ++j;
            }
            ++i;
        }
        return map;
    }

    private double getSuSimilarity(SemanticUnit su1, SemanticUnit su2) {
        double vectorSim = StaticVectors.getSimilarity(su1, su2);
        double score = 0.0;
        block0: for (TemplateParameter parameter1 : su1.getParameters()) {
            if (parameter1.getName().equals(PreGenRuntime.getInstanceEntity())) continue;
            for (TemplateParameter parameter2 : su2.getParameters()) {
                if (parameter2.getName().equals(PreGenRuntime.getInstanceEntity())) continue;
                if (parameter1.equals(parameter2)) {
                    score += 1.0;
                    continue;
                }
                if (parameter1.getType().equals("type")) continue block0;
                if (parameter2.getType().equals("type")) continue;
                if (parameter1.getType().equals(PreGenRuntime.getCoreType())) continue block0;
                if (parameter2.getType().equals(PreGenRuntime.getCoreType()) || !parameter1.getType().equals(parameter2.getType())) continue;
                score += 0.8;
            }
        }
        if (Double.isNaN(score)) {
            score = 0.0;
        }
        return vectorSim * 0.8 + score * 1.2;
    }

    private Collection<Paragraph> makeParagraphs(SemanticUnitGraphPath path) {
        ArrayList<Paragraph> paragraphs = new ArrayList<Paragraph>();
        ParagraphImpl paragraph = new ParagraphImpl();
        int i = 0;
        while (i < path.size()) {
            DiscourseRelation edgeRelation = path.getEdge(i);
            SemanticUnit nextSu = path.getNode(i);
            if (DiscourseRelation.norel.equals((Object)edgeRelation)) {
                paragraphs.add(paragraph);
                paragraph = new ParagraphImpl();
            }
            paragraph.addSemanticUnit(nextSu, edgeRelation);
            ++i;
        }
        paragraphs.add(paragraph);
        return paragraphs;
    }

    private SemanticUnitGraphPath findBestPath(SemanticUnitGraph graph) {
        return this._pathFinder.bestPath(graph);
    }

    private SemanticUnitGraph makeSemanticUnitGraph(Collection<SemanticUnit> sus) {
        SemanticUnitGraphImpl graph = new SemanticUnitGraphImpl(sus);
        SemanticUnit[] suArray = sus.toArray(new SemanticUnit[sus.size()]);
        int i = 0;
        while (i < suArray.length - 1) {
            int j = i + 1;
            while (j < suArray.length) {
                SemanticUnit su1 = suArray[i];
                SemanticUnit su2 = suArray[j];
                for (DiscourseRelation relation : this.getPotentialRelations(su1, su2)) {
                    graph.addEdge(su1, su2, relation);
                }
                for (DiscourseRelation relation : this.getPotentialRelations(su2, su1)) {
                    graph.addEdge(su2, su1, relation);
                }
                ++j;
            }
            ++i;
        }
        return graph;
    }

    private Collection<DiscourseRelation> getPotentialRelations(SemanticUnit su1, SemanticUnit su2) {
        HashSet<DiscourseRelation> relations = new HashSet<DiscourseRelation>();
        if (su1.getStt().equals(su2.getStt())) {
            relations.add(DiscourseRelation.comparison);
        } else {
            Collection<DiscourseRelation> fixedRelations = this._domainInfoMgr.getFixedSttRelations(su1.getStt(), su2.getStt());
            if (fixedRelations != null) {
                relations.addAll(fixedRelations);
            }
            double same = 0.0;
            for (TemplateParameter p1 : su1.getParameters()) {
                for (TemplateParameter p2 : su2.getParameters()) {
                    if (!p1.equals(p2)) continue;
                    same += 1.0;
                }
            }
            double total = (su1.getParameters().size() + su2.getParameters().size()) / 2;
            double ratio = same / total;
            if (ratio >= 0.5) {
                relations.add(DiscourseRelation.expansion);
            }
        }
        return relations;
    }
}

