/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.paraphraseMining;

import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import ob.util.StopWatch;
import ob.util.Utils;

public class MakePosTags {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new RuntimeException("expected two arguments: corpus (input) file and output file");
        }
        String infile = args[0];
        String outfile = args[1];
        PrintWriter pw = new PrintWriter(new FileWriter(outfile));
        int articles = 0;
        StopWatch sw = new StopWatch();
        MaxentTagger tagger = new MaxentTagger("models/english-bidirectional-distsim.tagger");
        for (String line : Utils.readLinesDynamically(infile)) {
            if (line.startsWith("####") || line.startsWith("==")) {
                pw.println(line);
                if (!line.startsWith("####")) continue;
                System.out.println("at article: " + ++articles + " (" + sw.getTimeElapsedPretty() + ")  --  " + Utils.usedMemory());
                continue;
            }
            for (List sentence : new DocumentPreprocessor((Reader)new StringReader(line))) {
                pw.println(tagger.tagTokenizedString(Sentence.listToString((List)sentence)));
            }
        }
        pw.close();
    }
}

