/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.paraphraseMining;

import edu.columbia.ob.gen.paraphraseMining.Taxonomy;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FindEntitiesUtils {
    private static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();

    public static boolean passes(String line, int minEntities) {
        int numWords = line.split("\\s+").length;
        if (numWords > 30) {
            return false;
        }
        if (numWords < 6) {
            return false;
        }
        int numEntities = FindEntitiesUtils.getNumEntities(line);
        if (numEntities < minEntities || numEntities > 5) {
            return false;
        }
        return FindEntitiesUtils.isPureAscii(line);
    }

    private static boolean isPureAscii(String str) {
        return asciiEncoder.canEncode(str);
    }

    private static int getNumEntities(String line) {
        int c = 0;
        while (line.contains("[[")) {
            ++c;
            line = line.substring(line.indexOf("[[") + 2);
        }
        return c;
    }

    public static boolean hasNoVerb(String line) {
        String[] stringArray = line.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.split("_")[1].startsWith("V")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String findEntitiesInPosSentence(String sentence, Taxonomy taxonomy) {
        sentence = FindEntitiesUtils.normalizeLetters(sentence);
        sentence = FindEntitiesUtils.findEntitiesDates(sentence);
        sentence = FindEntitiesUtils.findEntitiesPercent(sentence);
        sentence = FindEntitiesUtils.findEntitiesMoney(sentence);
        sentence = FindEntitiesUtils.findEntitiesFromTaxonomy(sentence, taxonomy);
        sentence = FindEntitiesUtils.findEntities(null, sentence, "NNP", "NNPS");
        sentence = FindEntitiesUtils.findEntities("number", sentence, "CD");
        sentence = FindEntitiesUtils.findEntitiesNth(sentence);
        sentence = FindEntitiesUtils.removePos(sentence);
        sentence = FindEntitiesUtils.correctNonNumericCounters(sentence);
        sentence = FindEntitiesUtils.correctSeparationWithOf(sentence);
        sentence = FindEntitiesUtils.removeParentheses(sentence);
        return sentence;
    }

    private static String findEntitiesNth(String line) {
        String[] tokens = line.split("\\s+");
        String newLine = "";
        boolean blocked = false;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].startsWith("[[")) {
                blocked = true;
            }
            if (blocked) {
                if (tokens[i].endsWith("]]")) {
                    blocked = false;
                }
                newLine = String.valueOf(newLine) + " " + tokens[i];
            } else {
                newLine = FindEntitiesUtils.isNth(tokens[i].split("_")[0]) ? String.valueOf(newLine) + " [[counter|" + tokens[i] + "]]" : String.valueOf(newLine) + " " + tokens[i];
            }
            ++i;
        }
        return newLine.substring(1);
    }

    private static boolean isNth(String string) {
        return (string.endsWith("th") || string.endsWith("rd") || string.endsWith("nd") || string.endsWith("st")) && string.substring(0, string.length() - 2).matches("\\d+");
    }

    private static String findEntitiesFromTaxonomy(String line, Taxonomy taxonomy) {
        String[] tokens = line.split("\\s+");
        String newLine = "";
        boolean blocked = false;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].startsWith("[[")) {
                blocked = true;
            }
            if (blocked) {
                if (tokens[i].endsWith("]]")) {
                    blocked = false;
                }
                newLine = String.valueOf(newLine) + " " + tokens[i];
            } else if (tokens[i].substring(0, 1).matches("[A-Z]")) {
                int end = i + 1;
                int j = i + 1;
                while (j < tokens.length) {
                    if (tokens[j].substring(0, 1).matches("[A-Z]")) {
                        end = j + 1;
                    } else {
                        String jPos = tokens[j].split("_")[1];
                        if (!jPos.equals("IN") && !jPos.equals(",")) break;
                    }
                    ++j;
                }
                String entitiesString = FindEntitiesUtils.findEntitiesFromTaxonomyForSuspect(Arrays.copyOfRange(tokens, i, end), i == 0, taxonomy);
                newLine = String.valueOf(newLine) + " " + entitiesString;
                i = end - 1;
            } else {
                newLine = String.valueOf(newLine) + " " + tokens[i];
            }
            ++i;
        }
        return newLine.substring(1);
    }

    private static String findEntitiesFromTaxonomyForSuspect(String[] tokens, boolean beginningOfSentence, Taxonomy taxonomy) {
        String line = "";
        if (!FindEntitiesUtils.atLeastOneNoun(tokens)) {
            int i = 0;
            while (i < tokens.length) {
                if (i > 0) {
                    line = String.valueOf(line) + " ";
                }
                line = String.valueOf(line) + tokens[i];
                ++i;
            }
        } else if (FindEntitiesUtils.isTaxonomyEntity(tokens, taxonomy) || FindEntitiesUtils.allNNP(tokens)) {
            line = String.valueOf(line) + "[[";
            int i = 0;
            while (i < tokens.length) {
                if (i > 0) {
                    line = String.valueOf(line) + " ";
                }
                line = String.valueOf(line) + tokens[i];
                ++i;
            }
            line = String.valueOf(line) + "]]";
        } else if (beginningOfSentence && tokens.length > 1 && FindEntitiesUtils.isTaxonomyEntity(Arrays.copyOfRange(tokens, 1, tokens.length), taxonomy)) {
            line = String.valueOf(line) + tokens[0] + " [[";
            int i = 1;
            while (i < tokens.length) {
                if (i > 1) {
                    line = String.valueOf(line) + " ";
                }
                line = String.valueOf(line) + tokens[i];
                ++i;
            }
            line = String.valueOf(line) + "]]";
        } else {
            int i = 0;
            while (i < tokens.length) {
                if (i > 0) {
                    line = String.valueOf(line) + " ";
                }
                line = String.valueOf(line) + tokens[i];
                ++i;
            }
        }
        return line;
    }

    private static boolean atLeastOneNoun(String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.split("_")[1].startsWith("N")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean allNNP(String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.split("_")[1].startsWith("NNP")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isTaxonomyEntity(String[] tokens, Taxonomy taxonomy) {
        if (taxonomy == null) {
            return true;
        }
        String entity = "";
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            entity = String.valueOf(entity) + " " + token.split("_")[0].toLowerCase();
            ++n2;
        }
        entity = entity.substring(1);
        return taxonomy.getSenses(entity = entity.replace(" , ", ", ")) != null;
    }

    private static String correctSeparationWithOf(String line) {
        int index = -1;
        while (line.indexOf("]] of [[", index) != -1) {
            if (line.lastIndexOf("[[", index = line.indexOf("]] of [[", index)) > line.lastIndexOf("|", index) && (line.indexOf("]]", index + 8) < line.indexOf("|", index + 8) || line.indexOf("|", index + 8) == -1)) {
                line = String.valueOf(line.substring(0, index)) + " of " + line.substring(index + 8);
            }
            index += 8;
        }
        return line;
    }

    /*
     * Unable to fully structure code
     */
    private static String correctNonNumericCounters(String line) {
        sb = new StringBuilder();
        var5_2 = line.split("\\s+");
        var4_3 = var5_2.length;
        var3_4 = 0;
        while (var3_4 < var4_3) {
            token = var5_2[var3_4];
            if (!token.startsWith("[[") || !token.endsWith("]]")) ** GOTO lbl-1000
            startIndex = 2;
            if (token.contains("|")) {
                startIndex = token.indexOf("|") + 1;
            }
            if (FindEntitiesUtils.isNonNumericCounter(token.substring(startIndex, token.length() - 2))) {
                sb.append(" " + token.substring(startIndex, token.length() - 2));
            } else lbl-1000:
            // 2 sources

            {
                sb.append(" " + token);
            }
            ++var3_4;
        }
        return sb.toString().substring(1);
    }

    private static boolean isNonNumericCounter(String word) {
        if ((word = word.toLowerCase()).equals("one")) {
            return true;
        }
        if (word.equals("two")) {
            return true;
        }
        if (word.equals("three")) {
            return true;
        }
        if (word.equals("four")) {
            return true;
        }
        if (word.equals("five")) {
            return true;
        }
        if (word.equals("six")) {
            return true;
        }
        if (word.equals("seven")) {
            return true;
        }
        if (word.equals("eight")) {
            return true;
        }
        if (word.equals("nine")) {
            return true;
        }
        if (word.equals("ten")) {
            return true;
        }
        if (word.equals("first")) {
            return true;
        }
        if (word.equals("second")) {
            return true;
        }
        if (word.equals("third")) {
            return true;
        }
        if (word.equals("fourth")) {
            return true;
        }
        if (word.equals("fifth")) {
            return true;
        }
        if (word.equals("sixth")) {
            return true;
        }
        if (word.equals("seventh")) {
            return true;
        }
        if (word.equals("eighth")) {
            return true;
        }
        if (word.equals("ninth")) {
            return true;
        }
        return word.equals("tenth");
    }

    private static String removePos(String line) {
        StringBuilder sb2 = new StringBuilder();
        String[] stringArray = line.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String bareToken = token.split("_")[0];
            if (token.endsWith("]]")) {
                bareToken = String.valueOf(bareToken) + "]]";
            }
            sb2.append(" " + bareToken);
            ++n2;
        }
        return sb2.toString().substring(1);
    }

    private static String removeParentheses(String line) {
        String token;
        StringBuilder sb2 = new StringBuilder();
        String parens = null;
        String[] stringArray = line.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            token = stringArray[n2];
            if (token.startsWith("-L") && token.endsWith("B-") && token.length() == 5) {
                parens = token.substring(2, 3);
            }
            if (parens == null) {
                sb2.append(" " + token);
            } else if (token.startsWith("-R") && token.endsWith("B-") && token.length() == 5 && parens.equals(token.substring(2, 3))) {
                parens = null;
            }
            ++n2;
        }
        if (sb2.toString().isEmpty() && !line.isEmpty()) {
            stringArray = line.split("\\s+");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                token = stringArray[n2];
                if (!(token.startsWith("-L") && token.endsWith("B-") && token.length() == 5 || token.startsWith("-R") && token.endsWith("B-") && token.length() == 5)) {
                    sb2.append(" " + token);
                }
                ++n2;
            }
        }
        if (sb2.toString().isEmpty()) {
            System.out.println("WARNING - empty line after remove parentheses: " + line);
            return "";
        }
        return sb2.toString().substring(1);
    }

    private static String findEntitiesMoney(String line) {
        String[] tokens = line.split("\\s+");
        ArrayList<String> wordTypes = new ArrayList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String word = token.split("_")[0];
            if (FindEntitiesUtils.isMoneySymbol(word)) {
                wordTypes.add("moneySymbol");
            } else if (FindEntitiesUtils.isMoneyName(word)) {
                wordTypes.add("moneyName");
            } else {
                wordTypes.add(token.split("_")[1]);
            }
            ++n2;
        }
        line = FindEntitiesUtils.findEntitiesPattern("money", line, wordTypes, "moneySymbol CD CD CD");
        line = FindEntitiesUtils.findEntitiesPattern("money", line, wordTypes, "moneySymbol CD CD");
        line = FindEntitiesUtils.findEntitiesPattern("money", line, wordTypes, "moneySymbol CD");
        line = FindEntitiesUtils.findEntitiesPattern("money", line, wordTypes, "CD CD CD moneyName");
        line = FindEntitiesUtils.findEntitiesPattern("money", line, wordTypes, "CD CD moneyName");
        line = FindEntitiesUtils.findEntitiesPattern("money", line, wordTypes, "CD moneyName");
        return line;
    }

    private static boolean isMoneyName(String word) {
        if (word.equals("USD")) {
            return true;
        }
        if (word.equals("EUR")) {
            return true;
        }
        if (word.equals("GBP")) {
            return true;
        }
        if (word.equals("JPY")) {
            return true;
        }
        if (word.equals("CNY")) {
            return true;
        }
        if (word.equals("CHF")) {
            return true;
        }
        if (word.equals("AUD")) {
            return true;
        }
        if (word.equals("CAD")) {
            return true;
        }
        if (word.toLowerCase().equals("dollar")) {
            return true;
        }
        if (word.toLowerCase().equals("dollars")) {
            return true;
        }
        if (word.toLowerCase().equals("euro")) {
            return true;
        }
        if (word.toLowerCase().equals("euros")) {
            return true;
        }
        if (word.toLowerCase().equals("yen")) {
            return true;
        }
        if (word.toLowerCase().equals("yuan")) {
            return true;
        }
        if (word.toLowerCase().equals("franc")) {
            return true;
        }
        return word.toLowerCase().equals("francs");
    }

    private static boolean isMoneySymbol(String word) {
        if (word.equals("$")) {
            return true;
        }
        if (word.equals("\u00a5")) {
            return true;
        }
        if (word.equals("\u00a3")) {
            return true;
        }
        return word.equals("\u20ac");
    }

    private static String findEntitiesPercent(String line) {
        String[] tokens = line.split("\\s+");
        ArrayList<String> wordTypes = new ArrayList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String word = token.split("_")[0];
            if (FindEntitiesUtils.isPercent(word)) {
                wordTypes.add("percent");
            } else if (word.equals("per")) {
                wordTypes.add("per");
            } else if (word.equals("cent")) {
                wordTypes.add("cent");
            } else {
                wordTypes.add(token.split("_")[1]);
            }
            ++n2;
        }
        line = FindEntitiesUtils.findEntitiesPattern("percentage", line, wordTypes, "CD CD CD percent");
        line = FindEntitiesUtils.findEntitiesPattern("percentage", line, wordTypes, "CD CD percent");
        line = FindEntitiesUtils.findEntitiesPattern("percentage", line, wordTypes, "CD percent");
        line = FindEntitiesUtils.findEntitiesPattern("percentage", line, wordTypes, "CD CD CD per cent");
        line = FindEntitiesUtils.findEntitiesPattern("percentage", line, wordTypes, "CD CD per cent");
        line = FindEntitiesUtils.findEntitiesPattern("percentage", line, wordTypes, "CD per cent");
        return line;
    }

    private static boolean isPercent(String word) {
        if (word.equals("percent")) {
            return true;
        }
        return word.equals("%");
    }

    private static String findEntitiesDates(String line) {
        String[] tokens = line.split("\\s+");
        ArrayList<String> wordTypes = new ArrayList<String>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String word = token.split("_")[0];
            if (FindEntitiesUtils.isFullMonth(word)) {
                wordTypes.add("fullMonth");
            } else if (FindEntitiesUtils.isShortMonth(word)) {
                wordTypes.add("shortMonth");
            } else if (FindEntitiesUtils.isDayOfMonth(word)) {
                wordTypes.add("dayOfMonth");
            } else if (FindEntitiesUtils.isYear(word)) {
                wordTypes.add("year");
            } else if (FindEntitiesUtils.isAdBc(word)) {
                wordTypes.add("adBc");
            } else if (FindEntitiesUtils.isAdBcYearAdBc(word)) {
                wordTypes.add("adBcYearAdBc");
            } else {
                wordTypes.add(token.split("_")[1]);
            }
            ++n2;
        }
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "fullMonth dayOfMonth , year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "shortMonth dayOfMonth , year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "fullMonth dayOfMonth year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "shortMonth dayOfMonth year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "dayOfMonth fullMonth year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "fullMonth year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "shortMonth year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "fullMonth dayOfMonth");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "shortMonth dayOfMonth");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "dayOfMonth fullMonth");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "adBc year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "adBc dayOfMonth");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "adBc CD CD");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "adBc CD");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "year adBc");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "dayOfMonth adBc");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "CD CD adBc");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "CD adBc");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "adBcYearAdBc");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "year");
        line = FindEntitiesUtils.findEntitiesPattern("date", line, wordTypes, "fullMonth");
        return line;
    }

    private static boolean isAdBcYearAdBc(String word) {
        if (!word.contains("-")) {
            return false;
        }
        String[] tokens = word.split("\\-");
        return tokens.length == 2 && (FindEntitiesUtils.isAdBcYear(tokens[0]) || FindEntitiesUtils.isAdBc(tokens[1]));
    }

    private static boolean isAdBcYear(String word) {
        return word.matches("([\\d]*[\\,\\.]?)*[\\d]+[MB]?");
    }

    private static boolean isAdBc(String word) {
        if (word.equals("AD")) {
            return true;
        }
        if (word.equals("A.D.")) {
            return true;
        }
        if (word.equals("A.D")) {
            return true;
        }
        if (word.equals("BC")) {
            return true;
        }
        if (word.equals("B.C.")) {
            return true;
        }
        if (word.equals("B.C")) {
            return true;
        }
        if (word.equals("CE")) {
            return true;
        }
        if (word.equals("C.E.")) {
            return true;
        }
        if (word.equals("C.E")) {
            return true;
        }
        if (word.equals("BCE")) {
            return true;
        }
        if (word.equals("B.C.E.")) {
            return true;
        }
        return word.equals("B.C.E");
    }

    private static boolean isDayOfMonth(String word) {
        if (word.equals("1st")) {
            return true;
        }
        if (word.equals("2nd")) {
            return true;
        }
        if (word.equals("3rd")) {
            return true;
        }
        if (word.equals("4th")) {
            return true;
        }
        if (word.equals("5th")) {
            return true;
        }
        if (word.equals("6th")) {
            return true;
        }
        if (word.equals("7th")) {
            return true;
        }
        if (word.equals("8th")) {
            return true;
        }
        if (word.equals("9th")) {
            return true;
        }
        if (word.equals("10th")) {
            return true;
        }
        if (word.equals("11th")) {
            return true;
        }
        if (word.equals("12th")) {
            return true;
        }
        if (word.equals("13th")) {
            return true;
        }
        if (word.equals("14th")) {
            return true;
        }
        if (word.equals("15th")) {
            return true;
        }
        if (word.equals("16th")) {
            return true;
        }
        if (word.equals("17th")) {
            return true;
        }
        if (word.equals("18th")) {
            return true;
        }
        if (word.equals("19th")) {
            return true;
        }
        if (word.equals("20th")) {
            return true;
        }
        if (word.equals("21st")) {
            return true;
        }
        if (word.equals("21nd")) {
            return true;
        }
        if (word.equals("23rd")) {
            return true;
        }
        if (word.equals("24th")) {
            return true;
        }
        if (word.equals("25th")) {
            return true;
        }
        if (word.equals("26th")) {
            return true;
        }
        if (word.equals("27th")) {
            return true;
        }
        if (word.equals("28th")) {
            return true;
        }
        if (word.equals("29th")) {
            return true;
        }
        if (word.equals("30th")) {
            return true;
        }
        if (word.equals("31st")) {
            return true;
        }
        if (word.equals("1")) {
            return true;
        }
        if (word.equals("2")) {
            return true;
        }
        if (word.equals("3")) {
            return true;
        }
        if (word.equals("4")) {
            return true;
        }
        if (word.equals("5")) {
            return true;
        }
        if (word.equals("6")) {
            return true;
        }
        if (word.equals("7")) {
            return true;
        }
        if (word.equals("8")) {
            return true;
        }
        if (word.equals("9")) {
            return true;
        }
        if (word.equals("10")) {
            return true;
        }
        if (word.equals("11")) {
            return true;
        }
        if (word.equals("12")) {
            return true;
        }
        if (word.equals("13")) {
            return true;
        }
        if (word.equals("14")) {
            return true;
        }
        if (word.equals("15")) {
            return true;
        }
        if (word.equals("16")) {
            return true;
        }
        if (word.equals("17")) {
            return true;
        }
        if (word.equals("18")) {
            return true;
        }
        if (word.equals("19")) {
            return true;
        }
        if (word.equals("20")) {
            return true;
        }
        if (word.equals("21")) {
            return true;
        }
        if (word.equals("21")) {
            return true;
        }
        if (word.equals("23")) {
            return true;
        }
        if (word.equals("24")) {
            return true;
        }
        if (word.equals("25")) {
            return true;
        }
        if (word.equals("26")) {
            return true;
        }
        if (word.equals("27")) {
            return true;
        }
        if (word.equals("28")) {
            return true;
        }
        if (word.equals("29")) {
            return true;
        }
        if (word.equals("30")) {
            return true;
        }
        if (word.equals("31")) {
            return true;
        }
        if (word.equals("first")) {
            return true;
        }
        if (word.equals("second")) {
            return true;
        }
        if (word.equals("third")) {
            return true;
        }
        if (word.equals("fourth")) {
            return true;
        }
        if (word.equals("fifth")) {
            return true;
        }
        if (word.equals("sixth")) {
            return true;
        }
        if (word.equals("seventh")) {
            return true;
        }
        if (word.equals("eighth")) {
            return true;
        }
        if (word.equals("ninth")) {
            return true;
        }
        if (word.equals("tenth")) {
            return true;
        }
        if (word.equals("eleventh")) {
            return true;
        }
        if (word.equals("twelfth")) {
            return true;
        }
        if (word.equals("thirteenth")) {
            return true;
        }
        if (word.equals("fourteenth")) {
            return true;
        }
        if (word.equals("fifteenth")) {
            return true;
        }
        if (word.equals("sixteenth")) {
            return true;
        }
        if (word.equals("seventeenth")) {
            return true;
        }
        if (word.equals("eighteenth")) {
            return true;
        }
        if (word.equals("nineteenth")) {
            return true;
        }
        if (word.equals("twentieth")) {
            return true;
        }
        if (word.equals("twenty-first")) {
            return true;
        }
        if (word.equals("twenty-second")) {
            return true;
        }
        if (word.equals("twenty-third")) {
            return true;
        }
        if (word.equals("twenty-fourth")) {
            return true;
        }
        if (word.equals("twenty-fifth")) {
            return true;
        }
        if (word.equals("twenty-sixth")) {
            return true;
        }
        if (word.equals("twenty-seventh")) {
            return true;
        }
        if (word.equals("twenty-eighth")) {
            return true;
        }
        if (word.equals("twenth-ninth")) {
            return true;
        }
        if (word.equals("thirtieth")) {
            return true;
        }
        return word.equals("thirty-first");
    }

    private static boolean isYear(String word) {
        if (word.length() != 4) {
            return false;
        }
        if (!word.matches("\\d\\d\\d\\d")) {
            return false;
        }
        return Integer.parseInt(word) <= 2100;
    }

    private static boolean isShortMonth(String word) {
        if (word.equals("Jan.")) {
            return true;
        }
        if (word.equals("Jan")) {
            return true;
        }
        if (word.equals("Feb.")) {
            return true;
        }
        if (word.equals("Feb")) {
            return true;
        }
        if (word.equals("Mar.")) {
            return true;
        }
        if (word.equals("Mar")) {
            return true;
        }
        if (word.equals("Apr.")) {
            return true;
        }
        if (word.equals("Apr")) {
            return true;
        }
        if (word.equals("May.")) {
            return true;
        }
        if (word.equals("May")) {
            return true;
        }
        if (word.equals("Jun.")) {
            return true;
        }
        if (word.equals("Jun")) {
            return true;
        }
        if (word.equals("Jul.")) {
            return true;
        }
        if (word.equals("Jul")) {
            return true;
        }
        if (word.equals("Aug.")) {
            return true;
        }
        if (word.equals("Aug")) {
            return true;
        }
        if (word.equals("Sep.")) {
            return true;
        }
        if (word.equals("Sep")) {
            return true;
        }
        if (word.equals("Sept.")) {
            return true;
        }
        if (word.equals("Sept")) {
            return true;
        }
        if (word.equals("Oct.")) {
            return true;
        }
        if (word.equals("Oct")) {
            return true;
        }
        if (word.equals("Nov.")) {
            return true;
        }
        if (word.equals("Nov")) {
            return true;
        }
        if (word.equals("Dec.")) {
            return true;
        }
        return word.equals("Dec");
    }

    private static boolean isFullMonth(String word) {
        if (word.equals("January")) {
            return true;
        }
        if (word.equals("February")) {
            return true;
        }
        if (word.equals("March")) {
            return true;
        }
        if (word.equals("April")) {
            return true;
        }
        if (word.equals("May")) {
            return true;
        }
        if (word.equals("June")) {
            return true;
        }
        if (word.equals("July")) {
            return true;
        }
        if (word.equals("August")) {
            return true;
        }
        if (word.equals("September")) {
            return true;
        }
        if (word.equals("October")) {
            return true;
        }
        if (word.equals("November")) {
            return true;
        }
        return word.equals("December");
    }

    private static String findEntitiesPattern(String entityType, String line, List<String> wordTypes, String pattern) {
        String[] tokens = line.split("\\s+");
        if (tokens.length != wordTypes.size()) {
            throw new RuntimeException("WTF?!?");
        }
        String[] patternTypes = pattern.split("\\s");
        int nextPatternType = 0;
        ArrayList<Integer> startIndeces = new ArrayList<Integer>();
        ArrayList<Integer> endIndeces = new ArrayList<Integer>();
        boolean blocked = false;
        int i = 0;
        while (i < wordTypes.size()) {
            if (tokens[i].startsWith("[[")) {
                blocked = true;
                nextPatternType = 0;
            }
            if (blocked) {
                if (tokens[i].endsWith("]]")) {
                    blocked = false;
                }
            } else {
                String type = wordTypes.get(i);
                if (type.equals(patternTypes[nextPatternType])) {
                    if (++nextPatternType == patternTypes.length) {
                        endIndeces.add(i + 1);
                        startIndeces.add(i - patternTypes.length + 1);
                        nextPatternType = 0;
                    }
                } else {
                    nextPatternType = 0;
                }
            }
            ++i;
        }
        i = 0;
        while (i < startIndeces.size()) {
            line = FindEntitiesUtils.addEntity(entityType, line, (Integer)startIndeces.get(i), (Integer)endIndeces.get(i));
            ++i;
        }
        return line;
    }

    private static String addEntity(String type, String line, Integer start, Integer end) {
        StringBuilder sb2 = new StringBuilder();
        String[] tokens = line.split("\\s+");
        int i = 0;
        while (i < tokens.length) {
            if (i == start) {
                sb2.append(" [[" + type + "|" + tokens[i]);
            } else {
                sb2.append(" " + tokens[i]);
            }
            if (i == end - 1) {
                sb2.append("]]");
            }
            ++i;
        }
        return sb2.toString().substring(1);
    }

    private static String findEntities(String type, String line, String ... entityPos) {
        StringBuilder sb2 = new StringBuilder();
        boolean inEntity = false;
        boolean blocked = false;
        String[] stringArray = line.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.startsWith("[[")) {
                blocked = true;
                if (inEntity) {
                    inEntity = false;
                    sb2.append("]]");
                }
            }
            if (blocked) {
                if (token.endsWith("]]")) {
                    blocked = false;
                }
                sb2.append(" " + token);
            } else {
                String pos = token.split("_")[1];
                if (FindEntitiesUtils.equalsOne(pos, entityPos)) {
                    if (!inEntity) {
                        inEntity = true;
                        sb2.append(" [[");
                        if (type != null) {
                            sb2.append(String.valueOf(type) + "|");
                        }
                        sb2.append(token);
                    } else {
                        sb2.append(" " + token);
                    }
                } else {
                    if (inEntity) {
                        inEntity = false;
                        sb2.append("]]");
                    }
                    sb2.append(" " + token);
                }
            }
            ++n2;
        }
        if (inEntity) {
            sb2.append("]]");
        }
        return sb2.toString().substring(1);
    }

    private static boolean equalsOne(String pos, String[] entityPos) {
        String[] stringArray = entityPos;
        int n = entityPos.length;
        int n2 = 0;
        while (n2 < n) {
            String ep = stringArray[n2];
            if (pos.equals(ep)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String normalizeLetters(String string) {
        String s = string;
        s = s.replace("\u00e0", "a");
        s = s.replace("\u00e8", "e");
        s = s.replace("\u00ec", "i");
        s = s.replace("\u00f2", "o");
        s = s.replace("\u00f9", "u");
        s = s.replace("\u00e1", "a");
        s = s.replace("\u00e9", "e");
        s = s.replace("\u00ed", "i");
        s = s.replace("\u00f3", "o");
        s = s.replace("\u00fa", "u");
        s = s.replace("\u00fd", "y");
        s = s.replace("\u00e2", "a");
        s = s.replace("\u00ea", "e");
        s = s.replace("\u00ee", "i");
        s = s.replace("\u00f4", "o");
        s = s.replace("\u00fb", "u");
        s = s.replace("\u00e4", "a");
        s = s.replace("\u00eb", "e");
        s = s.replace("\u00ef", "i");
        s = s.replace("\u00f6", "o");
        s = s.replace("\u00fc", "u");
        s = s.replace("\u00e3", "a");
        s = s.replace("\u00f5", "o");
        s = s.replace("\u00f1", "n");
        s = s.replace("\u00e5", "a");
        s = s.replace("\u00f8", "o");
        s = s.replace("\u00e7", "c");
        s = s.replace("\u0161", "s");
        s = s.replace("\u017e", "z");
        s = s.replace("\u00e6", "ae");
        s = s.replace("\u0153", "oe");
        s = s.replace("\u00df", "ss");
        s = s.replace("\u00de", "th");
        s = s.replace("\u00f0", "th");
        return s;
    }
}

