/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.paraphraseMining;

import edu.columbia.ob.gen.paraphraseMining.DbpediaWordNetTaxonomy;
import edu.columbia.ob.gen.paraphraseMining.FindEntitiesUtils;
import edu.columbia.ob.gen.paraphraseMining.ParaphraseUtils;
import edu.columbia.ob.gen.paraphraseMining.Taxonomy;
import java.io.FileWriter;
import java.io.PrintWriter;
import ob.util.Utils;

public class FindEntities {
    private static Taxonomy _taxonomy;

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            throw new RuntimeException("expected four arguments: pos tagged corpus (input) file, output file, domain article type (optional) and domain article list file (optional)");
        }
        String infile = args[0];
        String outfile = args[1];
        String domainArticleType = args[2];
        String domainArticleListFile = args[3];
        _taxonomy = new DbpediaWordNetTaxonomy(null, ParaphraseUtils.getDomainCorpusTaxonomy(domainArticleType, domainArticleListFile));
        PrintWriter pw = new PrintWriter(new FileWriter(outfile));
        int articles = 0;
        for (String line : Utils.readLinesDynamically(infile)) {
            if (line.startsWith("####")) {
                System.out.println("at article " + ++articles);
            }
            if (line.startsWith("####") || line.startsWith("==") || FindEntitiesUtils.hasNoVerb(line) || line.contains("|") || !FindEntitiesUtils.passes(line = FindEntitiesUtils.findEntitiesInPosSentence(line, _taxonomy), 2)) continue;
            pw.println(line);
        }
        pw.close();
    }
}

