/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.paraphraseMining;

import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.paraphraseMining.Taxonomy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ob.util.Utils;

public class DbpediaWordNetTaxonomy
implements Taxonomy {
    private static final String WORDNET_SYNSET_FILE = PreGenEnv.getProperty("wordnet.synset.file");
    private static final String WORDNET_TAXONOMY_FILE = PreGenEnv.getProperty("wordnet.taxonomy.file");
    private static final String DBPEDIA_FILE = PreGenEnv.getProperty("dbpedia.types.file");
    private static final String DBPEDIA_TAXONOMY_FILE = PreGenEnv.getProperty("dbpedia.taxonomy.file");
    private static final String REDIRECT_FILE = PreGenEnv.getProperty("wikipedia.redirect.file");
    private Map<String, Map<String, String>> _wordToSynsets = this.readWordToSynset(WORDNET_SYNSET_FILE);
    private Map<String, Collection<String>> _synsetToWords = this.readSynsetToWords(WORDNET_SYNSET_FILE);
    private Map<String, Collection<String>> _hypernyms = this.readHypernyms(WORDNET_TAXONOMY_FILE);
    private Map<String, String> _redirects;
    private static Set<String> _nullHypernyms = new HashSet<String>();

    public DbpediaWordNetTaxonomy() {
        this(null);
    }

    public DbpediaWordNetTaxonomy(Collection<String> corpusEntities) {
        this(corpusEntities, null);
    }

    public DbpediaWordNetTaxonomy(Collection<String> corpusEntities, Map<String, String> domainCorpusTaxonomy) {
        this.addDbpediaHypernyms(DBPEDIA_TAXONOMY_FILE, DBPEDIA_FILE, this._hypernyms, this._wordToSynsets, this._synsetToWords, corpusEntities, domainCorpusTaxonomy);
        this._redirects = this.readRedirects(REDIRECT_FILE, this._wordToSynsets);
    }

    private Map<String, String> readRedirects(String redirectFile, Map<String, Map<String, String>> wordToSynsets) {
        HashMap<String, String> redirects = new HashMap<String, String>();
        for (String line : Utils.readLinesDynamically(redirectFile)) {
            String[] tokens = line.split("\\t");
            String redirect = this.normalize(tokens[1]);
            if (!wordToSynsets.containsKey(redirect)) continue;
            String word = this.normalize(tokens[0]);
            redirects.put(word, redirect);
        }
        return redirects;
    }

    private void addDbpediaHypernyms(String dbpediaTaxonomyFile, String dbpediaFile, Map<String, Collection<String>> hypernyms, Map<String, Map<String, String>> wordToSynsets, Map<String, Collection<String>> synsetToWords, Collection<String> corpusEntities, Map<String, String> domainCorpusTaxonomy) {
        String newSynset;
        String newSense;
        Map<String, String> synsets;
        Map<String, String> hypernymSynsets;
        String hypernym;
        String term;
        String[] tokens;
        int c = 0;
        for (String line : Utils.readLinesDynamically(dbpediaTaxonomyFile)) {
            tokens = line.split("\\t");
            term = this.normalize(this.separateByCase(tokens[0]));
            hypernym = this.normalize(this.separateByCase(tokens[1]));
            hypernymSynsets = wordToSynsets.get(hypernym);
            if (hypernymSynsets == null) {
                String newSense2;
                hypernymSynsets = new TreeMap<String, String>();
                String newSynset2 = newSense2 = "996" + hypernym;
                hypernymSynsets.put(newSense2, newSynset2);
                wordToSynsets.put(hypernym, hypernymSynsets);
                synsetToWords.put(newSynset2, Utils.list(String.valueOf(hypernym) + ":::" + newSense2));
            }
            if ((synsets = wordToSynsets.get(term)) == null) {
                synsets = new TreeMap<String, String>();
                wordToSynsets.put(term, synsets);
            }
            if (this.hypernymAlreadyExists(hypernymSynsets, synsets, hypernyms)) continue;
            newSense = "997" + hypernym;
            newSynset = String.valueOf(term) + "_" + newSense;
            synsets.put(newSense, newSynset);
            synsetToWords.put(newSynset, Utils.list(String.valueOf(term) + ":::" + newSense));
            hypernyms.put(newSynset, Utils.list(hypernymSynsets.values().iterator().next()));
            ++c;
        }
        System.out.println("added " + c + " relations from the DBPedia taxonomy");
        c = 0;
        for (String line : Utils.readLinesDynamically(dbpediaFile)) {
            if (line.startsWith("#")) continue;
            tokens = line.split("\\s+");
            term = this.normalize(this.removeUrl(tokens[0]));
            if (corpusEntities != null && !corpusEntities.contains(term) || !tokens[2].contains("dbpedia.org")) continue;
            hypernym = this.normalize(this.separateByCase(this.removeUrl(tokens[2])));
            hypernymSynsets = wordToSynsets.get(hypernym);
            if (hypernymSynsets == null) {
                if (_nullHypernyms.contains(hypernym)) continue;
                System.err.println("null hypernym synset: " + hypernym);
                _nullHypernyms.add(hypernym);
                continue;
            }
            synsets = wordToSynsets.get(term);
            if (synsets == null) {
                synsets = new TreeMap<String, String>();
                wordToSynsets.put(term, synsets);
            }
            if (this.hypernymAlreadyExists(hypernymSynsets, synsets, hypernyms)) continue;
            newSense = "998" + hypernym;
            newSynset = String.valueOf(term) + "_" + newSense;
            synsets.put(newSense, newSynset);
            synsetToWords.put(newSynset, Utils.list(String.valueOf(term) + ":::" + newSense));
            hypernyms.put(newSynset, Utils.list(hypernymSynsets.values().iterator().next()));
            ++c;
        }
        System.out.println("added " + c + " terms from DBPedia");
        if (domainCorpusTaxonomy != null) {
            c = 0;
            for (String term2 : domainCorpusTaxonomy.keySet()) {
                String hypernym2 = this.normalize(domainCorpusTaxonomy.get(term2));
                term2 = this.normalize(term2);
                if (corpusEntities != null && !corpusEntities.contains(term2)) continue;
                Map<String, String> hypernymSynsets2 = wordToSynsets.get(hypernym2);
                if (hypernymSynsets2 == null) {
                    if (_nullHypernyms.contains(hypernym2)) continue;
                    System.err.println("null hypernym synset: " + hypernym2);
                    _nullHypernyms.add(hypernym2);
                    continue;
                }
                Map<String, String> synsets2 = wordToSynsets.get(term2);
                if (synsets2 == null) {
                    synsets2 = new TreeMap<String, String>();
                    wordToSynsets.put(term2, synsets2);
                }
                if (this.hypernymAlreadyExists(hypernymSynsets2, synsets2, hypernyms)) continue;
                String newSense3 = "999" + hypernym2;
                String newSynset3 = String.valueOf(term2) + "_" + newSense3;
                synsets2.put(newSense3, newSynset3);
                synsetToWords.put(newSynset3, Utils.list(String.valueOf(term2) + ":::" + newSense3));
                hypernyms.put(newSynset3, Utils.list(hypernymSynsets2.values().iterator().next()));
                ++c;
            }
            System.out.println("added " + c + " terms from domain article names");
        }
    }

    private String separateByCase(String string) {
        StringBuilder sb2 = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb2.append("_");
            }
            sb2.append(c);
            ++i;
        }
        return sb2.toString();
    }

    private boolean hypernymAlreadyExists(Map<String, String> hypernymSynsets, Map<String, String> synsets, Map<String, Collection<String>> hypernyms) {
        for (String synset : synsets.values()) {
            for (String hypernymSynset : hypernymSynsets.values()) {
                if (hypernyms.get(synset) == null || !hypernyms.get(synset).contains(hypernymSynset)) continue;
                return true;
            }
        }
        return false;
    }

    private String removeUrl(String string) {
        return string.substring(string.lastIndexOf("/") + 1, string.indexOf(">"));
    }

    private Map<String, Collection<String>> readHypernyms(String taxonomyFile) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (String line : Utils.readLinesDynamically(taxonomyFile)) {
            String[] tokens = line.split("\\t");
            String synsetId = tokens[0];
            ArrayList<String> hypernyms = new ArrayList<String>();
            int i = 1;
            while (i < tokens.length) {
                hypernyms.add(tokens[i]);
                ++i;
            }
            map.put(synsetId, hypernyms);
        }
        return map;
    }

    private Map<String, Map<String, String>> readWordToSynset(String synsetFile) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (String line : Utils.readLinesDynamically(synsetFile)) {
            String[] tokens = line.split("\\t");
            String synsetId = tokens[0];
            int i = 1;
            while (i < tokens.length) {
                String wordWithSense = tokens[i];
                String[] wordAndSense = wordWithSense.split(":::");
                String word = this.normalize(wordAndSense[0]);
                TreeMap<String, String> wordMap = (TreeMap<String, String>)map.get(word);
                if (wordMap == null) {
                    wordMap = new TreeMap<String, String>();
                    map.put(word, wordMap);
                }
                wordMap.put(wordAndSense[1], synsetId);
                ++i;
            }
        }
        return map;
    }

    private Map<String, Collection<String>> readSynsetToWords(String synsetFile) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (String line : Utils.readLinesDynamically(synsetFile)) {
            String[] tokens = line.split("\\t");
            String synsetId = tokens[0];
            ArrayList<String> words = new ArrayList<String>();
            int i = 1;
            while (i < tokens.length) {
                words.add(tokens[i]);
                ++i;
            }
            map.put(synsetId, words);
        }
        return map;
    }

    private String normalize(String string) {
        return string.replaceAll("\\s+", "_").toLowerCase();
    }

    @Override
    public Collection<String> getSenses(String word) {
        String redirect;
        Map<String, String> senses = this._wordToSynsets.get(word);
        if (senses == null && (redirect = this._redirects.get(word)) != null) {
            senses = this._wordToSynsets.get(redirect);
        }
        if (senses == null) {
            return null;
        }
        return senses.values();
    }

    @Override
    public Collection<String> getTypes(String sense) {
        return this._hypernyms.get(sense);
    }

    @Override
    public Collection<String> getWords(String sense) {
        return this._synsetToWords.get(sense);
    }

    @Override
    public Collection<String> getAllWords() {
        return this._wordToSynsets.keySet();
    }
}

