/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.generator;

import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.domainMessageBuilder.DomainMessageBuilder;
import edu.columbia.ob.gen.domainMessageBuilder.PotentialSelectionDomainMessageBuilder;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.generator.Generator;
import edu.columbia.ob.gen.planner.DiscourseAndCoherenceDocumentPlanner;
import edu.columbia.ob.gen.planner.DocumentPlanner;
import edu.columbia.ob.gen.realizer.Realizer;
import java.util.ArrayList;
import java.util.Collection;

public class TestGenerator
implements Generator {
    private DomainInfoMgr _domainInfoMgr;
    private DomainMessageBuilder _domainMessageBuilder;
    private DocumentPlanner _documentPlanner;
    private Realizer _realizer;

    public TestGenerator(String functionalDomain, String subjectDomain) {
        this._domainInfoMgr = PreGenEnv.getDomainInfoMgr(functionalDomain, subjectDomain);
        this._domainMessageBuilder = new PotentialSelectionDomainMessageBuilder(this._domainInfoMgr);
        this._documentPlanner = new DiscourseAndCoherenceDocumentPlanner(this._domainInfoMgr);
        this._realizer = PreGenEnv.getRealizer(subjectDomain);
    }

    public Collection<String> generateParagraphs(Collection<SemanticUnit> coreMessages) {
        Collection<SemanticUnit> domainMessages = this._domainMessageBuilder.getDomainMessages(coreMessages);
        Collection<SemanticUnit> allMessages = TestGenerator.combine(coreMessages, domainMessages);
        Collection<Paragraph> paragraphs = this._documentPlanner.getParagraphs(allMessages);
        Collection<String> textParagraphs = this._realizer.realize(paragraphs);
        for (String textParagraph : textParagraphs) {
            System.out.println(textParagraph);
            System.out.println();
        }
        return textParagraphs;
    }

    @SafeVarargs
    private static <T> Collection<T> combine(Collection<T> ... collections) {
        ArrayList<T> combined = new ArrayList<T>();
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> collection = collectionArray[n2];
            combined.addAll(collection);
            ++n2;
        }
        return combined;
    }
}

