/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ob.util.Utils;
import ob.util.collections.MultiMap3;

public class RdfUtils {
    public static Set<String> readDomainEntities(String domainEntitiesFile) {
        HashSet<String> entities = new HashSet<String>();
        for (String line : Utils.readLinesDynamically(domainEntitiesFile)) {
            entities.add(RdfUtils.normalizeEntity(line));
        }
        return entities;
    }

    public static String normalizeEntity(String entity) {
        entity = entity.replace("_", " ");
        return entity;
    }

    public static MultiMap3<String, String, String> readRdfTriples(String rdfTriplesFile) {
        MultiMap3<String, String, String> map = new MultiMap3<String, String, String>(){

            @Override
            protected Collection<String> newCollection() {
                return new HashSet<String>();
            }
        };
        for (String line : Utils.readLinesDynamically(rdfTriplesFile)) {
            String[] tokens = line.split("\\t");
            if (tokens.length != 3) {
                System.err.println("weird rdf line: " + line);
                continue;
            }
            map.add(RdfUtils.normalizeEntity(tokens[0]), tokens[1], RdfUtils.normalizeEntity(tokens[2]));
        }
        return map;
    }

    public static MultiMap3<String, String, String> readRdfTriplesNoNormalization(String rdfTriplesFile) {
        MultiMap3<String, String, String> map = new MultiMap3<String, String, String>(){

            @Override
            protected Collection<String> newCollection() {
                return new HashSet<String>();
            }
        };
        for (String line : Utils.readLinesDynamically(rdfTriplesFile)) {
            String[] tokens = line.split("\\t");
            if (tokens.length != 3) {
                System.err.println("weird rdf line: " + line);
                continue;
            }
            map.add(tokens[0], tokens[1], tokens[2]);
        }
        return map;
    }
}

