/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.core.TemplateParameterList;
import edu.columbia.ob.gen.domainMessageBuilder.DomainMessageBuilder;
import edu.columbia.ob.gen.domainMessageBuilder.PotentialSelectionDomainMessageBuilder;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.env.PreGenRuntime;
import edu.columbia.ob.gen.env.StaticVectors;
import edu.columbia.ob.gen.extractor.ExtractorUtils;
import edu.columbia.ob.gen.gems.rdfApps.RdfUtils;
import edu.columbia.ob.gen.generator.Generator;
import edu.columbia.ob.gen.planner.DiscourseAndCoherenceDocumentPlanner;
import edu.columbia.ob.gen.planner.DocumentPlanner;
import edu.columbia.ob.gen.realizer.LanguageModelTemplateRealizer;
import edu.columbia.ob.gen.realizer.Realizer;
import edu.columbia.ob.gen.realizer.TaxonomyLexicalChoice;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import ob.util.Pair;
import ob.util.Utils;
import ob.util.collections.MultiMap;

public class RdfAppGenerator
implements Generator {
    private static final String FUNCTIONAL_DOMAIN = "cdesc";
    private static final String CORE_TYPE = "company";
    private static boolean _useParaphrases = true;
    private static boolean _useDiscourseModel = true;
    private static boolean _useTaxonomy = true;
    private static boolean _useHybrid = true;
    private String _subjectDomain;
    private DomainInfoMgr _domainInfoMgr;
    private DomainMessageBuilder _domainMessageBuilder;
    private DocumentPlanner _documentPlanner;
    private Realizer _realizer;
    static int multiCount = 0;

    public RdfAppGenerator(String subjectDomain) {
        this._subjectDomain = subjectDomain;
        this._domainInfoMgr = PreGenEnv.getDomainInfoMgr(FUNCTIONAL_DOMAIN, this._subjectDomain);
        this._domainMessageBuilder = new PotentialSelectionDomainMessageBuilder(this._domainInfoMgr);
        this._documentPlanner = new DiscourseAndCoherenceDocumentPlanner(this._domainInfoMgr, _useDiscourseModel);
        this._realizer = new LanguageModelTemplateRealizer(subjectDomain, new TaxonomyLexicalChoice(subjectDomain, _useTaxonomy), _useParaphrases, _useDiscourseModel);
    }

    public Collection<SemanticUnit> getMessages(String entity) {
        Collection<SemanticUnit> messages = this.selectCoreMessages(entity);
        if (messages == null) {
            return null;
        }
        if (_useHybrid) {
            Collection<SemanticUnit> domainMessages = this._domainMessageBuilder.getDomainMessages(messages);
            messages = RdfAppGenerator.combine(messages, domainMessages);
            messages = this.removeDuplicates(messages);
        }
        return messages;
    }

    private Collection<SemanticUnit> removeDuplicates(Collection<SemanticUnit> messages) {
        ArrayList<SemanticUnit> adj = new ArrayList<SemanticUnit>();
        for (SemanticUnit message : messages) {
            boolean duplicate = false;
            for (SemanticUnit existing : adj) {
                if (!this.sameMessage(existing, message)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            adj.add(message);
        }
        return adj;
    }

    private boolean sameMessage(SemanticUnit existing, SemanticUnit message) {
        if (existing.getParameters().size() != message.getParameters().size()) {
            return false;
        }
        int i = 0;
        while (i < existing.getParameters().size()) {
            if (!existing.getParameters().get(i).getName().equals(message.getParameters().get(i).getName())) {
                return false;
            }
            ++i;
        }
        if (existing.getStt().getTemplates().size() != message.getStt().getTemplates().size()) {
            return false;
        }
        i = 0;
        while (i < existing.getStt().getTemplates().size()) {
            if (!this.norm(existing.getStt().getTemplates().get(i)).equals(this.norm(message.getStt().getTemplates().get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String norm(String string) {
        return string.toLowerCase().trim().replaceAll("[^A-Za-z0-9\\s]", "");
    }

    public Collection<String> generateParagraphs(String entity) {
        Collection<SemanticUnit> messages = this.getMessages(entity);
        if (messages == null) {
            return null;
        }
        Collection<Paragraph> paragraphs = this._documentPlanner.getParagraphs(messages);
        Collection<String> textParagraphs = this._realizer.realize(paragraphs);
        return textParagraphs;
    }

    private Collection<SemanticUnit> selectCoreMessages(String entity) {
        String entityId = this._domainInfoMgr.getEntityId(entity);
        Collection<SemanticUnit> allCoreMessages = this._domainInfoMgr.getCoreDomainMessagesForParameter(this._domainInfoMgr.getTemplateParameter(entityId));
        return this.adjustAndFilter(allCoreMessages, entityId);
    }

    private Collection<SemanticUnit> adjustAndFilter(Collection<SemanticUnit> messages, String entityId) {
        Collection<SemanticUnit> extraMessages;
        if (messages == null) {
            return null;
        }
        TemplateParameter entityParam = this._domainInfoMgr.getTemplateParameter(entityId);
        MultiMap<SemanticTypedTemplate, SemanticUnit> sttToSu = new MultiMap<SemanticTypedTemplate, SemanticUnit>();
        for (SemanticUnit su : messages) {
            if (!entityParam.equals(su.getParameters().get(0))) continue;
            sttToSu.add(su.getStt(), su);
        }
        ArrayList<SemanticUnit> adj = new ArrayList<SemanticUnit>();
        for (SemanticTypedTemplate stt : sttToSu.keySet()) {
            if (sttToSu.get(stt).size() == 1) {
                adj.add((SemanticUnit)sttToSu.get(stt).iterator().next());
                continue;
            }
            if (stt.getEntityTypes().size() != 2) {
                adj.addAll(sttToSu.get(stt));
                System.err.println("WTF? " + stt.getId());
                continue;
            }
            TemplateParameterList objectsParam = new TemplateParameterList();
            boolean past = false;
            for (SemanticUnit su : sttToSu.get(stt)) {
                if (su.isPast()) {
                    past = true;
                }
                if (!su.getParameters().get(0).equals(entityParam)) {
                    throw new RuntimeException("WTF?!?");
                }
                objectsParam.addParameter(su.getParameters().get(1));
            }
            adj.add(ExtractorUtils.makeSu(Utils.list(entityParam, objectsParam), stt, past));
        }
        if (_useParaphrases && (extraMessages = this._domainInfoMgr.getPotentialDomainMessagesForParameter(this._domainInfoMgr.getTemplateParameter(entityId))) != null) {
            for (SemanticUnit su : extraMessages) {
                if (!this.isFullRelationStt(su.getStt())) continue;
                HashSet<String> suRelations = new HashSet<String>(su.getStt().getEntityRelations().values());
                HashSet<SemanticUnit> toRemove = new HashSet<SemanticUnit>();
                for (SemanticUnit existingSu : adj) {
                    if (existingSu.getStt().getEntityRelations().size() != 1 || !suRelations.contains(existingSu.getStt().getEntityRelations().values().iterator().next())) continue;
                    toRemove.add(existingSu);
                }
                System.out.println("MULTI-RELATION SU REPLACEMENT!  removing " + toRemove.size() + " sus for this one: " + su.getStt().getTemplates().iterator().next());
                adj.removeAll(toRemove);
                adj.add(su);
                ++multiCount;
            }
        }
        return adj;
    }

    private boolean isFullRelationStt(SemanticTypedTemplate stt) {
        HashSet<Integer> entityIndeces = new HashSet<Integer>();
        int i = 0;
        while (i < stt.getEntityTypes().size()) {
            entityIndeces.add(i);
            ++i;
        }
        for (Pair<Integer> indexPair : stt.getEntityRelations().keySet()) {
            entityIndeces.remove(indexPair.getFirst());
            entityIndeces.remove(indexPair.getSecond());
        }
        return entityIndeces.isEmpty();
    }

    @SafeVarargs
    private static <T> Collection<T> combine(Collection<T> ... collections) {
        HashSet<T> combined = new HashSet<T>();
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> collection = collectionArray[n2];
            combined.addAll(collection);
            ++n2;
        }
        return new ArrayList(combined);
    }

    public static void main(String[] args) throws Exception {
        PreGenRuntime.setCoreType(CORE_TYPE);
        String domainName = "automotive-expanded2";
        String domainEntitiesFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "selected_domain_articles").getAbsolutePath();
        RdfAppGenerator generator = new RdfAppGenerator(domainName);
        List<String> entities = Utils.readLines(domainEntitiesFile);
        ArrayList<SemanticUnit> allMessages = new ArrayList<SemanticUnit>();
        for (String entity : entities) {
            Collection<SemanticUnit> messages = generator.getMessages(entity = RdfUtils.normalizeEntity(entity));
            if (messages == null) continue;
            allMessages.addAll(messages);
        }
        StaticVectors.setCorpusTerms(allMessages, RdfAppGenerator.readTaxonomyTerms(domainName));
        File dir = new File("C:/dev/working/PreGen", String.valueOf(domainName) + (_useDiscourseModel ? "" : "-ndm") + (_useTaxonomy ? "" : "-ntl") + (_useParaphrases ? "" : "-npr") + (_useHybrid ? "" : "-nhg"));
        dir.mkdirs();
        for (String entity : entities) {
            System.out.println("*** " + entity + " ***");
            entity = RdfUtils.normalizeEntity(entity);
            PreGenRuntime.setInstanceEntity(entity);
            Collection<String> paragraphs = generator.generateParagraphs(entity);
            if (paragraphs == null) continue;
            File outfile = new File(dir, entity.toLowerCase().replace(" ", "_").replaceAll("[^a-z0-9\\_]", ""));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8"));
            for (String paragraph : paragraphs) {
                pw.println(paragraph);
                pw.println();
            }
            pw.close();
            StaticVectors.clearCache();
        }
        System.out.println("multi count: " + multiCount);
    }

    private static Collection<String> readTaxonomyTerms(String domainName) {
        HashSet<String> terms = new HashSet<String>();
        for (String line : Utils.readLinesDynamically(new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "taxonomy").getAbsolutePath())) {
            String term;
            String[] tokens = line.split("\\t");
            String[] stringArray = tokens[0].split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                term = stringArray[n2];
                terms.add(term);
                ++n2;
            }
            stringArray = tokens[1].split("\\s");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                term = stringArray[n2];
                terms.add(term);
                ++n2;
            }
        }
        return terms;
    }
}

