/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.SemanticTypedTemplateImpl;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.core.TemplateParameterSingular;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.extractor.ExtractorUtils;
import edu.columbia.ob.gen.gems.rdfApps.CdescDefinition;
import edu.columbia.ob.gen.gems.rdfApps.RdfAppDefinition;
import edu.columbia.ob.gen.gems.rdfApps.RdfUtils;
import edu.columbia.ob.gen.paraphraseMining.DbpediaWordNetTaxonomy;
import edu.columbia.ob.gen.paraphraseMining.FindEntitiesUtils;
import edu.columbia.ob.gen.paraphraseMining.Taxonomy;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ob.util.Pair;
import ob.util.Utils;
import ob.util.collections.MultiMap;
import ob.util.collections.MultiMap3;

public class RdfAppExtractCoreStts2 {
    private static final RdfAppDefinition _rad = new CdescDefinition();
    private static Map<String, String> _currencies = new HashMap<String, String>();
    private static Map<String, String> _entityToIdMap;
    static List<SemanticTypedTemplate> _allParamStts;
    static Map<String, String> _extraEntityToId;
    static int _extraEntityIdCounter;
    private static int _sttIdCounter;
    static Map<String, String> _entityToType;

    static {
        _currencies.put("usDollar", "USD");
        _currencies.put("euro", "EUR");
        _currencies.put("japaneseYen", "JPY");
        _currencies.put("poundSterling", "GBP");
        _currencies.put("romanianNewLeu", "RON");
        _currencies.put("ukrainianHryvnia", "UAH");
        _currencies.put("swedishKrona", "SEK");
        _currencies.put("russianRouble", "RUB");
        _currencies.put("polishZ\\u0142oty", "PLN");
        _currencies.put("indianRupee", "INR");
        _allParamStts = new ArrayList<SemanticTypedTemplate>();
        _extraEntityToId = new LinkedHashMap<String, String>();
        _extraEntityIdCounter = 0;
        _sttIdCounter = 0;
        _entityToType = new HashMap<String, String>(){

            @Override
            public String get(Object key) {
                String value = (String)super.get(key);
                if (value == null) {
                    return "type";
                }
                return value;
            }

            @Override
            public String put(String key, String value) {
                if (this.containsKey(key)) {
                    if (value.equals(this.get(key))) {
                        return value;
                    }
                    if (value.equals(_rad.getDomainEntityType()) || this.get(key).equals(_rad.getDomainEntityType())) {
                        return super.put(key, _rad.getDomainEntityType());
                    }
                    return super.put(key, "type");
                }
                return super.put(key, value);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("USAGE: RdfAppExtractCoreStts <domainName>");
            System.exit(0);
        }
        String domainName = args[0];
        String domainEntitiesFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "domain_entities").getAbsolutePath();
        _entityToIdMap = ExtractorUtils.makeDomainEntityToIdMap(RdfUtils.readDomainEntities(domainEntitiesFile));
        Set<String> originalEntities = RdfUtils.readDomainEntities(new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "selected_domain_articles").getAbsolutePath());
        _entityToType.putAll(RdfAppExtractCoreStts2.getCoreEntityTypes(_entityToIdMap.keySet(), originalEntities));
        ExtractorUtils.registerDomainEntities(domainName, _entityToIdMap, _entityToType);
        String rdfTriplesFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "rdf_triples").getAbsolutePath();
        String domainCorpusPosFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "corpus.pos").getAbsolutePath();
        MultiMap3<String, String, String> triples = RdfUtils.readRdfTriples(rdfTriplesFile);
        for (Pair<String> pair : _rad.getRedundencyPairs()) {
            RdfAppExtractCoreStts2.removeRedudencies(triples, pair.getFirst(), pair.getSecond());
        }
        RdfAppExtractCoreStts2.fixObjectFormatting(triples);
        for (String subject : triples.keySet()) {
            for (String string : triples.get(subject).keySet()) {
                for (String object : triples.get(subject).get(string)) {
                    String knownType;
                    String surfaceType = RdfAppExtractCoreStts2.getSurfaceType(object);
                    if (surfaceType != null) {
                        _entityToType.put(object, surfaceType);
                    }
                    if ((knownType = _rad.getKnownType(string)) == null) continue;
                    _entityToType.put(object, knownType);
                }
            }
        }
        ArrayList<SemanticTypedTemplate> stts = new ArrayList<SemanticTypedTemplate>();
        HashMap<Object, SemanticTypedTemplateImpl> basePredicateStts = new HashMap<Object, SemanticTypedTemplateImpl>();
        for (Pair<String> pair : RdfAppExtractCoreStts2.getAllPredicatesAndTypes(triples)) {
            String predicate = pair.getFirst();
            String type = pair.getSecond();
            if (RdfAppExtractCoreStts2.badPredicate(predicate)) continue;
            HashMap<Pair<Integer>, String> relations = new HashMap<Pair<Integer>, String>();
            relations.put(new Pair<Integer>(0, 1), predicate);
            String id = RdfAppExtractCoreStts2.getNextDomainSttId();
            SemanticTypedTemplateImpl stt = new SemanticTypedTemplateImpl(id, Utils.list(type, "type"), relations, RdfAppExtractCoreStts2.makeBasePredicateTemplates(predicate), RdfAppExtractCoreStts2.makeBasePredicateListTemplates(predicate), 1.0);
            stts.add(stt);
            basePredicateStts.put(predicate, stt);
            _allParamStts.add(stt);
        }
        HashMap<Pair<SemanticTypedTemplate>, String> hashMap = new HashMap<Pair<SemanticTypedTemplate>, String>();
        for (Pair pair : _rad.getDiscoursePredicatePairs().keySet()) {
            hashMap.put(new Pair<SemanticTypedTemplate>((SemanticTypedTemplate)basePredicateStts.get(pair.getFirst()), (SemanticTypedTemplate)basePredicateStts.get(pair.getSecond())), _rad.getDiscoursePredicatePairs().get(pair));
        }
        ExtractorUtils.registerDomainSttDiscourse(hashMap, domainName);
        ArrayList<SemanticUnit> arrayList = new ArrayList<SemanticUnit>();
        for (String subject : triples.keySet()) {
            TemplateParameter subjectParam = RdfAppExtractCoreStts2.makeTemplateParameter(subject, _entityToIdMap.get(subject), _entityToType.get(subject), true);
            boolean pastSubject = RdfAppExtractCoreStts2.isDeadEntity(triples.get(subject).keySet());
            for (String predicate : triples.get(subject).keySet()) {
                if (RdfAppExtractCoreStts2.badPredicate(predicate)) continue;
                SemanticTypedTemplate stt = (SemanticTypedTemplate)basePredicateStts.get(predicate);
                boolean past = pastSubject || RdfAppExtractCoreStts2.isPastPredicate(predicate);
                for (String object : triples.get(subject).get(predicate)) {
                    if (object.startsWith("List of") || object.contains(subject)) continue;
                    TemplateParameter objectParam = RdfAppExtractCoreStts2.makeTemplateParameter(object, RdfAppExtractCoreStts2.getEntityId(object), _entityToType.get(object), false);
                    SemanticUnit su = ExtractorUtils.makeSu(Utils.list(subjectParam, objectParam), stt, past);
                    arrayList.add(su);
                }
            }
        }
        ExtractorUtils.registerCoreDomainSus(arrayList, domainName);
        ArrayList<SemanticUnit> sus = new ArrayList<SemanticUnit>();
        int c = 0;
        int f = 0;
        String entity = null;
        for (String sentence : Utils.readLinesDynamically(domainCorpusPosFile)) {
            ArrayList<TemplateParameter> params;
            String slottedSentence;
            if (++c % 1000 == 0) {
                System.out.println("went through " + c + " sentences, found " + f + " definitional messages");
            }
            if (sentence.startsWith("####") && sentence.length() > 8) {
                String article = sentence.substring(4, sentence.length() - 4);
                entity = RdfUtils.normalizeEntity(article);
                if (!triples.keySet().contains(entity)) {
                    entity = null;
                }
            }
            if (entity == null || sentence.startsWith("####") || sentence.startsWith("=") || sentence.contains("|") || FindEntitiesUtils.hasNoVerb(sentence) || RdfAppExtractCoreStts2.specialWikiLine(sentence)) continue;
            MultiMap<String, String> subjectTriples = triples.get(entity);
            if (ExtractorUtils.badSentence(sentence) || !FindEntitiesUtils.passes(slottedSentence = FindEntitiesUtils.findEntitiesInPosSentence(sentence, null), 1)) continue;
            List<String> entities = RdfAppExtractCoreStts2.getEntities(slottedSentence);
            slottedSentence = ExtractorUtils.cleanPunctuation(slottedSentence);
            MultiMap<String, String> matchingTriples = RdfAppExtractCoreStts2.findMatchingTriples(entities, subjectTriples, entity);
            if (!matchingTriples.isEmpty()) {
                void var25_46;
                SemanticTypedTemplate semanticTypedTemplate;
                ++f;
                params = new ArrayList<TemplateParameter>();
                HashMap<Pair<Integer>, String> relationships = new HashMap<Pair<Integer>, String>();
                params.add(RdfAppExtractCoreStts2.makeTemplateParameter(entity, _entityToIdMap.get(entity), _entityToType.get(entity), true));
                for (String predicate : matchingTriples.keySet()) {
                    for (String string : matchingTriples.get(predicate)) {
                        String objectId = RdfAppExtractCoreStts2.getEntityId(string);
                        int objectIndex = RdfAppExtractCoreStts2.indexOf(params, string);
                        if (objectIndex == -1) {
                            params.add(RdfAppExtractCoreStts2.makeTemplateParameter(string, objectId, _entityToType.get(string), false));
                            objectIndex = params.size() - 1;
                        }
                        relationships.put(new Pair<Integer>(0, objectIndex), predicate);
                    }
                }
                int unmatchedEntities = entities.size() - params.size();
                for (String e : entities) {
                    String surfaceType;
                    if (RdfAppExtractCoreStts2.indexOf(params, e) != -1) continue;
                    String eid = RdfAppExtractCoreStts2.getEntityId(e);
                    if (_entityToType.get(e).equals("type") && (surfaceType = RdfAppExtractCoreStts2.getSurfaceType(e)) != null) {
                        _entityToType.put(e, surfaceType);
                    }
                    params.add(RdfAppExtractCoreStts2.makeTemplateParameter(e, eid, _entityToType.get(e), false));
                }
                String template = RdfAppExtractCoreStts2.templatize(slottedSentence, params);
                SemanticTypedTemplate semanticTypedTemplate2 = semanticTypedTemplate = unmatchedEntities == 0 ? RdfAppExtractCoreStts2.getExistingStt(params, relationships) : null;
                if (semanticTypedTemplate == null) {
                    String sttId = RdfAppExtractCoreStts2.getNextDomainSttId();
                    SemanticTypedTemplate semanticTypedTemplate3 = RdfAppExtractCoreStts2.makeStt(Utils.list(template), params, relationships, sttId, 1.0 / (double)(1 + unmatchedEntities));
                    stts.add(semanticTypedTemplate3);
                    if (unmatchedEntities == 0) {
                        _allParamStts.add(semanticTypedTemplate3);
                    }
                    SemanticUnit su = ExtractorUtils.makeSu(params, semanticTypedTemplate3);
                    sus.add(su);
                } else if (template.length() < 50 * params.size()) {
                    semanticTypedTemplate.getTemplates().add(template);
                }
                System.out.println(RdfAppExtractCoreStts2.sttToString((SemanticTypedTemplate)var25_46));
                continue;
            }
            if (!RdfAppExtractCoreStts2.matchesMainEntity(entities, entity)) continue;
            params = new ArrayList();
            params.add(RdfAppExtractCoreStts2.makeTemplateParameter(entity, _entityToIdMap.get(entity), _entityToType.get(entity), true));
            int nonParamEntities = entities.size() - params.size();
            for (String e : entities) {
                String surfaceType;
                if (RdfAppExtractCoreStts2.indexOf(params, e) != -1) continue;
                String string = RdfAppExtractCoreStts2.getEntityId(e);
                if (_entityToType.get(e).equals("type") && (surfaceType = RdfAppExtractCoreStts2.getSurfaceType(e)) != null) {
                    _entityToType.put(e, surfaceType);
                }
                params.add(RdfAppExtractCoreStts2.makeTemplateParameter(e, string, _entityToType.get(e), false));
            }
            String template = RdfAppExtractCoreStts2.templatize(slottedSentence, params);
            String sttId = RdfAppExtractCoreStts2.getNextDomainSttId();
            double d = 1.0 / (double)(1 + nonParamEntities) - 1.0 - (double)(template.length() / 10);
            SemanticTypedTemplate stt = RdfAppExtractCoreStts2.makeStt(Utils.list(template), params, new HashMap<Pair<Integer>, String>(), sttId, d);
            stts.add(stt);
            System.out.println(RdfAppExtractCoreStts2.sttToString(stt));
            SemanticUnit su = ExtractorUtils.makeSu(params, stt);
            sus.add(su);
        }
        ExtractorUtils.registerExtraEntities(domainName, _extraEntityToId, _entityToType);
        ExtractorUtils.registerDomainStts(stts, domainName);
        ExtractorUtils.registerDomainSus(sus, domainName);
    }

    private static Map<String, String> getCoreEntityTypes(Set<String> entities, Set<String> originalEntities) {
        DbpediaWordNetTaxonomy taxonomy = new DbpediaWordNetTaxonomy(entities);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entity : entities) {
            if (originalEntities.contains(entity)) {
                map.put(entity, _rad.getDomainEntityType());
                continue;
            }
            map.put(entity, RdfAppExtractCoreStts2.getType(entity, taxonomy));
        }
        return map;
    }

    private static String getType(String entity, Taxonomy taxonomy) {
        Collection<String> senses = taxonomy.getSenses(RdfAppExtractCoreStts2.taxonomyNorm(entity));
        if (senses == null) {
            System.err.println("no senses found for " + entity);
            return "type";
        }
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (String sense : senses) {
            types.addAll(taxonomy.getTypes(sense));
        }
        if (types.isEmpty()) {
            return "type";
        }
        if (types.size() > 1) {
            System.err.println(String.valueOf(types.size()) + " types found for " + entity);
        }
        String type = (String)types.iterator().next();
        return taxonomy.getWords(type).iterator().next();
    }

    private static String taxonomyNorm(String string) {
        return string.replaceAll("\\s+", "_").toLowerCase();
    }

    private static boolean isDeadEntity(Set<String> predicates) {
        for (String predicate : predicates) {
            if (!_rad.getDeathPredicates().contains(predicate)) continue;
            return true;
        }
        return false;
    }

    private static void fixObjectFormatting(MultiMap3<String, String, String> triples) {
        for (String subject : triples.keySet()) {
            for (String predicate : triples.get(subject).keySet()) {
                HashMap<String, String> objectFixes = new HashMap<String, String>();
                for (String object : triples.get(subject).get(predicate)) {
                    String fixed = RdfAppExtractCoreStts2.fixObjectFormatting(object);
                    if (fixed.equals(object)) continue;
                    objectFixes.put(object, fixed);
                }
                for (String object : objectFixes.keySet()) {
                    triples.get(subject).get(predicate).remove(object);
                    triples.get(subject).get(predicate).add((String)objectFixes.get(object));
                }
            }
        }
    }

    private static String fixObjectFormatting(String object) {
        if (object.contains(" ")) {
            String[] tokens = object.split("\\s");
            if (tokens.length == 2 && RdfAppExtractCoreStts2.isNumber(tokens[0])) {
                if (RdfAppExtractCoreStts2.isCurrency(tokens[1])) {
                    return String.valueOf(RdfAppExtractCoreStts2.fixNumber(tokens[0])) + " " + RdfAppExtractCoreStts2.fixCurrency(tokens[1]);
                }
                System.err.println("!!!!!!!!MAYBE NEW CURRENCY!!!!!!!! " + object);
            }
        } else if (!RdfAppExtractCoreStts2.isDate(object) && RdfAppExtractCoreStts2.isNumber(object)) {
            return RdfAppExtractCoreStts2.fixNumber(object);
        }
        return object;
    }

    private static String fixCurrency(String string) {
        return _currencies.get(string);
    }

    private static String fixNumber(String object) {
        return NumberFormat.getNumberInstance().format(Double.parseDouble(object));
    }

    private static void removeRedudencies(MultiMap3<String, String, String> triples, String preferred, String redundent) {
        for (String subject : triples.keySet()) {
            if (!triples.get(subject).containsKey(preferred) || !triples.get(subject).containsKey(redundent)) continue;
            triples.get(subject).remove(redundent);
        }
    }

    private static String getSurfaceType(String object) {
        String[] tokens;
        if (RdfAppExtractCoreStts2.isDate(object)) {
            return "date";
        }
        if (RdfAppExtractCoreStts2.isNumber(object)) {
            return "number";
        }
        if (object.contains(" ") && (tokens = object.split("\\s")).length == 2 && RdfAppExtractCoreStts2.isNumber(tokens[0]) && tokens[1].matches("[A-Z][A-Z][A-Z]")) {
            return "currency";
        }
        return null;
    }

    private static boolean isCurrency(String string) {
        return _currencies.containsKey(string);
    }

    private static boolean isNumber(String object) {
        return object.matches("\\-?(\\d+\\,)*\\d*\\.?\\d+(E\\d+)?");
    }

    private static boolean isDate(String object) {
        if (object.matches("[12]\\d\\d\\d")) {
            return true;
        }
        if (object.matches("\\d\\d\\-\\d\\d\\-\\d\\d\\d\\d")) {
            return true;
        }
        return object.matches("\\d\\d\\d\\d\\-\\d\\d\\-\\d\\d");
    }

    private static boolean badPredicate(String predicate) {
        return _rad.getBadPredicates().contains(predicate);
    }

    private static Set<Pair<String>> getAllPredicatesAndTypes(MultiMap3<String, String, String> triples) {
        HashSet<Pair<String>> set = new HashSet<Pair<String>>();
        for (String subject : triples.keySet()) {
            for (String predicate : triples.get(subject).keySet()) {
                set.add(new Pair<String>(predicate, _entityToType.get(subject)));
            }
        }
        return set;
    }

    private static List<String> makeBasePredicateTemplates(String predicate) {
        if (RdfAppExtractCoreStts2.isActivePredicate(predicate = RdfAppExtractCoreStts2.normalizePredicate(predicate))) {
            return Utils.list("[[0]] is " + predicate + " [[1]]");
        }
        return Utils.list("the " + predicate + " of [[0]] is [[1]]", "[[0]] 's " + predicate + " is [[1]]");
    }

    private static List<String> makeBasePredicateListTemplates(String predicate) {
        if (RdfAppExtractCoreStts2.isActivePredicate(predicate = RdfAppExtractCoreStts2.normalizePredicate(predicate))) {
            return null;
        }
        return Utils.list("the " + RdfAppExtractCoreStts2.pluralize(predicate) + " of [[0]] are [[1]]", "[[0]] 's " + RdfAppExtractCoreStts2.pluralize(predicate) + " are [[1]]");
    }

    private static boolean isPastPredicate(String predicate) {
        return _rad.getPastPredicates().contains(predicate);
    }

    private static String pluralize(String predicate) {
        if (predicate.endsWith("ss")) {
            return String.valueOf(predicate) + "es";
        }
        if (predicate.endsWith("s")) {
            return predicate;
        }
        if (predicate.endsWith("y")) {
            return String.valueOf(predicate.substring(0, predicate.length() - 1)) + "ies";
        }
        if (predicate.endsWith("fe")) {
            return String.valueOf(predicate.substring(0, predicate.length() - 2)) + "ves";
        }
        return String.valueOf(predicate) + "s";
    }

    private static boolean isActivePredicate(String predicate) {
        if (predicate.endsWith(" by")) {
            return true;
        }
        if (predicate.endsWith(" in")) {
            return true;
        }
        if (predicate.endsWith(" on")) {
            return true;
        }
        if (predicate.endsWith(" to")) {
            return true;
        }
        if (predicate.endsWith(" of")) {
            return true;
        }
        return predicate.endsWith(" for");
    }

    private static String normalizePredicate(String predicate) {
        String domainNormalization = _rad.getDomainNormalization(predicate);
        if (domainNormalization != null) {
            return domainNormalization;
        }
        ArrayList<String> words = new ArrayList<String>();
        int index = 0;
        int i = 0;
        while (i < predicate.length()) {
            if (Character.isUpperCase(predicate.charAt(i))) {
                words.add(predicate.substring(index, i).toLowerCase());
                index = i;
            }
            ++i;
        }
        words.add(predicate.substring(index).toLowerCase());
        StringBuffer normalized = new StringBuffer();
        for (String word : words) {
            normalized.append(" ").append(word);
        }
        return normalized.toString().substring(1);
    }

    private static SemanticTypedTemplate getExistingStt(List<TemplateParameter> params, Map<Pair<Integer>, String> relationships) {
        for (SemanticTypedTemplate stt : _allParamStts) {
            if (!stt.matches(params, relationships)) continue;
            System.out.println("MATCH!!");
            return stt;
        }
        return null;
    }

    private static String sttToString(SemanticTypedTemplate stt) {
        String str = String.valueOf(stt.getId()) + "\t";
        int i = 0;
        while (i < stt.getEntityTypes().size()) {
            str = String.valueOf(str) + "[" + i + "] " + stt.getEntityTypes().get(i) + "; ";
            ++i;
        }
        for (Pair<Integer> relationPair : stt.getEntityRelations().keySet()) {
            str = String.valueOf(str) + "[" + relationPair.getFirst() + "]-[" + relationPair.getSecond() + "]: " + stt.getEntityRelations().get(relationPair) + "; ";
        }
        return str;
    }

    private static SemanticTypedTemplate makeStt(List<String> templates, List<TemplateParameter> params, Map<Pair<Integer>, String> relationships, String sttId, double preferenceScore) {
        ArrayList<String> types = new ArrayList<String>();
        for (TemplateParameter param : params) {
            types.add(param.getType());
        }
        return new SemanticTypedTemplateImpl(sttId, types, relationships, templates, null, preferenceScore);
    }

    private static int indexOf(List<TemplateParameter> params, String entity) {
        int i = 0;
        while (i < params.size()) {
            if (entity.equals(params.get(i).getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static TemplateParameter makeTemplateParameter(String entity, String id, String type, boolean coreEntity) {
        return new TemplateParameterSingular(id, type, entity, coreEntity);
    }

    private static boolean specialWikiLine(String sentence) {
        String[] tokens = sentence.split("\\s");
        if (tokens.length < 2) {
            return true;
        }
        return tokens[1].startsWith(":") && tokens[0].startsWith("File");
    }

    private static String getEntityId(String entity) {
        if (_entityToIdMap.containsKey(entity)) {
            return _entityToIdMap.get(entity);
        }
        if (!_extraEntityToId.containsKey(entity)) {
            _extraEntityToId.put(entity, "ee" + ++_extraEntityIdCounter);
        }
        return _extraEntityToId.get(entity);
    }

    private static String getNextDomainSttId() {
        return "ds" + ++_sttIdCounter;
    }

    private static String templatize(String sentence, List<TemplateParameter> params) {
        String template = sentence;
        int index = 0;
        while (template.indexOf("[[", index) != -1) {
            int entityIndex;
            int end;
            String entity = template.substring(index = template.indexOf("[[", index) + 2, end = template.indexOf("]]", index));
            if (entity.contains("|")) {
                entity = entity.split("\\|")[1];
            }
            if ((entityIndex = RdfAppExtractCoreStts2.indexOf(params, entity)) == -1) {
                template = String.valueOf(template.substring(0, index - 2)) + entity + template.substring(end + 2);
                index -= 2;
                continue;
            }
            template = String.valueOf(template.substring(0, index - 2)) + "[[" + entityIndex + "]]" + template.substring(end + 2);
        }
        return template;
    }

    private static boolean matchesMainEntity(List<String> entities, String entity) {
        HashSet<String> entitySet = new HashSet<String>();
        for (String e : entities) {
            entitySet.add(RdfAppExtractCoreStts2.normalize(e));
        }
        String normSubject = RdfAppExtractCoreStts2.normalize(entity);
        return entitySet.contains(normSubject);
    }

    private static MultiMap<String, String> findMatchingTriples(List<String> entities, MultiMap<String, String> subjectTriples, String entity) {
        MultiMap<String, String> map = new MultiMap<String, String>();
        HashSet<String> entitySet = new HashSet<String>();
        for (String e : entities) {
            entitySet.add(RdfAppExtractCoreStts2.normalize(e));
        }
        String normSubject = RdfAppExtractCoreStts2.normalize(entity);
        if (entitySet.contains(normSubject)) {
            for (String predicate : subjectTriples.keySet()) {
                if (RdfAppExtractCoreStts2.badPredicate(predicate)) continue;
                for (String object : subjectTriples.get(predicate)) {
                    String normObject = RdfAppExtractCoreStts2.normalize(object);
                    if (normObject.equals(normSubject) || !entitySet.contains(normObject)) continue;
                    map.add(predicate, object);
                }
            }
        }
        return map;
    }

    private static List<String> getEntities(String sentence) {
        ArrayList<String> entities = new ArrayList<String>();
        int index = 0;
        while (sentence.indexOf("[[", index) != -1) {
            index = sentence.indexOf("[[", index) + 2;
            int end = sentence.indexOf("]]", index);
            String type = null;
            String entity = sentence.substring(index, end);
            if (entity.contains("|")) {
                String[] tokens = entity.split("\\|");
                type = tokens[0];
                entity = tokens[1];
            }
            entities.add(entity);
            if (type == null) continue;
            if (_entityToType.containsKey(entity)) {
                if (type.equals(_entityToType.get(entity))) continue;
                _entityToType.put(entity, "type");
                continue;
            }
            _entityToType.put(entity, type);
        }
        return entities;
    }

    private static String normalize(String string) {
        if (string.indexOf("(") > 0) {
            string = string.substring(0, string.indexOf("(")).trim();
        }
        return string.toLowerCase().replaceAll("[^a-z0-9\\s\\-\\_]", "").replaceAll("\\s+", " ").trim();
    }
}

