/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.gems.rdfApps.RdfUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Set;
import ob.util.Utils;

public class PrepareDomainRdf {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("USAGE: PrepareDomainRdf <domainName> <dbpediaFile>");
            System.exit(0);
        }
        String domainName = args[0];
        String domainEntitiesFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "domain_entities").getAbsolutePath();
        String outfile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "rdf_triples").getAbsolutePath();
        String dbPediaFile = args[1];
        Set<String> domainEntities = RdfUtils.readDomainEntities(domainEntitiesFile);
        PrintWriter pw = new PrintWriter(new FileWriter(outfile));
        for (String line : Utils.readLinesDynamically(dbPediaFile)) {
            if (line.startsWith("#")) continue;
            if (line.endsWith(".")) {
                line = line.substring(0, line.length() - 1).trim();
            }
            if (line.endsWith("@en")) {
                line = line.substring(0, line.length() - 3);
            }
            if (line.contains("@")) continue;
            String[] tokens = line.split("\\s+");
            String subject = PrepareDomainRdf.strip(tokens[0], null);
            String predicate = PrepareDomainRdf.strip(tokens[1], null);
            String objectToken = tokens[2];
            if (tokens.length > 3) {
                int i = 3;
                while (i < tokens.length) {
                    objectToken = String.valueOf(objectToken) + " " + tokens[i];
                    ++i;
                }
            }
            String object = PrepareDomainRdf.strip(objectToken, predicate);
            if (!domainEntities.contains(RdfUtils.normalizeEntity(subject))) continue;
            pw.println(String.valueOf(subject) + "\t" + predicate + "\t" + object);
        }
        pw.close();
    }

    private static String strip(String uri, String predicate) {
        if ("homepage".equals(predicate) || "website".equals(predicate)) {
            return uri.substring(1, uri.length() - 1);
        }
        if (uri.startsWith("\"") && uri.endsWith("\"")) {
            return uri.substring(1, uri.length() - 1);
        }
        if (uri.startsWith("\"") && uri.contains("^^")) {
            String[] tokens = uri.split("\\^\\^");
            String value = tokens[0].substring(1, tokens[0].length() - 1);
            String type = tokens[1].substring(tokens[1].lastIndexOf("/") + 1, tokens[1].indexOf(">"));
            if (type.startsWith("XMLSchema#")) {
                return value;
            }
            return String.valueOf(value) + " " + type;
        }
        if (uri.endsWith("/>")) {
            return uri.substring(1, uri.length() - 1);
        }
        if (uri.startsWith("<") && uri.endsWith(">")) {
            return uri.substring(uri.lastIndexOf("/") + 1, uri.indexOf(">"));
        }
        throw new RuntimeException(uri);
    }
}

