/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.gems.rdfApps.RdfUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import ob.util.Counts;
import ob.util.collections.MultiMap3;

public class ExpandCoreEntities {
    public static void main(String[] args) throws Exception {
        String domainName = "video_game_industry-expanded";
        String rdfFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "rdf_triples").getAbsolutePath();
        String outfile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "expanded_domain_entities").getAbsolutePath();
        MultiMap3<String, String, String> triples = RdfUtils.readRdfTriplesNoNormalization(rdfFile);
        PrintWriter pw = new PrintWriter(new FileWriter(outfile));
        Counts<String> predicateCounts = new Counts<String>();
        HashSet<String> usedEntities = new HashSet<String>();
        for (String subject : triples.keySet()) {
            usedEntities.add(subject);
            for (String predicate : triples.get(subject).keySet()) {
                predicateCounts.add(predicate);
            }
        }
        double threshold = 0.25 * (double)triples.size();
        for (String subject : triples.keySet()) {
            for (String predicate : triples.get(subject).keySet()) {
                if (!((double)predicateCounts.getCount(predicate).intValue() > threshold)) continue;
                for (String object : triples.get(subject).get(predicate)) {
                    if (!ExpandCoreEntities.goodObject(object) || usedEntities.contains(object)) continue;
                    pw.println(object);
                    usedEntities.add(object);
                }
            }
        }
        pw.close();
    }

    private static boolean goodObject(String object) {
        if (object.length() < 3) {
            return false;
        }
        if (object.matches("[^A-Za-z]+")) {
            return false;
        }
        return Character.isAlphabetic(object.charAt(0));
    }
}

