/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ob.util.Counts;
import ob.util.Pair;
import ob.util.Utils;
import ob.util.collections.Map3;

public class EvaluateCrowdFlowerResults2 {
    public static void main(String[] args) {
        String[] files = new String[]{"working/results/eval2/f930878-full.csv", "working/results/eval2/f931002.csv"};
        String evalDomain = null;
        Map3<String, String, InstanceResults> map = EvaluateCrowdFlowerResults2.readMap(files, evalDomain);
        for (String system : map.keySet()) {
            System.out.println("****************************");
            System.out.println("evaluation for " + system);
            System.out.println("****************************");
            EvaluateCrowdFlowerResults2.printEvaluation(map.get(system).values(), system);
        }
    }

    private static void printEvaluation(Collection<InstanceResults> results, String system) {
        HashMap<String, Counts<String>> map = new HashMap<String, Counts<String>>();
        HashMap<String, List<Pair<Double>>> vectors = new HashMap<String, List<Pair<Double>>>();
        double accepted = 0.0;
        for (InstanceResults ir : results) {
            double overall;
            if (!EvaluateCrowdFlowerResults2.acceptable(ir) || Double.isNaN(overall = ir.getOverall())) continue;
            EvaluateCrowdFlowerResults2.updateMap(map, vectors, "overall", overall);
            EvaluateCrowdFlowerResults2.updateMap(map, vectors, "content", ir.getContent());
            EvaluateCrowdFlowerResults2.updateMap(map, vectors, "ordering", ir.getOrdering());
            EvaluateCrowdFlowerResults2.updateMap(map, vectors, "style", ir.getStyle());
            accepted += 1.0;
        }
        System.out.println("accepted: " + accepted + " out of " + results.size() + " (" + NumberFormat.getPercentInstance().format(accepted / (double)results.size()) + ")");
        for (String key : map.keySet()) {
            System.out.println(String.valueOf(key) + ": ");
            for (String type : (Counts)map.get(key)) {
                System.out.println("  " + type + ": " + (double)((Counts)map.get(key)).getCount(type).intValue() / accepted);
            }
        }
        for (String key : vectors.keySet()) {
            try {
                PrintWriter pw = new PrintWriter("working/statsig/eval2-" + system + "-" + key);
                for (Pair pair : (List)vectors.get(key)) {
                    pw.println(pair.getFirst() + "," + pair.getSecond());
                }
                pw.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void updateMap(Map<String, Counts<String>> map, Map<String, List<Pair<Double>>> vectors, String key, double score) {
        Counts<String> counts = map.get(key);
        if (counts == null) {
            counts = new Counts();
            map.put(key, counts);
        }
        String type = score == 0.0 ? "equal" : (score >= 1.0 ? "win" : "lose");
        counts.add(type);
        List<Pair<Double>> vector = vectors.get(key);
        if (vector == null) {
            vector = new ArrayList<Pair<Double>>();
            vectors.put(key, vector);
        }
        vector.add(new Pair<Double>(type.equals("win") ? 1.0 : 0.0, type.equals("lose") ? 1.0 : 0.0));
    }

    private static boolean acceptable(InstanceResults ir) {
        HashSet<Double> values = new HashSet<Double>();
        for (InstanceResult result : ir._results) {
            values.add(result._overall);
        }
        return values.size() < 3;
    }

    private static Map3<String, String, InstanceResults> readMap(String[] files, String evalDomain) {
        Map3<String, String, InstanceResults> map = new Map3<String, String, InstanceResults>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            List<String> lines = Utils.readLines(file);
            Map<String, Integer> header = EvaluateCrowdFlowerResults2.readHeader(lines.get(0));
            int i = 1;
            while (i < lines.size()) {
                String line = lines.get(i);
                List<String> tokens = EvaluateCrowdFlowerResults2.getTokens(line, header.size());
                String id = tokens.get(header.get("_unit_id"));
                String workerId = tokens.get(header.get("_worker_id"));
                double trust = Double.parseDouble(tokens.get(header.get("_trust")));
                String application = tokens.get(header.get("application"));
                String domain = tokens.get(header.get("domain"));
                if (evalDomain == null || evalDomain.equals(domain)) {
                    String system = tokens.get(header.get("system"));
                    String contentStr = tokens.get(header.get("content"));
                    String orderingStr = tokens.get(header.get("ordering"));
                    String styleStr = tokens.get(header.get("style"));
                    String overallStr = tokens.get(header.get("overall"));
                    Boolean fullfirst = Boolean.parseBoolean(tokens.get(header.get("fullfirst")));
                    double content = EvaluateCrowdFlowerResults2.determineScore(contentStr, fullfirst);
                    double ordering = EvaluateCrowdFlowerResults2.determineScore(orderingStr, fullfirst);
                    double style = EvaluateCrowdFlowerResults2.determineScore(styleStr, fullfirst);
                    double overall = EvaluateCrowdFlowerResults2.determineScore(overallStr, fullfirst);
                    InstanceResults ir = map.get(system, id);
                    if (ir == null) {
                        ir = new InstanceResults(application, domain);
                        map.add(system, id, ir);
                    }
                    ir.addResult(workerId, trust, content, ordering, style, overall);
                }
                ++i;
            }
            ++n2;
        }
        return map;
    }

    private static double determineScore(String contentStr, Boolean fullfirst) {
        if (contentStr.equals("eq")) {
            return 0.0;
        }
        if (contentStr.equals("v2") ^ fullfirst) {
            return 1.0;
        }
        return -1.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getTokens(String line, int size) {
        String[] tokens = line.split(",");
        ArrayList<String> list = new ArrayList<String>();
        String toAdd = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.contains("\"")) {
                if (token.startsWith("\"") && token.endsWith("\"")) {
                    list.add(token);
                } else if (token.startsWith("\"")) {
                    toAdd = token;
                } else {
                    if (!token.endsWith("\"")) throw new RuntimeException("WTF?!?");
                    toAdd = String.valueOf(toAdd) + "," + token;
                    list.add(toAdd);
                    toAdd = "";
                }
            } else if (toAdd.isEmpty()) {
                list.add(token);
            } else {
                toAdd = String.valueOf(toAdd) + "," + token;
            }
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            list.add(tokens[i]);
            ++i;
        }
        String text = "";
        int i2 = size - 1;
        while (i2 < tokens.length) {
            text = String.valueOf(text) + "," + tokens[i2];
            ++i2;
        }
        text = text.substring(1);
        list.add(text);
        return list;
    }

    private static Map<String, Integer> readHeader(String string) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] headers = string.split(",");
        int i = 0;
        while (i < headers.length) {
            map.put(headers[i], i);
            ++i;
        }
        return map;
    }

    private static class InstanceResult {
        private String _workerId;
        private double _trust;
        private double _content;
        private double _ordering;
        private double _style;
        private double _overall;

        public InstanceResult(String workerId, double trust, double content, double ordering, double style, double overall) {
            this._workerId = workerId;
            this._trust = trust;
            this._content = content;
            this._ordering = ordering;
            this._style = style;
            this._overall = overall;
        }

        public boolean isGood() {
            return true;
        }
    }

    private static class InstanceResults {
        private String _application;
        private String _domain;
        private List<InstanceResult> _results = new ArrayList<InstanceResult>();

        public InstanceResults(String application, String domain) {
            this._application = application;
            this._domain = domain;
        }

        private double getScore(List<InstanceResult> results, Scorer scorer) {
            double score = 0.0;
            double total = 0.0;
            for (InstanceResult result : results) {
                if (!result.isGood()) continue;
                score += scorer.getScore(result);
                total += 1.0;
            }
            return score;
        }

        public double getOverall() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._overall;
                }
            });
        }

        public double getStyle() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._style;
                }
            });
        }

        public double getContent() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._content;
                }
            });
        }

        public double getOrdering() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._ordering;
                }
            });
        }

        public void addResult(String workerId, double trust, double content, double ordering, double style, double overall) {
            this._results.add(new InstanceResult(workerId, trust, content, ordering, style, overall));
        }

        private static interface Scorer {
            public double getScore(InstanceResult var1);
        }
    }
}

