/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ob.util.Pair;
import ob.util.Utils;
import ob.util.collections.Map3;

public class EvaluateCrowdFlowerResults1 {
    public static void main(String[] args) throws Exception {
        String[] files = new String[]{"working/results/eval1/f930574-full.csv", "working/results/eval1/f930748-full.csv"};
        String evalDomain = null;
        Map3<String, String, InstanceResults> map = EvaluateCrowdFlowerResults1.readMap(files, evalDomain);
        Map3<String, String, Map<String, Double>> vectors = new Map3<String, String, Map<String, Double>>();
        for (String system : map.keySet()) {
            System.out.println("****************************");
            System.out.println("evaluation for " + system);
            System.out.println("****************************");
            Map<String, Map<String, Double>> systemVectors = vectors.get(system);
            if (systemVectors == null) {
                systemVectors = new HashMap();
                vectors.put(system, systemVectors);
            }
            EvaluateCrowdFlowerResults1.printEvaluation(map.get(system), systemVectors);
        }
        for (String system : vectors.keySet()) {
            if (system.equals("full")) continue;
            for (String type : vectors.get(system).keySet()) {
                Map baselineVec = (Map)vectors.get(system, type);
                Map fullVec = (Map)vectors.get("full", type);
                ArrayList<Pair<Double>> out = new ArrayList<Pair<Double>>();
                for (String id : fullVec.keySet()) {
                    if (!baselineVec.containsKey(id)) continue;
                    out.add(new Pair<Double>((Double)fullVec.get(id), (Double)baselineVec.get(id)));
                }
                PrintWriter pw = new PrintWriter("working/statsig/eval1-" + system + "-" + type);
                for (Pair pair : out) {
                    pw.println(pair.getFirst() + "," + pair.getSecond());
                }
                pw.close();
            }
        }
    }

    private static void printEvaluation(Map<String, InstanceResults> results, Map<String, Map<String, Double>> map) {
        double contentAvg = 0.0;
        double orderingAvg = 0.0;
        double styleAvg = 0.0;
        double overallAvg = 0.0;
        double acceptedContent = 0.0;
        double acceptedOrdering = 0.0;
        double acceptedStyle = 0.0;
        double acceptedOverall = 0.0;
        for (String id : results.keySet()) {
            Map<String, Double> zmap;
            InstanceResults ir = results.get(id);
            if (!EvaluateCrowdFlowerResults1.acceptable(ir)) continue;
            if (!Double.isNaN(ir.getOverall())) {
                overallAvg += ir.getOverall();
                acceptedOverall += 1.0;
                zmap = map.get("overall");
                if (zmap == null) {
                    zmap = new HashMap<String, Double>();
                    map.put("overall", zmap);
                }
                zmap.put(id, ir.getOverall());
            }
            if (!Double.isNaN(ir.getContent())) {
                contentAvg += ir.getContent();
                acceptedContent += 1.0;
                zmap = map.get("content");
                if (zmap == null) {
                    zmap = new HashMap<String, Double>();
                    map.put("content", zmap);
                }
                zmap.put(id, ir.getOverall());
            }
            if (!Double.isNaN(ir.getOrdering())) {
                orderingAvg += ir.getOrdering();
                acceptedOrdering += 1.0;
                zmap = map.get("ordering");
                if (zmap == null) {
                    zmap = new HashMap<String, Double>();
                    map.put("ordering", zmap);
                }
                zmap.put(id, ir.getOverall());
            }
            if (Double.isNaN(ir.getStyle())) continue;
            styleAvg += ir.getStyle();
            acceptedStyle += 1.0;
            zmap = map.get("style");
            if (zmap == null) {
                zmap = new HashMap<String, Double>();
                map.put("style", zmap);
            }
            zmap.put(id, ir.getOverall());
        }
        System.out.println("Content: " + (contentAvg /= acceptedContent));
        System.out.println("Ordering: " + (orderingAvg /= acceptedOrdering));
        System.out.println("Style: " + (styleAvg /= acceptedStyle));
        System.out.println("Overall: " + (overallAvg /= acceptedOverall));
    }

    private static boolean acceptable(InstanceResults ir) {
        return true;
    }

    private static Map3<String, String, InstanceResults> readMap(String[] files, String evalDomain) {
        Map3<String, String, InstanceResults> map = new Map3<String, String, InstanceResults>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            List<String> lines = Utils.readLines(file);
            Map<String, Integer> header = EvaluateCrowdFlowerResults1.readHeader(lines.get(0));
            int i = 1;
            while (i < lines.size()) {
                String line = lines.get(i);
                List<String> tokens = EvaluateCrowdFlowerResults1.getTokens(line, header.size());
                String id = tokens.get(header.get("instance"));
                String workerId = tokens.get(header.get("_worker_id"));
                double trust = Double.parseDouble(tokens.get(header.get("_trust")));
                String application = tokens.get(header.get("application"));
                String domain = tokens.get(header.get("domain"));
                if (evalDomain == null || evalDomain.equals(domain)) {
                    String system = tokens.get(header.get("system"));
                    double content = Double.parseDouble(tokens.get(header.get("content")));
                    double ordering = Double.parseDouble(tokens.get(header.get("ordering")));
                    double style = Double.parseDouble(tokens.get(header.get("style")));
                    double overall = Double.parseDouble(tokens.get(header.get("overall")));
                    InstanceResults ir = map.get(system, id);
                    if (ir == null) {
                        ir = new InstanceResults(application, domain);
                        map.add(system, id, ir);
                    }
                    ir.addResult(workerId, trust, content, ordering, style, overall);
                }
                ++i;
            }
            ++n2;
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getTokens(String line, int size) {
        String[] tokens = line.split(",");
        ArrayList<String> list = new ArrayList<String>();
        String toAdd = "";
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.contains("\"")) {
                if (token.startsWith("\"") && token.endsWith("\"")) {
                    list.add(token);
                } else if (token.startsWith("\"")) {
                    toAdd = token;
                } else {
                    if (!token.endsWith("\"")) throw new RuntimeException("WTF?!?");
                    toAdd = String.valueOf(toAdd) + "," + token;
                    list.add(toAdd);
                    toAdd = "";
                }
            } else if (toAdd.isEmpty()) {
                list.add(token);
            } else {
                toAdd = String.valueOf(toAdd) + "," + token;
            }
            ++i;
        }
        i = 0;
        while (i < size - 1) {
            list.add(tokens[i]);
            ++i;
        }
        String text = "";
        int i2 = size - 1;
        while (i2 < tokens.length) {
            text = String.valueOf(text) + "," + tokens[i2];
            ++i2;
        }
        text = text.substring(1);
        list.add(text);
        return list;
    }

    private static Map<String, Integer> readHeader(String string) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] headers = string.split(",");
        int i = 0;
        while (i < headers.length) {
            map.put(headers[i], i);
            ++i;
        }
        return map;
    }

    private static class InstanceResult {
        private String _workerId;
        private double _trust;
        private double _content;
        private double _ordering;
        private double _style;
        private double _overall;

        public InstanceResult(String workerId, double trust, double content, double ordering, double style, double overall) {
            this._workerId = workerId;
            this._trust = trust;
            this._content = content;
            this._ordering = ordering;
            this._style = style;
            this._overall = overall;
        }

        public boolean isGood() {
            return this._trust > 0.75;
        }
    }

    private static class InstanceResults {
        private String _application;
        private String _domain;
        private List<InstanceResult> _results = new ArrayList<InstanceResult>();

        public InstanceResults(String application, String domain) {
            this._application = application;
            this._domain = domain;
        }

        private double getScore(List<InstanceResult> results, Scorer scorer) {
            ArrayList<Double> values = new ArrayList<Double>();
            for (InstanceResult result : results) {
                values.add(scorer.getScore(result));
            }
            List<Double> goodValues = this.getGoodValues(values);
            double avg = 0.0;
            for (Double d : goodValues) {
                avg += d.doubleValue();
            }
            return avg /= (double)goodValues.size();
        }

        private List<Double> getGoodValues(List<Double> values) {
            ArrayList<Double> gv = new ArrayList<Double>();
            int i = 0;
            while (i < values.size()) {
                int j = 0;
                while (j < values.size()) {
                    if (i != j && Math.abs(values.get(i) - values.get(j)) <= 1.0) {
                        gv.add(values.get(i));
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return gv;
        }

        public double getOverall() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._overall;
                }
            });
        }

        public double getStyle() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._style;
                }
            });
        }

        public double getContent() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._content;
                }
            });
        }

        public double getOrdering() {
            return this.getScore(this._results, new Scorer(){

                @Override
                public double getScore(InstanceResult result) {
                    return result._ordering;
                }
            });
        }

        public void addResult(String workerId, double trust, double content, double ordering, double style, double overall) {
            this._results.add(new InstanceResult(workerId, trust, content, ordering, style, overall));
        }

        private static interface Scorer {
            public double getScore(InstanceResult var1);
        }
    }
}

