/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ob.util.Counts;
import ob.util.Utils;
import ob.util.collections.MultiMap;

public class ChooseKeyPredicateArticles {
    static Set<String> keyPredicateObjects = Utils.set("Politician", "Model_(profession)", "Novelist", "Film_producer");

    public static void main(String[] args) throws Exception {
        String mappingFile = "C:/Users/Or/Desktop/mappingbased_properties_en.nt";
        String entityFile = "tmp/person";
        String keyPredicate = "occupation";
        Set<String> entities = ChooseKeyPredicateArticles.readEntities(entityFile);
        System.out.println("done reading " + entities.size() + " entities");
        MultiMap<String, String> keyPredicateEntities = new MultiMap<String, String>();
        int c = 0;
        for (String line : Utils.readLinesDynamically(mappingFile)) {
            if (line.startsWith("#")) continue;
            if (++c % 1000000 == 0) {
                System.out.println("at line " + c);
            }
            String[] tokens = line.split("\\s+");
            String subject = ChooseKeyPredicateArticles.strip(tokens[0]);
            String predicate = ChooseKeyPredicateArticles.strip(tokens[1]);
            String object = ChooseKeyPredicateArticles.strip(tokens[2]);
            if (!entities.contains(subject) || !predicate.equals(keyPredicate) || !keyPredicateObjects.contains(object)) continue;
            keyPredicateEntities.add(object, subject);
        }
        System.out.println("got key predicate object members");
        for (String kpe : keyPredicateEntities.keySet()) {
            PrintWriter pw = new PrintWriter(new FileWriter("tmp/" + kpe));
            for (String entity : keyPredicateEntities.get(kpe)) {
                pw.println(entity);
            }
            pw.close();
        }
        HashMap<String, Counts<String>> predicateCounts = new HashMap<String, Counts<String>>();
        c = 0;
        for (String line : Utils.readLinesDynamically(mappingFile)) {
            if (line.startsWith("#")) continue;
            if (++c % 1000000 == 0) {
                System.out.println("at line " + c);
            }
            String[] tokens = line.split("\\s+");
            String subject = ChooseKeyPredicateArticles.strip(tokens[0]);
            String predicate = ChooseKeyPredicateArticles.strip(tokens[1]);
            if (!entities.contains(subject)) continue;
            for (String industry : keyPredicateEntities.keySet()) {
                if (!keyPredicateEntities.get(industry).contains(subject)) continue;
                Counts<String> counts = (Counts<String>)predicateCounts.get(industry);
                if (counts == null) {
                    counts = new Counts<String>();
                    predicateCounts.put(industry, counts);
                }
                counts.add(predicate);
            }
        }
        for (String kpo : predicateCounts.keySet()) {
            System.out.println(kpo);
            final Counts counts = (Counts)predicateCounts.get(kpo);
            ArrayList ordered = new ArrayList((Collection)predicateCounts.get(kpo));
            Collections.sort(ordered, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    return counts.getCount(arg0) - counts.getCount(arg1);
                }
            });
            for (String predicate : ordered) {
                System.out.println("  " + predicate + ": \t" + ((Counts)predicateCounts.get(kpo)).getCount(predicate));
            }
            System.out.println();
        }
    }

    private static Set<String> readEntities(String entityFile) {
        HashSet<String> entities = new HashSet<String>();
        for (String line : Utils.readLinesDynamically(entityFile)) {
            entities.add(line);
        }
        return entities;
    }

    private static String strip(String uri) {
        if (!uri.contains("/") || !uri.contains(">")) {
            return uri;
        }
        return uri.substring(uri.lastIndexOf("/") + 1, uri.indexOf(">"));
    }
}

