/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.gems.rdfApps;

import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.gems.rdfApps.RdfUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import ob.util.collections.MultiMap3;

public class BuildDataForCrowdFlowerEval2 {
    private static final int INSTANCES_PER_DOMAIN = 100;
    private static String _app = "cdesc";

    public static void main(String[] args) throws Exception {
        ArrayList<String> rows = new ArrayList<String>();
        BuildDataForCrowdFlowerEval2.addToRows(rows, _app, "video games", "video_game_industry-expanded", true);
        Collections.shuffle(rows);
        String header = "system,application,domain,fullfirst,instance,text1,text2";
        rows.add(0, header);
        String outfile = "working/cf_eval2_" + _app + ".csv";
        for (String row : rows) {
            System.out.println(row);
        }
        PrintWriter pw = new PrintWriter(outfile, "UTF-8");
        for (String row : rows) {
            pw.println(row);
        }
        pw.close();
    }

    private static void addToRows(List<String> rows, String app, String domain, String domainDir, boolean includeNtl) {
        Collection<String> instances = BuildDataForCrowdFlowerEval2.chooseBestInstances(domainDir);
        for (String instance : instances) {
            String fullText = BuildDataForCrowdFlowerEval2.getFullText(domainDir, instance);
            rows.add(BuildDataForCrowdFlowerEval2.buildRow(app, domain, domainDir, instance, "-ndm", fullText));
            rows.add(BuildDataForCrowdFlowerEval2.buildRow(app, domain, domainDir, instance, "-npr", fullText));
            if (includeNtl) {
                rows.add(BuildDataForCrowdFlowerEval2.buildRow(app, domain, domainDir, instance, "-ntl", fullText));
            }
            rows.add(BuildDataForCrowdFlowerEval2.buildRow(app, domain, domainDir, instance, "-ndm-ntl-npr-nhg", fullText));
        }
    }

    private static String getFullText(String domainDir, String instance) {
        String file = "C:/dev/working/PreGen/" + domainDir + "/" + instance.toLowerCase().replace(" ", "_").replaceAll("[^a-z0-9\\_]", "");
        return BuildDataForCrowdFlowerEval2.prepareTextForCsv(BuildDataForCrowdFlowerEval2.readLines(file));
    }

    private static String buildRow(String app, String domain, String domainDir, String instance, String system, String fullText) {
        String file = "C:/dev/working/PreGen/" + domainDir + system + "/" + instance.toLowerCase().replace(" ", "_").replaceAll("[^a-z0-9\\_]", "");
        String text = BuildDataForCrowdFlowerEval2.prepareTextForCsv(BuildDataForCrowdFlowerEval2.readLines(file));
        boolean fullfirst = new Random().nextBoolean();
        String text1 = fullfirst ? fullText : text;
        String text2 = fullfirst ? text : fullText;
        return String.valueOf(BuildDataForCrowdFlowerEval2.makeSystemName(system)) + "," + app + "," + domain + "," + fullfirst + ",\"" + BuildDataForCrowdFlowerEval2.makeInstanceName(instance) + "\",\"" + text1 + "\",\"" + text2 + "\"";
    }

    private static List<String> readLines(String file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while (reader.ready()) {
                lines.add(reader.readLine());
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lines;
    }

    private static String makeInstanceName(String text) {
        if (text.contains(" (")) {
            text = text.substring(0, text.indexOf(" ("));
        }
        try {
            text = URLDecoder.decode(text, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return text;
    }

    private static String prepareTextForCsv(List<String> lines) {
        String text = "<p>";
        boolean newParagraph = true;
        boolean first = true;
        for (String line : lines) {
            if (line.contains("active years")) continue;
            if (line.trim().isEmpty()) {
                newParagraph = true;
            } else {
                if (newParagraph) {
                    if (!first) {
                        text = String.valueOf(text) + "</p><p>";
                    }
                } else {
                    text = String.valueOf(text) + "<br>";
                }
                text = String.valueOf(text) + BuildDataForCrowdFlowerEval2.fixForCsv(line);
                newParagraph = false;
            }
            first = false;
        }
        text = String.valueOf(text) + "</p>";
        return text;
    }

    private static String fixForCsv(String line) {
        line = line.replaceAll("\"", "''");
        return line;
    }

    private static String makeSystemName(String system) {
        if (system.isEmpty()) {
            throw new RuntimeException("WTF?!?");
        }
        if (system.equals("-ndm-ntl-npr-nhg")) {
            return "baseline";
        }
        return system.substring(1);
    }

    private static Collection<String> chooseBestInstances(String domainName) {
        String rdfTriplesFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "rdf_triples").getAbsolutePath();
        final MultiMap3<String, String, String> triples = RdfUtils.readRdfTriples(rdfTriplesFile);
        ArrayList<String> orderedEntities = new ArrayList<String>(triples.keySet());
        Collections.sort(orderedEntities, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -(triples.get(o1).size() - triples.get(o2).size());
            }
        });
        return orderedEntities.subList(0, 100);
    }
}

