/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.extractor;

import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.SemanticTypedTemplateImpl;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.core.TemplateParameterSingular;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.extractor.ExtractorUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ob.util.Pair;
import ob.util.Utils;

public class ParaphrasalTemplatesDomainMessageExtractor {
    private static Map<String, String> _entityIds = new LinkedHashMap<String, String>();
    private static int _entityIdCounter = 0;
    private static int _sttIdCounter = 0;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("USAGE: ParaphrasalTemplatesDomainMessageExtractor <domainName>");
            System.exit(0);
        }
        String domainName = args[0];
        String domainCorpusFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "corpus").getAbsolutePath();
        String coreDomainEntitiesFile = new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "domain_entities").getAbsolutePath();
        Map<String, String> coreDomainEntities = ParaphrasalTemplatesDomainMessageExtractor.readCoreDomainEntities(coreDomainEntitiesFile);
        ParaphrasalTemplatesDomainMessageExtractor.doDomainInformationExtractionAndSetup(domainName, domainCorpusFile, coreDomainEntities);
    }

    public static void doDomainInformationExtractionAndSetup(String domainName, String domainCorpus, Map<String, String> coreDomainEntities) {
        System.out.println("registering core subject domain entities");
        Map<String, String> coreEntityIdMap = ExtractorUtils.makeDomainEntityToIdMap(coreDomainEntities.keySet());
        ExtractorUtils.registerDomainEntities(domainName, coreEntityIdMap, coreDomainEntities);
        System.out.println("registering subject domain STTs and messages");
        ParaphrasalTemplatesDomainMessageExtractor.registerDomainMessagesAndStts(domainName, domainCorpus, coreDomainEntities, coreEntityIdMap);
        System.out.println("registering taxonomy messages");
        ParaphrasalTemplatesDomainMessageExtractor.registerTaxonomyMessages(domainName, coreEntityIdMap);
        ExtractorUtils.registerExtraEntities(domainName, _entityIds, ExtractorUtils.uniformMap(_entityIds.keySet(), "type"));
    }

    private static void registerTaxonomyMessages(String domainName, Map<String, String> coreEntityIdMap) {
        Map<String, String> inverseCoreEntityNormalizedMap = ParaphrasalTemplatesDomainMessageExtractor.makeInverseCoreEntityNormalizedMap(coreEntityIdMap);
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(new File(PreGenEnv.getSubjectDomainMessageDir(domainName), "taxonomy")));
            for (String line : Utils.readLinesDynamically(new File(PreGenEnv.getSubjectDomainCorpusDir(domainName), "taxonomy").getAbsolutePath())) {
                String[] tokens = line.split("\\t");
                String first = tokens[0];
                String second = tokens[1];
                String relation = tokens[2];
                if (!relation.equals("hypernym") || !inverseCoreEntityNormalizedMap.containsKey(first)) continue;
                String secondEntityId = ParaphrasalTemplatesDomainMessageExtractor.getEntityId(second);
                pw.println("gs1\t" + coreEntityIdMap.get(inverseCoreEntityNormalizedMap.get(first)) + "\t" + secondEntityId);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getEntityId(String entity) {
        if (!_entityIds.containsKey(entity)) {
            _entityIds.put(entity, "ee" + ++_entityIdCounter);
        }
        return _entityIds.get(entity);
    }

    private static void registerDomainMessagesAndStts(String domainName, String domainCorpus, Map<String, String> coreEntityTypeMap, Map<String, String> coreEntityIdMap) {
        Collection<TemplateAndEntities> definitionalSentences = ParaphrasalTemplatesDomainMessageExtractor.getDefinitionalSentences(domainCorpus, coreEntityTypeMap, coreEntityIdMap);
        ArrayList<SemanticTypedTemplate> stts = new ArrayList<SemanticTypedTemplate>();
        ArrayList<SemanticUnit> sus = new ArrayList<SemanticUnit>();
        System.out.println(" done reading corpus");
        for (TemplateAndEntities templateAndEntities : definitionalSentences) {
            String sttId = ParaphrasalTemplatesDomainMessageExtractor.getNextDomainSttId();
            SemanticTypedTemplate stt = ParaphrasalTemplatesDomainMessageExtractor.makeStt(templateAndEntities, sttId);
            stts.add(stt);
            SemanticUnit su = ExtractorUtils.makeSu(templateAndEntities.getEntities(), stt);
            sus.add(su);
        }
        System.out.println(" done making objects");
        ExtractorUtils.registerDomainStts(stts, domainName);
        ExtractorUtils.registerDomainSus(sus, domainName);
        System.out.println(" done registering");
    }

    private static Collection<TemplateAndEntities> getDefinitionalSentences(String domainCorpus, Map<String, String> coreEntityTypeMap, Map<String, String> coreEntityIdMap) {
        ArrayList<TemplateAndEntities> result = new ArrayList<TemplateAndEntities>();
        Map<String, String> coreEntityNormalizedMap = ParaphrasalTemplatesDomainMessageExtractor.makeCoreEntityNormalizedMap(coreEntityIdMap);
        int c = 0;
        int s = 0;
        int f = 0;
        String entity = null;
        for (String paragraph : Utils.readLinesDynamically(domainCorpus)) {
            if (++c % 1000 == 0) {
                System.out.println("went through " + c + " paragraphs, " + s + " relevant sentences, found " + f + " definitional messages");
            }
            if (paragraph.startsWith("####") && paragraph.length() > 8) {
                String article = paragraph.substring(4, paragraph.length() - 4);
                entity = null;
                for (String e : coreEntityNormalizedMap.keySet()) {
                    if (!ExtractorUtils.normalizeEntity(article.toLowerCase()).equals(coreEntityNormalizedMap.get(e))) continue;
                    entity = e;
                }
            }
            if (entity == null || paragraph.startsWith("####") || paragraph.startsWith("=")) continue;
            List<String> sentences = ExtractorUtils.splitToSentences(paragraph);
            s += sentences.size();
            for (String sentence : sentences) {
                List<String> entitiesInSentence;
                if (ExtractorUtils.badSentence(sentence) || !(entitiesInSentence = ParaphrasalTemplatesDomainMessageExtractor.getEntitiesInSentence(sentence, coreEntityNormalizedMap)).contains(entity)) continue;
                ++f;
                sentence = ExtractorUtils.cleanPunctuation(sentence);
                String template = ParaphrasalTemplatesDomainMessageExtractor.templatize(sentence, entitiesInSentence, coreEntityNormalizedMap);
                List<TemplateParameter> parameters = ParaphrasalTemplatesDomainMessageExtractor.makeParameters(entitiesInSentence, coreEntityIdMap, coreEntityTypeMap);
                result.add(new TemplateAndEntities(template, parameters));
            }
        }
        return result;
    }

    private static Map<String, String> makeCoreEntityNormalizedMap(Map<String, String> coreEntityIdMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entity : coreEntityIdMap.keySet()) {
            map.put(entity, ExtractorUtils.normalizeEntity(entity));
        }
        return map;
    }

    private static Map<String, String> makeInverseCoreEntityNormalizedMap(Map<String, String> coreEntityIdMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entity : coreEntityIdMap.keySet()) {
            map.put(ExtractorUtils.normalizeEntity(entity), entity);
        }
        return map;
    }

    private static String templatize(String sentence, List<String> entitiesInSentence, Map<String, String> coreEntityNormalizedMap) {
        int i = 0;
        while (i < entitiesInSentence.size()) {
            String entity = coreEntityNormalizedMap.get(entitiesInSentence.get(i));
            while (sentence.toLowerCase().contains(entity)) {
                int index = sentence.toLowerCase().indexOf(entity);
                sentence = String.valueOf(sentence.substring(0, index)) + "[[" + i + "]]" + sentence.substring(index + entity.length());
            }
            ++i;
        }
        return sentence;
    }

    private static List<String> getEntitiesInSentence(String sentence, Map<String, String> coreEntityNormalizedMap) {
        ArrayList<String> entities = new ArrayList<String>();
        for (String entity : coreEntityNormalizedMap.keySet()) {
            if (entity.equals("prior") || !sentence.toLowerCase().contains(coreEntityNormalizedMap.get(entity))) continue;
            entities.add(entity);
        }
        return entities;
    }

    private static List<TemplateParameter> makeParameters(List<String> entities, Map<String, String> coreEntityIdMap, Map<String, String> coreEntityTypeMap) {
        ArrayList<TemplateParameter> parameters = new ArrayList<TemplateParameter>();
        for (String entity : entities) {
            String id = coreEntityIdMap.get(entity);
            String type = coreEntityTypeMap.get(entity);
            parameters.add(new TemplateParameterSingular(id, type, entity, true));
        }
        return parameters;
    }

    private static SemanticTypedTemplate makeStt(TemplateAndEntities templateAndEntities, String sttId) {
        ArrayList<String> entityTypes = new ArrayList<String>();
        for (TemplateParameter parameter : templateAndEntities.getEntities()) {
            entityTypes.add(parameter.getType());
        }
        HashMap<Pair<Integer>, String> entityRelations = new HashMap<Pair<Integer>, String>();
        List<String> templates = Utils.list(templateAndEntities.getTemplate());
        double preferenceScore = 1.0;
        return new SemanticTypedTemplateImpl(sttId, entityTypes, entityRelations, templates, null, preferenceScore);
    }

    private static String getNextDomainSttId() {
        return "ds" + ++_sttIdCounter;
    }

    private static Map<String, String> readCoreDomainEntities(String coreDomainEntitiesFile) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String line : Utils.readLinesDynamically(coreDomainEntitiesFile)) {
            String[] tokens = line.split("\\t");
            map.put(tokens[0], tokens[1]);
        }
        return map;
    }

    private static class TemplateAndEntities {
        String _template;
        List<TemplateParameter> _entities;

        public TemplateAndEntities(String template, List<TemplateParameter> entities) {
            this._template = template;
            this._entities = entities;
        }

        public String getTemplate() {
            return this._template;
        }

        public List<TemplateParameter> getEntities() {
            return this._entities;
        }
    }
}

