/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.extractor;

import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.SemanticUnitImpl;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.PreGenEnv;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ob.util.Pair;
import ob.util.Utils;

public class ExtractorUtils {
    public static List<String> splitToSentences(String paragraph) {
        return Utils.list(paragraph.split("\\.\\s+"));
    }

    public static String cleanPunctuation(String sentence) {
        while (sentence.endsWith(".")) {
            sentence = sentence.substring(0, sentence.length() - 1);
        }
        return sentence;
    }

    public static boolean badSentence(String sentence) {
        if (sentence.trim().isEmpty()) {
            return true;
        }
        if (sentence.contains("?")) {
            return true;
        }
        if (sentence.endsWith(":")) {
            return true;
        }
        return !sentence.substring(0, 1).matches("[A-Z]");
    }

    public static String normalizeEntity(String entity) {
        return entity.replace("_", " ").replace("-", " ");
    }

    public static void registerDomainEntities(String domainName, Map<String, String> entityToId, Map<String, String> entityToType) {
        ExtractorUtils.registerEntities(PreGenEnv.getSubjectDomainEntitiesRegistryFile(domainName), entityToId, entityToType);
    }

    public static void registerExtraEntities(String domainName, Map<String, String> entityToId, Map<String, String> entityToType) {
        ExtractorUtils.registerEntities(PreGenEnv.getSubjectDomainExtraEntitiesRegistryFile(domainName), entityToId, entityToType);
    }

    private static void registerEntities(String registryFile, Map<String, String> entityToId, Map<String, String> entityToType) {
        new File(registryFile).getParentFile().mkdirs();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(registryFile));
            for (String entity : entityToId.keySet()) {
                pw.println(String.valueOf(entityToId.get(entity)) + "\t" + entityToType.get(entity) + "\t" + entity);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> makeDomainEntityToIdMap(Set<String> entities) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int c = 0;
        for (String entity : entities) {
            map.put(entity, "de" + ++c);
        }
        return map;
    }

    public static Map<String, String> uniformMap(Set<String> keys, String value) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : keys) {
            map.put(key, value);
        }
        return map;
    }

    public static void registerDomainSus(Collection<SemanticUnit> sus, String domainName) {
        String suRegistryDir = PreGenEnv.getSubjectDomainMessageDir(domainName);
        new File(suRegistryDir).mkdirs();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(new File(suRegistryDir, "definitional")));
            for (SemanticUnit su : sus) {
                String entityString = "";
                for (TemplateParameter parameter : su.getParameters()) {
                    entityString = String.valueOf(entityString) + "\t" + parameter.getId();
                }
                if (su.isPast()) {
                    entityString = String.valueOf(entityString) + "\t*PAST*";
                }
                pw.println(String.valueOf(su.getStt().getId()) + entityString);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerCoreDomainSus(List<SemanticUnit> sus, String domainName) {
        String suRegistryDir = PreGenEnv.getSubjectDomainMessageDir(domainName);
        new File(suRegistryDir).mkdirs();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(new File(suRegistryDir, "core")));
            for (SemanticUnit su : sus) {
                String entityString = "";
                for (TemplateParameter parameter : su.getParameters()) {
                    entityString = String.valueOf(entityString) + "\t" + parameter.getId();
                }
                if (su.isPast()) {
                    entityString = String.valueOf(entityString) + "\t*PAST*";
                }
                pw.println(String.valueOf(su.getStt().getId()) + entityString);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerDomainStts(Collection<SemanticTypedTemplate> stts, String domainName) {
        String sttRegistryFile = PreGenEnv.getSubjectDomainSttRegistryFile(domainName);
        new File(sttRegistryFile).getParentFile().mkdirs();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(sttRegistryFile));
            for (SemanticTypedTemplate stt : stts) {
                pw.println(String.valueOf(stt.getId()) + "\t" + stt.getPreferenceScore() + "\t" + ExtractorUtils.getEntityString(stt) + "\t" + ExtractorUtils.getRelationString(stt) + "\t" + ExtractorUtils.getTemplateString(stt) + (stt.getListTemplates() == null ? "" : "\t" + ExtractorUtils.getListTemplateString(stt)));
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getRelationString(SemanticTypedTemplate stt) {
        String str = "";
        for (Map.Entry<Pair<Integer>, String> relation : stt.getEntityRelations().entrySet()) {
            str = String.valueOf(str) + relation.getKey().getFirst() + "," + relation.getKey().getSecond() + "," + relation.getValue() + "||#||";
        }
        return str.isEmpty() ? str : str.substring(0, str.length() - "||#||".length());
    }

    private static String getTemplateString(SemanticTypedTemplate stt) {
        String str = "";
        for (String template : stt.getTemplates()) {
            str = String.valueOf(str) + template + "\t";
        }
        return str.substring(0, str.length() - 1);
    }

    private static String getListTemplateString(SemanticTypedTemplate stt) {
        String str = "";
        for (String template : stt.getListTemplates()) {
            str = String.valueOf(str) + "LIST:::" + template + "\t";
        }
        return str.substring(0, str.length() - 1);
    }

    private static String getEntityString(SemanticTypedTemplate stt) {
        String str = "";
        for (String entityType : stt.getEntityTypes()) {
            str = String.valueOf(str) + entityType + "||#||";
        }
        return str.substring(0, str.length() - "||#||".length());
    }

    public static SemanticUnit makeSu(List<TemplateParameter> params, SemanticTypedTemplate stt, boolean past) {
        SemanticUnitImpl su = new SemanticUnitImpl(stt, params);
        su.setPast(past);
        return su;
    }

    public static SemanticUnit makeSu(List<TemplateParameter> params, SemanticTypedTemplate stt) {
        return ExtractorUtils.makeSu(params, stt, false);
    }

    public static void registerDomainSttDiscourse(Map<Pair<SemanticTypedTemplate>, String> sttDiscourse, String domainName) {
        String suRegistryDir = PreGenEnv.getSubjectDomainRegistryDir(domainName);
        new File(suRegistryDir).mkdirs();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(new File(suRegistryDir, "stt_discourse")));
            for (Pair<SemanticTypedTemplate> pair : sttDiscourse.keySet()) {
                String[] relationAndFlip = sttDiscourse.get(pair).split(",");
                String line = pair.getFirst() + "\t" + pair.getSecond() + "\t" + relationAndFlip[0] + "\t" + relationAndFlip[1];
                pw.println(line);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

