/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.extractor;

import edu.columbia.ob.gen.env.PreGenEnv;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import ob.util.Utils;

public class DomainMessageExtractor {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("USAGE: DomainMessageExtractor <domainName> <domainCorpusFile> <coreDomainEntitiesFile>");
            System.exit(0);
        }
        String domainName = args[0];
        String domainCorpus = args[1];
        String coreDomainEntitiesFile = args[2];
        Map<String, String> coreDomainEntities = DomainMessageExtractor.readCoreDomainEntities(coreDomainEntitiesFile);
        DomainMessageExtractor.doDomainInformationExtractionAndSetup(domainName, domainCorpus, coreDomainEntities);
    }

    public static void doDomainInformationExtractionAndSetup(String domainName, String domainCorpus, Map<String, String> coreDomainEntities) {
        DomainMessageExtractor.registerCoreDomainEntities(domainName, coreDomainEntities);
    }

    private static void registerCoreDomainEntities(String domainName, Map<String, String> coreDomainEntities) {
        String entitiesRegistryFile = PreGenEnv.getSubjectDomainEntitiesRegistryFile(domainName);
        new File(entitiesRegistryFile).getParentFile().mkdirs();
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(entitiesRegistryFile));
            int c = 0;
            for (String entity : coreDomainEntities.keySet()) {
                String id = "de" + ++c;
                pw.println(String.valueOf(id) + "\t" + coreDomainEntities.get(entity) + "\t" + entity);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> readCoreDomainEntities(String coreDomainEntitiesFile) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String line : Utils.readLinesDynamically(coreDomainEntitiesFile)) {
            String[] tokens = line.split("\\t");
            map.put(tokens[0], tokens[1]);
        }
        return map;
    }
}

