/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.env;

import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.paraphraseMining.ParaphraseUtils;
import edu.columbia.ob.gen.paraphraseMining.Vectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StaticVectors {
    private static Vectors _vectors;

    public static void setCorpusTerms(Collection<SemanticUnit> sus, Collection<String> terms) {
        Set<String> corpusTerms = StaticVectors.getCorpusTerms(sus);
        corpusTerms.addAll(terms);
        _vectors = Vectors.readFromFile("C:/Users/Or/Desktop/wp/vectors.culled.real10.tfidf", corpusTerms);
        _vectors.setUseCache(true);
    }

    private static Set<String> getCorpusTerms(Collection<SemanticUnit> sus) {
        HashSet<String> set = new HashSet<String>();
        for (SemanticUnit su : sus) {
            String sentence = StaticVectors.makeSuPseudoSentence(su);
            String[] stringArray = sentence.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                set.add(word);
                ++n2;
            }
        }
        return set;
    }

    private static String makeSuPseudoSentence(SemanticUnit su) {
        StringBuffer ps = new StringBuffer();
        for (String template : su.getStt().getTemplates()) {
            template = ParaphraseUtils.normalizeText(StaticVectors.fillEntities(template, su.getParameters()));
            ps.append(" ").append(template);
        }
        return ps.toString().substring(1);
    }

    private static String fillEntities(String template, List<TemplateParameter> parameters) {
        int i = 0;
        while (i < parameters.size()) {
            template = template.replace("[[" + i + "]]", parameters.get(i).getName());
            ++i;
        }
        return template;
    }

    public static double getSimilarity(SemanticUnit su1, SemanticUnit su2) {
        return 0.3;
    }

    public static void clearCache() {
        _vectors.clearCache();
    }

    public static double getSimilarity(String string1, String string2) {
        Map<String, Double> v1 = _vectors.getCombinedVector(string1);
        Map<String, Double> v2 = _vectors.getCombinedVector(string2);
        if (v1 == null || v2 == null) {
            return 0.0;
        }
        return Vectors.cosineSimilarity(v1, v2);
    }
}

