/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.env;

import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.FileBackedDomainInfoMgr;
import edu.columbia.ob.gen.realizer.DiscourseMarkerTemplateMgr;
import edu.columbia.ob.gen.realizer.LanguageModelTemplateRealizer;
import edu.columbia.ob.gen.realizer.Realizer;
import edu.columbia.ob.gen.realizer.TaxonomyLexicalChoice;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ob.util.Pair;

public class PreGenEnv {
    private static final String PROPERTIES_FILE = "config/pregen.properties";
    private static Properties _props;
    private static Map<Pair<String>, DomainInfoMgr> _domainInfoMgrs;
    private static DiscourseMarkerTemplateMgr _discourseMarkerTemplateMgr;
    private static Map<String, Realizer> _realizers;

    static {
        _domainInfoMgrs = new HashMap<Pair<String>, DomainInfoMgr>();
        _realizers = new HashMap<String, Realizer>();
    }

    public static String getProperty(String id) {
        if (_props == null) {
            _props = new Properties();
            try {
                FileReader reader = new FileReader(new File(PROPERTIES_FILE));
                _props.load(reader);
                ((Reader)reader).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return _props.getProperty(id);
    }

    public static DomainInfoMgr getDomainInfoMgr(String functionalDomain, String subjectDomain) {
        Pair<String> pair = new Pair<String>(functionalDomain, subjectDomain);
        if (!_domainInfoMgrs.containsKey(pair)) {
            _domainInfoMgrs.put(pair, new FileBackedDomainInfoMgr(PreGenEnv.getGlobalRegistryDir(), PreGenEnv.getFunctionalDomainRegistryDir(functionalDomain), PreGenEnv.getSubjectDomainRegistryDir(subjectDomain), PreGenEnv.getSubjectDomainMessageDir(subjectDomain)));
        }
        return _domainInfoMgrs.get(pair);
    }

    private static String getGlobalRegistryDir() {
        return String.valueOf(PreGenEnv.getGlobalDir()) + "/registry";
    }

    private static String getGlobalDir() {
        return PreGenEnv.getProperty("global_dir");
    }

    private static String getSubjectDomainDir() {
        return PreGenEnv.getProperty("subject_domain_dir");
    }

    private static String getFunctionalDomainDir() {
        return PreGenEnv.getProperty("functional_domain_dir");
    }

    public static String getSubjectDomainRegistryDir(String subjectDomain) {
        return String.valueOf(PreGenEnv.getSubjectDomainDir()) + "/" + subjectDomain + "/registry";
    }

    private static String getFunctionalDomainRegistryDir(String functionalDomain) {
        return String.valueOf(PreGenEnv.getFunctionalDomainDir()) + "/" + functionalDomain + "/registry";
    }

    public static String getSubjectDomainMessageDir(String subjectDomain) {
        return String.valueOf(PreGenEnv.getSubjectDomainDir()) + "/" + subjectDomain + "/messages";
    }

    public static String getSubjectDomainCorpusDir(String subjectDomain) {
        return String.valueOf(PreGenEnv.getSubjectDomainDir()) + "/" + subjectDomain + "/corpus";
    }

    public static String getSubjectDomainEntitiesRegistryFile(String subjectDomain) {
        return String.valueOf(PreGenEnv.getSubjectDomainDir()) + "/" + subjectDomain + "/registry/entities";
    }

    public static String getSubjectDomainExtraEntitiesRegistryFile(String subjectDomain) {
        return String.valueOf(PreGenEnv.getSubjectDomainDir()) + "/" + subjectDomain + "/registry/extra_entities";
    }

    public static String getSubjectDomainSttRegistryFile(String subjectDomain) {
        return String.valueOf(PreGenEnv.getSubjectDomainDir()) + "/" + subjectDomain + "/registry/stts";
    }

    public static String getRelationNgramModelFile() {
        return PreGenEnv.getProperty("relation_ngram_model_file");
    }

    public static DiscourseMarkerTemplateMgr getDiscourseMarkerTemplateMgr() {
        if (_discourseMarkerTemplateMgr == null) {
            _discourseMarkerTemplateMgr = new DiscourseMarkerTemplateMgr(PreGenEnv.getDiscourseMarkerTemplateDir());
        }
        return _discourseMarkerTemplateMgr;
    }

    private static String getDiscourseMarkerTemplateDir() {
        return PreGenEnv.getProperty("discourse_marker_template_dir");
    }

    public static Realizer getRealizer(String subjectDomain) {
        if (!_realizers.containsKey(subjectDomain)) {
            _realizers.put(subjectDomain, new LanguageModelTemplateRealizer(subjectDomain, new TaxonomyLexicalChoice(subjectDomain, true), true, true));
        }
        return _realizers.get(subjectDomain);
    }

    public static String getPosTaggerModelFile() {
        return PreGenEnv.getProperty("pos_tagger_model_file");
    }
}

