/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.env;

import edu.columbia.ob.gen.core.DiscourseRelation;
import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.SemanticTypedTemplateImpl;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.SemanticUnitImpl;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.core.TemplateParameterList;
import edu.columbia.ob.gen.core.TemplateParameterSingular;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ob.util.Pair;
import ob.util.Utils;
import ob.util.collections.MultiMap;

public class FileBackedDomainInfoMgr
implements DomainInfoMgr {
    private String _globalRegistryDir = "global";
    private String _functionalDomainRegistryDir;
    private String _subjectDomainRegistryDir;
    private String _subjectDomainMessageDir;
    private Map<String, SemanticTypedTemplate> _sttMap;
    private Map<String, TemplateParameter> _entityMap;
    private Map<String, String> _entityNameToId;
    private Map<TemplateParameter, Collection<SemanticUnit>> _domainMessagesByParameter;
    private Map<TemplateParameter, Collection<SemanticUnit>> _coreDomainMessagesByParameter;
    private MultiMap<Pair<SemanticTypedTemplate>, DiscourseRelation> _sttFixedDiscourseMap;

    public FileBackedDomainInfoMgr(String globalRegistryDir, String functionalDomainRegistryDir, String subjectDomainRegistryDir, String subjectDomainMessageDir) {
        this._globalRegistryDir = globalRegistryDir;
        this._functionalDomainRegistryDir = functionalDomainRegistryDir;
        this._subjectDomainRegistryDir = subjectDomainRegistryDir;
        this._subjectDomainMessageDir = subjectDomainMessageDir;
        this._sttMap = this.loadSttMap(this._globalRegistryDir);
        this._sttMap.putAll(this.loadSttMap(this._functionalDomainRegistryDir));
        this._sttMap.putAll(this.loadSttMap(this._subjectDomainRegistryDir));
        this._sttFixedDiscourseMap = this.loadSttFixedDiscourseMap(this._functionalDomainRegistryDir);
        this._sttFixedDiscourseMap.putAll(this.loadSttFixedDiscourseMap(this._subjectDomainRegistryDir));
        this._entityMap = this.loadEntityMap(String.valueOf(this._functionalDomainRegistryDir) + "/entities", true);
        this._entityMap.putAll(this.loadEntityMap(String.valueOf(this._subjectDomainRegistryDir) + "/entities", true));
        this._entityMap.putAll(this.loadEntityMap(String.valueOf(this._subjectDomainRegistryDir) + "/extra_entities", false));
        this._entityNameToId = this.makeEntityNameToId(this._entityMap);
        this._domainMessagesByParameter = this.loadDomainMessagesByParameter(this._subjectDomainMessageDir);
        this._coreDomainMessagesByParameter = this.loadCoreDomainMessagesByParameter(this._subjectDomainMessageDir);
    }

    private Map<String, String> makeEntityNameToId(Map<String, TemplateParameter> entityMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String id : entityMap.keySet()) {
            map.put(entityMap.get(id).getName(), id);
        }
        return map;
    }

    @Override
    public SemanticTypedTemplate getSemanticTypedTemplate(String sttId) {
        return this._sttMap.get(sttId);
    }

    @Override
    public TemplateParameter getTemplateParameter(String entityId) {
        return this._entityMap.get(entityId);
    }

    @Override
    public TemplateParameter getListTemplateParameter(Collection<String> entityIds) {
        TemplateParameterList listParameter = new TemplateParameterList();
        for (String entityId : entityIds) {
            listParameter.addParameter(this.getTemplateParameter(entityId));
        }
        return listParameter;
    }

    @Override
    public Collection<TemplateParameter> getTemplateParametersOfType(String type) {
        ArrayList<TemplateParameter> collection = new ArrayList<TemplateParameter>();
        for (TemplateParameter parameter : this._entityMap.values()) {
            if (!parameter.getType().equals(type)) continue;
            collection.add(parameter);
        }
        return collection;
    }

    private Map<String, TemplateParameter> loadEntityMap(String entitiesFile, boolean coreEntities) {
        HashMap<String, TemplateParameter> map = new HashMap<String, TemplateParameter>();
        for (String line : Utils.readLinesDynamically(entitiesFile)) {
            String[] tokens = line.split("\\t");
            map.put(tokens[0], this.buildTemplateParameter(tokens, coreEntities));
        }
        return map;
    }

    private TemplateParameter buildTemplateParameter(String[] tokens, boolean coreEntities) {
        return new TemplateParameterSingular(tokens[0], tokens[1], tokens[2], coreEntities);
    }

    private MultiMap<Pair<SemanticTypedTemplate>, DiscourseRelation> loadSttFixedDiscourseMap(String registryDir) {
        MultiMap<Pair<SemanticTypedTemplate>, DiscourseRelation> map = new MultiMap<Pair<SemanticTypedTemplate>, DiscourseRelation>();
        for (String line : Utils.readLinesDynamically(String.valueOf(registryDir) + "/stt_discourse")) {
            String[] tokens = line.split("\\t");
            SemanticTypedTemplate stt1 = this.getSemanticTypedTemplate(tokens[0]);
            SemanticTypedTemplate stt2 = this.getSemanticTypedTemplate(tokens[1]);
            boolean flip = Boolean.parseBoolean(tokens[3]);
            String[] stringArray = tokens[2].split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String relationToken = stringArray[n2];
                DiscourseRelation relation = DiscourseRelation.valueOf(relationToken);
                map.add(new Pair<SemanticTypedTemplate>(stt1, stt2), relation);
                if (flip) {
                    map.add(new Pair<SemanticTypedTemplate>(stt2, stt1), relation);
                }
                ++n2;
            }
        }
        return map;
    }

    private Map<String, SemanticTypedTemplate> loadSttMap(String registryDir) {
        HashMap<String, SemanticTypedTemplate> map = new HashMap<String, SemanticTypedTemplate>();
        for (String line : Utils.readLinesDynamically(String.valueOf(registryDir) + "/stts")) {
            if (line.startsWith("%")) continue;
            String[] tokens = line.split("\\t");
            map.put(tokens[0], this.buildStt(tokens));
        }
        return map;
    }

    private SemanticTypedTemplate buildStt(String[] tokens) {
        String id = tokens[0];
        double preferenceScore = Double.parseDouble(tokens[1]);
        String typesStr = tokens[2];
        List<String> entityTypes = this.buildSttEntityTypes(typesStr);
        String relationsStr = tokens[3];
        Map<Pair<Integer>, String> entityRelations = this.buildSttEntityRelations(relationsStr);
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<String> listTemplates = new ArrayList<String>();
        int i = 4;
        while (i < tokens.length) {
            String template = tokens[i];
            if (template.startsWith("LIST:::")) {
                listTemplates.add(template.substring("LIST:::".length()));
            } else {
                templates.add(template);
            }
            ++i;
        }
        if (listTemplates.isEmpty()) {
            listTemplates = null;
        }
        SemanticTypedTemplateImpl stt = new SemanticTypedTemplateImpl(id, entityTypes, entityRelations, templates, listTemplates, preferenceScore);
        return stt;
    }

    private List<String> buildSttEntityTypes(String typesStr) {
        String[] tokens;
        ArrayList<String> entityTypes = new ArrayList<String>();
        String[] stringArray = tokens = typesStr.split("\\|\\|\\#\\|\\|");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            entityTypes.add(token);
            ++n2;
        }
        return entityTypes;
    }

    private Map<Pair<Integer>, String> buildSttEntityRelations(String relationsStr) {
        HashMap<Pair<Integer>, String> relationTypes = new HashMap<Pair<Integer>, String>();
        if (!relationsStr.isEmpty()) {
            String[] tokens;
            String[] stringArray = tokens = relationsStr.split("\\|\\|\\#\\|\\|");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                String[] idsAndRelation = token.split(",");
                relationTypes.put(new Pair<Integer>(Integer.parseInt(idsAndRelation[0]), Integer.parseInt(idsAndRelation[1])), idsAndRelation[2]);
                ++n2;
            }
        }
        return relationTypes;
    }

    private Map<TemplateParameter, Collection<SemanticUnit>> loadDomainMessagesByParameter(String subjectDomainMessageDir) {
        HashMap<TemplateParameter, Collection<SemanticUnit>> map = new HashMap<TemplateParameter, Collection<SemanticUnit>>();
        File[] fileArray = new File(subjectDomainMessageDir).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().equals("core")) {
                for (String line : Utils.readLinesDynamically(file.getAbsolutePath())) {
                    SemanticUnit su = this.deserializeSu(line);
                    for (TemplateParameter parameter : su.getParameters()) {
                        ArrayList<SemanticUnit> parameterSus = (ArrayList<SemanticUnit>)map.get(parameter);
                        if (parameterSus == null) {
                            parameterSus = new ArrayList<SemanticUnit>();
                            map.put(parameter, parameterSus);
                        }
                        parameterSus.add(su);
                    }
                }
            }
            ++n2;
        }
        return map;
    }

    private Map<TemplateParameter, Collection<SemanticUnit>> loadCoreDomainMessagesByParameter(String subjectDomainMessageDir) {
        HashMap<TemplateParameter, Collection<SemanticUnit>> map = new HashMap<TemplateParameter, Collection<SemanticUnit>>();
        File file = new File(subjectDomainMessageDir, "core");
        for (String line : Utils.readLinesDynamically(file.getAbsolutePath())) {
            SemanticUnit su = this.deserializeSu(line);
            for (TemplateParameter parameter : su.getParameters()) {
                ArrayList<SemanticUnit> parameterSus = (ArrayList<SemanticUnit>)map.get(parameter);
                if (parameterSus == null) {
                    parameterSus = new ArrayList<SemanticUnit>();
                    map.put(parameter, parameterSus);
                }
                parameterSus.add(su);
            }
        }
        return map;
    }

    private SemanticUnit deserializeSu(String line) {
        String[] tokens = line.split("\\t");
        String sttId = tokens[0];
        SemanticTypedTemplate stt = this.getSemanticTypedTemplate(sttId);
        ArrayList<TemplateParameter> parameters = new ArrayList<TemplateParameter>();
        boolean past = false;
        int i = 1;
        while (i < tokens.length) {
            if (tokens[i].equals("*PAST*")) {
                past = true;
            } else {
                String entityId = tokens[i];
                TemplateParameter parameter = this.getTemplateParameter(entityId);
                parameters.add(parameter);
            }
            ++i;
        }
        SemanticUnitImpl su = new SemanticUnitImpl(stt, parameters);
        su.setPast(past);
        return su;
    }

    @Override
    public Collection<SemanticUnit> getPotentialDomainMessagesForParameter(TemplateParameter parameter) {
        return this._domainMessagesByParameter.get(parameter);
    }

    @Override
    public Collection<SemanticUnit> getCoreDomainMessagesForParameter(TemplateParameter parameter) {
        return this._coreDomainMessagesByParameter.get(parameter);
    }

    @Override
    public Collection<DiscourseRelation> getFixedSttRelations(SemanticTypedTemplate stt1, SemanticTypedTemplate stt2) {
        Pair<SemanticTypedTemplate> pair = new Pair<SemanticTypedTemplate>(stt1, stt2);
        return this._sttFixedDiscourseMap.get(pair);
    }

    @Override
    public String getEntityId(String entity) {
        return this._entityNameToId.get(entity);
    }
}

