/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.domainMessageBuilder;

import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.domainMessageBuilder.DomainMessageBuilder;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenRuntime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ob.util.Pair;
import org.jgrapht.alg.EdmondsKarpMaximumFlow;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class PotentialSelectionDomainMessageBuilder
implements DomainMessageBuilder {
    private DomainInfoMgr _domainInfoMgr;

    public PotentialSelectionDomainMessageBuilder(DomainInfoMgr domainInfoMgr) {
        this._domainInfoMgr = domainInfoMgr;
    }

    @Override
    public Collection<SemanticUnit> getDomainMessages(Collection<SemanticUnit> coreMessages) {
        Collection<SemanticUnit> potentialDomainMessages = this.getPotentialDomainMessages(coreMessages);
        Collection<SemanticUnit> selectedDomainMessages = this.selectDomainMessages(potentialDomainMessages, coreMessages);
        return selectedDomainMessages;
    }

    private Collection<SemanticUnit> getPotentialDomainMessages(Collection<SemanticUnit> coreMessages) {
        HashSet<SemanticUnit> potentialDomainMessages = new HashSet<SemanticUnit>();
        for (SemanticUnit su : coreMessages) {
            for (TemplateParameter parameter : su.getParameters()) {
                Collection<SemanticUnit> parameterDomainMessages;
                if (!parameter.isCoreEntity() || (parameterDomainMessages = this._domainInfoMgr.getPotentialDomainMessagesForParameter(parameter)) == null) continue;
                potentialDomainMessages.addAll(parameterDomainMessages);
            }
        }
        return potentialDomainMessages;
    }

    private Collection<SemanticUnit> selectDomainMessages(Collection<SemanticUnit> potentialDomainMessages, Collection<SemanticUnit> coreMessages) {
        if (potentialDomainMessages.size() == 0) {
            return new HashSet<SemanticUnit>();
        }
        Vertex source = new Vertex(null);
        Vertex sink = new Vertex(null);
        Map<SemanticUnit, Double> individualPreferences = this.getIndividualPreferences(potentialDomainMessages, coreMessages);
        Map<Pair<SemanticUnit>, Double> pairwisePreferences = this.getPairwisePreferences(potentialDomainMessages);
        DefaultDirectedWeightedGraph<Vertex, Edge> graph = this.makeGraph(potentialDomainMessages, source, sink, individualPreferences, pairwisePreferences);
        EdmondsKarpMaximumFlow maxFlow = new EdmondsKarpMaximumFlow(graph);
        maxFlow.calculateMaximumFlow((Object)source, (Object)sink);
        Map maxFlowEdges = maxFlow.getMaximumFlow();
        Collection<Vertex> minCut = this.getMinCut(source, sink, graph, maxFlowEdges);
        HashSet<SemanticUnit> selectedSus = new HashSet<SemanticUnit>();
        for (Vertex vertex : minCut) {
            selectedSus.add(vertex.getSu());
        }
        System.out.println("selected " + selectedSus.size() + " domain messages out of " + potentialDomainMessages.size());
        return selectedSus;
    }

    private Map<Pair<SemanticUnit>, Double> getPairwisePreferences(Collection<SemanticUnit> potentialDomainMessages) {
        HashMap<Pair<SemanticUnit>, Double> map = new HashMap<Pair<SemanticUnit>, Double>();
        SemanticUnit[] sus = potentialDomainMessages.toArray(new SemanticUnit[potentialDomainMessages.size()]);
        int i = 0;
        while (i < sus.length - 1) {
            int j = i + 1;
            while (j < sus.length) {
                double parameterSimilarity;
                double preference = parameterSimilarity = this.getParameterTypeSimilarityScore(sus[i], sus[j]);
                map.put(new Pair<SemanticUnit>(sus[i], sus[j]), preference *= 1.0 - 1.0 / (1.0 + Math.abs(sus[i].getPreferenceScore() - sus[j].getPreferenceScore())));
                map.put(new Pair<SemanticUnit>(sus[j], sus[i]), preference);
                ++j;
            }
            ++i;
        }
        return map;
    }

    private double getParameterTypeSimilarityScore(SemanticUnit su1, SemanticUnit su2) {
        double sim = 0.0;
        for (TemplateParameter p1 : su1.getParameters()) {
            if (p1.getType().equals("type") || p1.getType().equals(PreGenRuntime.getCoreType())) continue;
            for (TemplateParameter p2 : su2.getParameters()) {
                if (p2.getType().equals("type") || p2.getType().equals(PreGenRuntime.getCoreType()) || !p1.getType().equals(p2.getType())) continue;
                sim += 1.0;
            }
        }
        return sim;
    }

    private double getParameterSimilarityScore(SemanticUnit su1, SemanticUnit su2) {
        int common = 0;
        int separate = 0;
        for (TemplateParameter param : su1.getParameters()) {
            if (su2.getParameters().contains(param)) {
                ++common;
                continue;
            }
            ++separate;
        }
        for (TemplateParameter param : su2.getParameters()) {
            if (su1.getParameters().contains(param)) continue;
            ++separate;
        }
        return (double)common / (double)(common + separate);
    }

    private Map<SemanticUnit, Double> getIndividualPreferences(Collection<SemanticUnit> potentialDomainMessages, Collection<SemanticUnit> coreMessages) {
        HashMap<SemanticUnit, Double> map = new HashMap<SemanticUnit, Double>();
        for (SemanticUnit su : potentialDomainMessages) {
            double preference = su.getPreferenceScore() * 0.46;
            double totalPs = 0.0;
            for (SemanticUnit coreSu : coreMessages) {
                double parameterSimilarity = this.getParameterSimilarityScore(su, coreSu);
                totalPs += parameterSimilarity;
            }
            map.put(su, preference += (totalPs /= (double)coreMessages.size()));
        }
        return map;
    }

    private DefaultDirectedWeightedGraph<Vertex, Edge> makeGraph(Collection<SemanticUnit> potentialDomainMessages, Vertex source, Vertex sink, Map<SemanticUnit, Double> individualPreferences, Map<Pair<SemanticUnit>, Double> pairwisePreferences) {
        DefaultDirectedWeightedGraph graph = new DefaultDirectedWeightedGraph(Edge.class);
        graph.addVertex((Object)source);
        graph.addVertex((Object)sink);
        HashSet<Vertex> vertexSet = new HashSet<Vertex>();
        for (SemanticUnit su : potentialDomainMessages) {
            Edge e;
            Vertex v = new Vertex(su);
            graph.addVertex((Object)v);
            vertexSet.add(v);
            double individualPreference = individualPreferences.get(su);
            if (individualPreference >= 0.0) {
                e = (Edge)((Object)graph.addEdge((Object)source, (Object)v));
                graph.setEdgeWeight((Object)e, individualPreference);
                continue;
            }
            e = (Edge)((Object)graph.addEdge((Object)v, (Object)sink));
            graph.setEdgeWeight((Object)e, -individualPreference);
        }
        Vertex[] vertices = vertexSet.toArray(new Vertex[vertexSet.size()]);
        int v = 0;
        while (v < vertices.length - 1) {
            int u = v + 1;
            while (u < vertices.length) {
                double weight = pairwisePreferences.get(new Pair<SemanticUnit>(vertices[v].getSu(), vertices[u].getSu()));
                Edge e1 = (Edge)((Object)graph.addEdge((Object)vertices[v], (Object)vertices[u]));
                graph.setEdgeWeight((Object)e1, weight);
                Edge e2 = (Edge)((Object)graph.addEdge((Object)vertices[u], (Object)vertices[v]));
                graph.setEdgeWeight((Object)e2, weight);
                ++u;
            }
            ++v;
        }
        return graph;
    }

    private Collection<Vertex> getMinCut(Vertex source, Vertex sink, DefaultDirectedWeightedGraph<Vertex, Edge> graph, Map<Edge, Double> maxFlowEdges) {
        HashSet<Vertex> minCut = new HashSet<Vertex>();
        this.addToMinCutWithDfs(minCut, graph, maxFlowEdges, source, sink);
        return minCut;
    }

    private void addToMinCutWithDfs(Collection<Vertex> minCut, DefaultDirectedWeightedGraph<Vertex, Edge> graph, Map<Edge, Double> maxFlowEdges, Vertex v, Vertex sink) {
        if (v.equals(sink)) {
            throw new RuntimeException("WTF?!?");
        }
        for (Edge e : graph.outgoingEdgesOf((Object)v)) {
            Vertex u = (Vertex)graph.getEdgeTarget((Object)e);
            if (minCut.contains(u) || !(graph.getEdgeWeight((Object)e) - maxFlowEdges.get((Object)e) > 0.0)) continue;
            minCut.add(u);
            this.addToMinCutWithDfs(minCut, graph, maxFlowEdges, u, sink);
        }
    }

    public static class Edge
    extends DefaultWeightedEdge {
    }

    public static class Vertex {
        private SemanticUnit _su;

        public Vertex(SemanticUnit su) {
            this._su = su;
        }

        public SemanticUnit getSu() {
            return this._su;
        }
    }
}

