/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.core;

import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.TemplateParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ob.util.Pair;

public class SemanticTypedTemplateImpl
implements SemanticTypedTemplate {
    private String _id;
    private List<String> _entityTypes;
    private Map<Pair<Integer>, String> _entityRelations;
    private List<String> _templates;
    private List<String> _listTemplates;
    private double _preferenceScore;

    public SemanticTypedTemplateImpl(String id, List<String> entityTypes, Map<Pair<Integer>, String> entityRelations, List<String> templates, List<String> listTemplates, double preferenceScore) {
        this._id = id;
        this._entityTypes = entityTypes;
        this._entityRelations = entityRelations;
        this._templates = templates;
        this._listTemplates = listTemplates;
        this._preferenceScore = preferenceScore;
    }

    @Override
    public List<String> getTemplates() {
        return this._templates;
    }

    @Override
    public boolean matches(List<TemplateParameter> parameters, Map<Pair<Integer>, String> relations) {
        return this.matchesTypes(parameters) && this.matchesRelations(parameters, relations);
    }

    private boolean matchesTypes(List<TemplateParameter> parameters) {
        if (parameters.size() != this._entityTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < parameters.size()) {
            if (!(this._entityTypes.get(i).equals("type") || parameters.get(i).equals("type") || parameters.get(i).getType().equals(this._entityTypes.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean matchesRelations(List<TemplateParameter> parameters, Map<Pair<Integer>, String> relations) {
        if (relations == null) {
            return true;
        }
        if (relations.size() != this._entityRelations.size()) {
            return false;
        }
        HashSet<Pair<Integer>> matches = new HashSet<Pair<Integer>>();
        block0: for (Pair<Integer> outPair : relations.keySet()) {
            for (Pair<Integer> housePair : this._entityRelations.keySet()) {
                if (matches.contains(housePair) || !relations.get(outPair).equals(this._entityRelations.get(housePair))) continue;
                matches.add(housePair);
                continue block0;
            }
        }
        return matches.size() == this._entityRelations.size();
    }

    public String toString() {
        return this._id;
    }

    @Override
    public double getPreferenceScore() {
        return this._preferenceScore;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public List<String> getEntityTypes() {
        return this._entityTypes;
    }

    @Override
    public Map<Pair<Integer>, String> getEntityRelations() {
        return this._entityRelations;
    }

    @Override
    public List<String> getListTemplates() {
        return this._listTemplates;
    }
}

