/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.app.tester;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import ob.util.Counts;
import ob.util.Utils;

public class ShowPredicates {
    public static void main(String[] args) {
        String mappingFile = "C:/Users/Or/Desktop/mappingbased_properties_en.nt";
        String entityFile = "tmp/Politician";
        String keyPredicate = "occupation";
        Set<String> entities = ShowPredicates.readEntities(entityFile);
        System.out.println("done reading " + entities.size() + " entities");
        final Counts<String> counts = new Counts<String>();
        final Counts<String> keyPredicateCounts = new Counts<String>();
        double avgTriples = 0.0;
        int c = 0;
        for (String line : Utils.readLinesDynamically(mappingFile)) {
            if (line.startsWith("#")) continue;
            if (++c % 1000000 == 0) {
                System.out.println("at line " + c);
            }
            String[] tokens = line.split("\\s+");
            String subject = ShowPredicates.strip(tokens[0]);
            String predicate = ShowPredicates.strip(tokens[1]);
            String object = ShowPredicates.strip(tokens[2]);
            if (entities.contains(subject)) {
                counts.add(predicate);
                avgTriples += 1.0;
            }
            if (!predicate.equals(keyPredicate)) continue;
            keyPredicateCounts.add(object);
        }
        avgTriples /= (double)entities.size();
        ArrayList ordered = new ArrayList(counts);
        Collections.sort(ordered, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return counts.getCount(o1) - counts.getCount(o2);
            }
        });
        for (String predicate : ordered) {
            System.out.println(String.valueOf(predicate) + "\t\t\t -- \t\t\t" + counts.getCount(predicate));
        }
        System.out.println("---------------------------");
        ordered = new ArrayList(keyPredicateCounts);
        Collections.sort(ordered, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return keyPredicateCounts.getCount(o1) - keyPredicateCounts.getCount(o2);
            }
        });
        for (String kp : ordered) {
            if (keyPredicateCounts.getCount(kp) <= 9) continue;
            System.out.println(String.valueOf(kp) + "\t" + keyPredicateCounts.getCount(kp));
        }
        System.out.println(avgTriples);
    }

    private static Set<String> readEntities(String entityFile) {
        HashSet<String> entities = new HashSet<String>();
        for (String line : Utils.readLinesDynamically(entityFile)) {
            entities.add(line);
        }
        return entities;
    }

    private static String strip(String uri) {
        if (!uri.contains("/") || !uri.contains(">")) {
            return uri;
        }
        return uri.substring(uri.lastIndexOf("/") + 1, uri.indexOf(">"));
    }
}

