/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.app;

import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.paraphraseMining.FindEntities;
import edu.columbia.ob.gen.paraphraseMining.MakePosTags;
import edu.columbia.ob.gen.paraphraseMining.MatchSentences;
import edu.columbia.ob.gen.paraphraseMining.TransductiveClustering;
import java.io.File;

public class GenerateParaphrases {
    public static void main(String[] args) throws Exception {
        String domainName;
        String corpusDir;
        File corpusFile;
        if (args.length != 1) {
            System.out.println("usage: GenerateParaphrases <domain_name>");
            System.exit(0);
        }
        if (!(corpusFile = new File(corpusDir = PreGenEnv.getSubjectDomainCorpusDir(domainName = args[0]), "corpus")).exists()) {
            throw new RuntimeException("Corpus file " + corpusFile.getAbsolutePath() + " doesn't exist!");
        }
        GenerateParaphrases.header("1/4: TAGGING THE CORPUS WITH PARTS OF SPEECH");
        File posTaggedFile = new File(corpusDir, "corpus.pos");
        if (!posTaggedFile.exists()) {
            MakePosTags.main(new String[]{corpusFile.getAbsolutePath(), posTaggedFile.getAbsolutePath()});
        }
        GenerateParaphrases.header("2/4: FINDING ALL ENTITIES AND FILTERING SENTENCES");
        File entitiesFile = new File(corpusDir, "corpus.entities");
        if (!entitiesFile.exists()) {
            String[] stringArray = new String[4];
            stringArray[0] = posTaggedFile.getAbsolutePath();
            stringArray[1] = entitiesFile.getAbsolutePath();
            FindEntities.main(stringArray);
        }
        System.exit(0);
        GenerateParaphrases.header("3/4: GROUPING POTENTIAL PARAPHRASE SENTENCES");
        File groupsFile = new File(corpusDir, "corpus.groups");
        if (!groupsFile.exists()) {
            String[] stringArray = new String[4];
            stringArray[0] = entitiesFile.getAbsolutePath();
            stringArray[1] = groupsFile.getAbsolutePath();
            MatchSentences.main(stringArray);
        }
        GenerateParaphrases.header("4/4: FINDING PARAPHRASE CLUSTERS WITHIN GROUPS");
        File paraphrasesFile = new File(corpusDir, "corpus.paraphrases");
        if (!paraphrasesFile.exists()) {
            TransductiveClustering.main(new String[]{groupsFile.getAbsolutePath(), paraphrasesFile.getAbsolutePath()});
        }
    }

    private static void header(String header) {
        String stars = "";
        int i = 0;
        while (i < header.length()) {
            stars = String.valueOf(stars) + "*";
            ++i;
        }
        System.out.println();
        System.out.println(stars);
        System.out.println(header);
        System.out.println(stars);
        System.out.println();
    }
}

