/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.text.ParseException;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.URLSourcedLoader;

public class ArffLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter,
URLSourcedLoader {
    static final long serialVersionUID = 2726929550544048587L;
    public static String FILE_EXTENSION = ".arff";
    public static String FILE_EXTENSION_COMPRESSED = FILE_EXTENSION + ".gz";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected transient ArffReader m_ArffReader = null;

    public String globalInfo() {
        return "Reads a source that is in arff (attribute relation file format) format. ";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_COMPRESSED};
    }

    public String getFileDescription() {
        return "Arff data files";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_ArffReader = null;
        this.setRetrieval(0);
        if (this.m_File != null && !new File(this.m_File).isDirectory()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
        this.m_File = null;
    }

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_File = file.getPath();
        this.setSource(file);
    }

    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    public Instances getStructure() throws IOException {
        if (this.m_structure == null) {
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            try {
                this.m_ArffReader = new ArffReader(this.m_sourceReader, 1);
                this.m_structure = this.m_ArffReader.getStructure();
            }
            catch (Exception ex) {
                throw new IOException("Unable to determine structure as arff (Reason: " + ex.toString() + ").");
            }
        }
        return new Instances(this.m_structure, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instances getDataSet() throws IOException {
        Instances insts = null;
        try {
            Instance inst;
            if (this.m_sourceReader == null) {
                throw new IOException("No source has been specified");
            }
            if (this.getRetrieval() == 2) {
                throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
            }
            this.setRetrieval(1);
            if (this.m_structure == null) {
                this.getStructure();
            }
            insts = new Instances(this.m_structure, 0);
            while ((inst = this.m_ArffReader.readInstance(this.m_structure)) != null) {
                insts.add(inst);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_sourceReader.close();
            throw throwable;
        }
        this.m_sourceReader.close();
        return insts;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        this.m_structure = structure;
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        Instance current = null;
        if (this.m_sourceReader != null) {
            current = this.m_ArffReader.readInstance(this.m_structure);
        }
        if (this.m_sourceReader != null && current == null) {
            try {
                this.m_sourceReader.close();
                this.m_sourceReader = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return current;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9653 $");
    }

    public static void main(String[] args) {
        ArffLoader.runFileLoader(new ArffLoader(), args);
    }

    public static class ArffReader
    implements RevisionHandler {
        protected StreamTokenizer m_Tokenizer;
        protected double[] m_ValueBuffer;
        protected int[] m_IndicesBuffer;
        protected Instances m_Data;
        protected int m_Lines;

        public ArffReader(Reader reader) throws IOException {
            Instance inst;
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.readHeader(1000);
            this.initBuffers();
            while ((inst = this.readInstance(this.m_Data)) != null) {
                this.m_Data.add(inst);
            }
            this.compactify();
        }

        public ArffReader(Reader reader, int capacity) throws IOException {
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity has to be positive!");
            }
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.readHeader(capacity);
            this.initBuffers();
        }

        public ArffReader(Reader reader, Instances template, int lines) throws IOException {
            this(reader, template, lines, 100);
            Instance inst;
            while ((inst = this.readInstance(this.m_Data)) != null) {
                this.m_Data.add(inst);
            }
            this.compactify();
        }

        public ArffReader(Reader reader, Instances template, int lines, int capacity) throws IOException {
            this.m_Lines = lines;
            this.m_Tokenizer = new StreamTokenizer(reader);
            this.initTokenizer();
            this.m_Data = new Instances(template, capacity);
            this.initBuffers();
        }

        protected void initBuffers() {
            this.m_ValueBuffer = new double[this.m_Data.numAttributes()];
            this.m_IndicesBuffer = new int[this.m_Data.numAttributes()];
        }

        protected void compactify() {
            if (this.m_Data != null) {
                this.m_Data.compactify();
            }
        }

        protected void errorMessage(String msg) throws IOException {
            String str = msg + ", read " + this.m_Tokenizer.toString();
            if (this.m_Lines > 0) {
                int line = Integer.parseInt(str.replaceAll(".* line ", ""));
                str = str.replaceAll(" line .*", " line " + (this.m_Lines + line - 1));
            }
            throw new IOException(str);
        }

        public int getLineNo() {
            return this.m_Lines + this.m_Tokenizer.lineno();
        }

        protected void getFirstToken() throws IOException {
            while (this.m_Tokenizer.nextToken() == 10) {
            }
            if (this.m_Tokenizer.ttype == 39 || this.m_Tokenizer.ttype == 34) {
                this.m_Tokenizer.ttype = -3;
            } else if (this.m_Tokenizer.ttype == -3 && this.m_Tokenizer.sval.equals("?")) {
                this.m_Tokenizer.ttype = 63;
            }
        }

        protected void getIndex() throws IOException {
            if (this.m_Tokenizer.nextToken() == 10) {
                this.errorMessage("premature end of line");
            }
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
        }

        protected void getLastToken(boolean endOfFileOk) throws IOException {
            if (!(this.m_Tokenizer.nextToken() == 10 || this.m_Tokenizer.ttype == -1 && endOfFileOk)) {
                this.errorMessage("end of line expected");
            }
        }

        protected double getInstanceWeight() throws IOException {
            double weight = Double.NaN;
            this.m_Tokenizer.nextToken();
            if (this.m_Tokenizer.ttype == 10 || this.m_Tokenizer.ttype == -1) {
                return weight;
            }
            if (this.m_Tokenizer.ttype == 123) {
                this.m_Tokenizer.nextToken();
                String weightS = this.m_Tokenizer.sval;
                try {
                    weight = Double.parseDouble(weightS);
                }
                catch (NumberFormatException e) {
                    return weight;
                }
                this.m_Tokenizer.nextToken();
                if (this.m_Tokenizer.ttype != 125) {
                    this.errorMessage("Problem reading instance weight");
                }
            }
            return weight;
        }

        protected void getNextToken() throws IOException {
            if (this.m_Tokenizer.nextToken() == 10) {
                this.errorMessage("premature end of line");
            }
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            } else if (this.m_Tokenizer.ttype == 39 || this.m_Tokenizer.ttype == 34) {
                this.m_Tokenizer.ttype = -3;
            } else if (this.m_Tokenizer.ttype == -3 && this.m_Tokenizer.sval.equals("?")) {
                this.m_Tokenizer.ttype = 63;
            }
        }

        protected void initTokenizer() {
            this.m_Tokenizer.resetSyntax();
            this.m_Tokenizer.whitespaceChars(0, 32);
            this.m_Tokenizer.wordChars(33, 255);
            this.m_Tokenizer.whitespaceChars(44, 44);
            this.m_Tokenizer.commentChar(37);
            this.m_Tokenizer.quoteChar(34);
            this.m_Tokenizer.quoteChar(39);
            this.m_Tokenizer.ordinaryChar(123);
            this.m_Tokenizer.ordinaryChar(125);
            this.m_Tokenizer.eolIsSignificant(true);
        }

        public Instance readInstance(Instances structure) throws IOException {
            return this.readInstance(structure, true);
        }

        public Instance readInstance(Instances structure, boolean flag) throws IOException {
            return this.getInstance(structure, flag);
        }

        protected Instance getInstance(Instances structure, boolean flag) throws IOException {
            this.m_Data = structure;
            if (this.m_Data.numAttributes() == 0) {
                this.errorMessage("no header information available");
            }
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                return null;
            }
            if (this.m_Tokenizer.ttype == 123) {
                return this.getInstanceSparse(flag);
            }
            return this.getInstanceFull(flag);
        }

        protected Instance getInstanceSparse(boolean flag) throws IOException {
            int numValues = 0;
            int maxIndex = -1;
            while (true) {
                this.getIndex();
                if (this.m_Tokenizer.ttype == 125) break;
                try {
                    this.m_IndicesBuffer[numValues] = Integer.valueOf(this.m_Tokenizer.sval);
                }
                catch (NumberFormatException e) {
                    this.errorMessage("index number expected");
                }
                if (this.m_IndicesBuffer[numValues] <= maxIndex) {
                    this.errorMessage("indices have to be ordered");
                }
                if (this.m_IndicesBuffer[numValues] < 0 || this.m_IndicesBuffer[numValues] >= this.m_Data.numAttributes()) {
                    this.errorMessage("index out of bounds");
                }
                maxIndex = this.m_IndicesBuffer[numValues];
                this.getNextToken();
                if (this.m_Tokenizer.ttype == 63) {
                    this.m_ValueBuffer[numValues] = Instance.missingValue();
                } else {
                    if (this.m_Tokenizer.ttype != -3) {
                        this.errorMessage("not a valid value");
                    }
                    switch (this.m_Data.attribute(this.m_IndicesBuffer[numValues]).type()) {
                        case 1: {
                            int valIndex = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).indexOfValue(this.m_Tokenizer.sval);
                            if (valIndex == -1) {
                                this.errorMessage("nominal value not declared in header");
                            }
                            this.m_ValueBuffer[numValues] = valIndex;
                            break;
                        }
                        case 0: {
                            try {
                                this.m_ValueBuffer[numValues] = Double.valueOf(this.m_Tokenizer.sval);
                            }
                            catch (NumberFormatException e) {
                                this.errorMessage("number expected");
                            }
                            break;
                        }
                        case 2: {
                            this.m_ValueBuffer[numValues] = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).addStringValue(this.m_Tokenizer.sval);
                            break;
                        }
                        case 3: {
                            try {
                                this.m_ValueBuffer[numValues] = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).parseDate(this.m_Tokenizer.sval);
                            }
                            catch (ParseException e) {
                                this.errorMessage("unparseable date: " + this.m_Tokenizer.sval);
                            }
                            break;
                        }
                        case 4: {
                            try {
                                ArffReader arff = new ArffReader(new StringReader(this.m_Tokenizer.sval), this.m_Data.attribute(this.m_IndicesBuffer[numValues]).relation(), 0);
                                Instances data = arff.getData();
                                this.m_ValueBuffer[numValues] = this.m_Data.attribute(this.m_IndicesBuffer[numValues]).addRelation(data);
                                break;
                            }
                            catch (Exception e) {
                                throw new IOException(e.toString() + " of line " + this.getLineNo());
                            }
                        }
                        default: {
                            this.errorMessage("unknown attribute type in column " + this.m_IndicesBuffer[numValues]);
                        }
                    }
                }
                ++numValues;
            }
            double weight = 1.0;
            if (flag) {
                weight = this.getInstanceWeight();
                if (!Double.isNaN(weight)) {
                    this.getLastToken(true);
                } else {
                    weight = 1.0;
                }
            }
            double[] tempValues = new double[numValues];
            int[] tempIndices = new int[numValues];
            System.arraycopy(this.m_ValueBuffer, 0, tempValues, 0, numValues);
            System.arraycopy(this.m_IndicesBuffer, 0, tempIndices, 0, numValues);
            SparseInstance inst = new SparseInstance(weight, tempValues, tempIndices, this.m_Data.numAttributes());
            inst.setDataset(this.m_Data);
            return inst;
        }

        protected Instance getInstanceFull(boolean flag) throws IOException {
            double[] instance = new double[this.m_Data.numAttributes()];
            block13: for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
                if (i > 0) {
                    this.getNextToken();
                }
                if (this.m_Tokenizer.ttype == 63) {
                    instance[i] = Instance.missingValue();
                    continue;
                }
                if (this.m_Tokenizer.ttype != -3) {
                    this.errorMessage("not a valid value");
                }
                switch (this.m_Data.attribute(i).type()) {
                    case 1: {
                        int index = this.m_Data.attribute(i).indexOfValue(this.m_Tokenizer.sval);
                        if (index == -1) {
                            this.errorMessage("nominal value not declared in header");
                        }
                        instance[i] = index;
                        continue block13;
                    }
                    case 0: {
                        try {
                            instance[i] = Double.valueOf(this.m_Tokenizer.sval);
                        }
                        catch (NumberFormatException e) {
                            this.errorMessage("number expected");
                        }
                        continue block13;
                    }
                    case 2: {
                        instance[i] = this.m_Data.attribute(i).addStringValue(this.m_Tokenizer.sval);
                        continue block13;
                    }
                    case 3: {
                        try {
                            instance[i] = this.m_Data.attribute(i).parseDate(this.m_Tokenizer.sval);
                        }
                        catch (ParseException e) {
                            this.errorMessage("unparseable date: " + this.m_Tokenizer.sval);
                        }
                        continue block13;
                    }
                    case 4: {
                        try {
                            ArffReader arff = new ArffReader(new StringReader(this.m_Tokenizer.sval), this.m_Data.attribute(i).relation(), 0);
                            Instances data = arff.getData();
                            instance[i] = this.m_Data.attribute(i).addRelation(data);
                            continue block13;
                        }
                        catch (Exception e) {
                            throw new IOException(e.toString() + " of line " + this.getLineNo());
                        }
                    }
                    default: {
                        this.errorMessage("unknown attribute type in column " + i);
                    }
                }
            }
            double weight = 1.0;
            if (flag) {
                weight = this.getInstanceWeight();
                if (!Double.isNaN(weight)) {
                    this.getLastToken(true);
                } else {
                    weight = 1.0;
                }
            }
            Instance inst = new Instance(weight, instance);
            inst.setDataset(this.m_Data);
            return inst;
        }

        protected void readHeader(int capacity) throws IOException {
            this.m_Lines = 0;
            String relationName = "";
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            if ("@relation".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                this.getNextToken();
                relationName = this.m_Tokenizer.sval;
                this.getLastToken(false);
            } else {
                this.errorMessage("keyword @relation expected");
            }
            FastVector attributes = new FastVector();
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            while ("@attribute".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                attributes = this.parseAttribute(attributes);
            }
            if (!"@data".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                this.errorMessage("keyword @data expected");
            }
            if (attributes.size() == 0) {
                this.errorMessage("no attributes declared");
            }
            this.m_Data = new Instances(relationName, attributes, capacity);
        }

        protected FastVector parseAttribute(FastVector attributes) throws IOException {
            this.getNextToken();
            String attributeName = this.m_Tokenizer.sval;
            this.getNextToken();
            if (this.m_Tokenizer.ttype == -3) {
                if (this.m_Tokenizer.sval.equalsIgnoreCase("real") || this.m_Tokenizer.sval.equalsIgnoreCase("integer") || this.m_Tokenizer.sval.equalsIgnoreCase("numeric")) {
                    attributes.addElement(new Attribute(attributeName, attributes.size()));
                    this.readTillEOL();
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("string")) {
                    attributes.addElement(new Attribute(attributeName, (FastVector)null, attributes.size()));
                    this.readTillEOL();
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("date")) {
                    String format = null;
                    if (this.m_Tokenizer.nextToken() != 10) {
                        if (this.m_Tokenizer.ttype != -3 && this.m_Tokenizer.ttype != 39 && this.m_Tokenizer.ttype != 34) {
                            this.errorMessage("not a valid date format");
                        }
                        format = this.m_Tokenizer.sval;
                        this.readTillEOL();
                    } else {
                        this.m_Tokenizer.pushBack();
                    }
                    attributes.addElement(new Attribute(attributeName, format, attributes.size()));
                } else if (this.m_Tokenizer.sval.equalsIgnoreCase("relational")) {
                    this.readTillEOL();
                    FastVector atts = attributes;
                    attributes = new FastVector();
                    this.getFirstToken();
                    if (this.m_Tokenizer.ttype == -1) {
                        this.errorMessage("premature end of file");
                    }
                    while (true) {
                        if ("@attribute".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                            attributes = this.parseAttribute(attributes);
                            continue;
                        }
                        if ("@end".equalsIgnoreCase(this.m_Tokenizer.sval)) {
                            this.getNextToken();
                            if (attributeName.equalsIgnoreCase(this.m_Tokenizer.sval)) break;
                            this.errorMessage("declaration of subrelation " + attributeName + " must be terminated by " + "@end " + attributeName);
                            break;
                        }
                        this.errorMessage("declaration of subrelation " + attributeName + " must be terminated by " + "@end " + attributeName);
                    }
                    Instances relation = new Instances(attributeName, attributes, 0);
                    attributes = atts;
                    attributes.addElement(new Attribute(attributeName, relation, attributes.size()));
                } else {
                    this.errorMessage("no valid attribute type or invalid enumeration");
                }
            } else {
                FastVector attributeValues = new FastVector();
                this.m_Tokenizer.pushBack();
                if (this.m_Tokenizer.nextToken() != 123) {
                    this.errorMessage("{ expected at beginning of enumeration");
                }
                while (this.m_Tokenizer.nextToken() != 125) {
                    if (this.m_Tokenizer.ttype == 10) {
                        this.errorMessage("} expected at end of enumeration");
                        continue;
                    }
                    attributeValues.addElement(this.m_Tokenizer.sval);
                }
                attributes.addElement(new Attribute(attributeName, attributeValues, attributes.size()));
            }
            this.getLastToken(false);
            this.getFirstToken();
            if (this.m_Tokenizer.ttype == -1) {
                this.errorMessage("premature end of file");
            }
            return attributes;
        }

        protected void readTillEOL() throws IOException {
            while (this.m_Tokenizer.nextToken() != 10) {
            }
            this.m_Tokenizer.pushBack();
        }

        public Instances getStructure() {
            return new Instances(this.m_Data, 0);
        }

        public Instances getData() {
            return this.m_Data;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9653 $");
        }
    }
}

