# zrpsim.tcl
# A simple example for zrp simulation

#arguments: 0: nn,	1: sc,	2: xgridsz  3: ygridsz  4-5 cp/gspProb
# ======================================================================
# Define options
# ======================================================================
set val(chan)           Channel/WirelessChannel    ;# channel type
set val(prop)           Propagation/TwoRayGround   ;# radio-propagation model
set val(netif)          Phy/WirelessPhy            ;# network interface type
#set val(mac)            Mac/NULL                  ;# MAC type 802_11
set val(mac)            [lindex $argv 0]           ;# Mac/WaveLAN1   ;#Mac/802_11
set val(ifq)            Queue/DropTail/PriQueue    ;# interface queue type
set val(ll)             LL                         ;# link layer type
set val(ant)            Antenna/OmniAntenna        ;# antenna model
set val(ifqlen)         50000                      ;# max packet in ifq
set val(rp)             AODV                       ;# routing protocol
set val(cp)	        [lindex $argv 1]           ;# cbr-100-qr1 cbr-100-allr2
set val(stop)		600 			   ;# 500  28 ;# simulation time 10040.0
set val(seed)		1973272912		   ;#2756743			   
set val(nn)             [lindex $argv 2]           ;#    
set val(nc)             [lindex $argv 3]           ;#60  99
set val(sc)		[lindex $argv 4]	   ;# 
set val(xgridsz)	[lindex $argv 5]	   ;# 
set val(ygridsz)	[lindex $argv 6]	   ;#
set val(radius)         0                          ;# correlated with Antenna parameters, etc.
set val(energymodel)    EnergyModel                ;#
#set val(initialenergy)  [lindex $argv 7]           ;# Initial energy in Joules
#set val(whichalgo) 	[lindex $argv 8]
set val(whichScf_)       [lindex $argv 7]

Queue			set limit_		64 ;#3/10/01:   1024

#another place for gspPrb_
Agent/AODV	        set gspPrb_		0.65
Agent/AODV	        set gspNumMsgs_	        0
Agent/AODV	        set kParam_		1
Agent/AODV	        set whichTnw_		0 ;# 1/4/2001: which type of networks: random, hex3, grid, hex6
Agent/AODV	        set endSim_		$val(stop)
Agent/AODV	        set whichScf_		$val(whichScf_)


#  0: our basic algo. 1: our basic algo. with edge removal
#  2: dump algo.      3: T. Meng's algo.
#  4: MST             5: T. Meng's original algo.
#lili 8/5/04
#Agent/AODV	        set whichalgo_		$val(whichalgo)
#Node/MobileNode         set whichAlg_           $val(whichalgo)
#Node/MobileNode         set whichScf_           $val(whichscf)     

#if { $val(whichalgo) == 0 } {
#    Node/MobileNode         set shback_             [lindex $argv 10]
#    Node/MobileNode         set oneWR_              [lindex $argv 11]
#    Node/MobileNode         set angBound_           [lindex $argv 12]
#} else {
#    Node/MobileNode         set shback_             0
#    Node/MobileNode         set oneWR_              0
#    
#    if { $val(whichalgo) == 1 } {
#        Node/MobileNode     set angBound_           [lindex $argv 10]
#    } else {
#        Node/MobileNode     set angBound_           0
#    }
#}


#Agent/ZRP	        set gspPrb_		1.0
#Agent/ZRP	        set gspIerpPrb_		[lindex $argv 0]
#Agent/ZRP               set gspNumMsgs_		0
#Agent/ZRP               set zone_radius_	2

puts stdout  "xgridsz=$val(xgridsz), ygridsz=$val(ygridsz)"

Antenna/OmniAntenna	set X_  0
Antenna/OmniAntenna	set Y_  0
Antenna/OmniAntenna	set Z_ 1.5
Antenna/OmniAntenna	set Gt_ 1.0
Antenna/OmniAntenna	set Gr_ 1.0
#Antenna/OmniAntenna	set Z_  0.06		   ;# 0.06 covers radius 10
#not a good way	acc. brad karp changes behavior	within los
   
# ======================================================================
# Main Program
# ======================================================================

ns-random       $val(seed)


#
# Initialize Global Variables
#
set ns_		[new Simulator]
regexp {Mac/(.*)} $val(mac) match whichMac 
#set tracefd     [open "appef5-n[set val(nn)]-alg[set val(whichalgo)]-cn[set val(nc)]-[set whichMac]-s[set val(whichscf)].tr"  w]
set tracefd     [open "app-n[set val(nn)]-p0.65-k1-s[set val(whichScf_)].tr"  w]  ;#app-n100-p0.65-k1-s2.tr

#$ns_  use-newtrace

$ns_ trace-all $tracefd

$ns_ clearMemTrace

#set namtrace    [open test15nodes.nam w]
#$ns_ namtrace-all-wireless $namtrace $val(xgridsz) $val(ygridsz)


# set up topography object
set topo       [new Topography]

$topo load_flatgrid $val(xgridsz) $val(ygridsz) 

#
# Create God
#
set god_ [create-god $val(nn)]

#
#  Create the specified number of mobilenodes [$val(nn)] and "attach" them
#  to the channel. 
#  Here two nodes are created : node(0) and node(1)

# configure node
#			 -initialEnergy $val(initialenergy) \
#			 -rxPower 0.3 \
#			 -txPower 0.6 \
#			 -energyModel $val(energymodel) \

# 8/9/04: need to turn on routerTrace 

        $ns_ node-config -adhocRouting $val(rp) \
			 -llType $val(ll) \
			 -macType $val(mac) \
			 -ifqType $val(ifq) \
			 -ifqLen $val(ifqlen) \
			 -antType $val(ant) \
			 -propType $val(prop) \
			 -phyType $val(netif) \
			 -channelType $val(chan) \
			 -topoInstance $topo \
			 -agentTrace ON \
			 -routerTrace ON \
			 -macTrace OFF \
			 -movementTrace OFF			
			 
 	for {set i 0} {$i < $val(nn) } {incr i} {
		set node_($i) [$ns_ node]	
		$node_($i) random-motion 0  ;# disable random motion
	    $node_($i) radius $val(radius)  ;#LILI
	}



#puts "Loading connection pattern..."
puts stdout $val(cp)
source $val(cp)

#
# 2 connecting to 3 at time 83.639723482373967
#
#set udp_(0) [new Agent/UDP]
#$ns_ attach-agent $node_(2) $udp_(0)
#set null_(0) [new Agent/Null]
#$ns_ attach-agent $node_(3) $null_(0)
#set cbr_(0) [new Application/Traffic/CBR]
#$cbr_(0) set packetSize_ 512
#$cbr_(0) set interval_ 33333.333333333336
#$cbr_(0) set random_ 1
#$cbr_(0) set maxpkts_ 10000
#$cbr_(0) attach-agent $udp_(0)
#$ns_ connect $udp_(0) $null_(0)
#$ns_ at 83.639723482373967 "$cbr_(0) start"


# 
# Define traffic model
#
puts "Loading scenario file..."
puts stdout $val(sc)
source $val(sc)

# Define node initial position in nam

for {set i 0} {$i < $val(nn)} {incr i} {

    # 20 defines the node size in nam, must adjust it according to your scenario
    # The function must be called after mobility model is defined
    
    $ns_ initial_node_pos $node_($i) 20
}



#
# Tell nodes when the simulation ends
#
for {set i 0} {$i < $val(nn) } {incr i} {
    $ns_ at $val(stop).00001 "$node_($i) reset";
}

$ns_ clearMemTrace

proc record {} {
    # for array, just global itself will be ok
    global tracefd  val lossMon_

    #Get an instance of the simulator
    #set ns [Simulator instance]
    
    #How many bytes have been received by the traffic sinks?
    set totalpkts 0
    set totallost 0
    for {set i 0} {$i < $val(nc) } {incr i} {
	set npkts [$lossMon_($i) set npkts_]
	set totalpkts [expr $totalpkts+$npkts]

	set nlost [$lossMon_($i) set nlost_]
	set totallost [expr $totallost+$nlost]

	puts $tracefd "traffic sink $i received $npkts  packets, lost $nlost "
    }

    puts $tracefd "total packets received $totalpkts, total packets lost $totallost"
}


$ns_ at  $val(stop)  "record"

# tell nam the simulation stop time
#$ns_ at  $val(stop)	"$ns_ nam-end-wireless $val(stop)"

$ns_ at $val(stop).00001  "puts \"NS EXITING...\" ; $ns_ halt"


puts "Starting Simulation..."
$ns_ run

$ns_ clearMemTrace






