/* Software for datacube computations.

   Written by Ken Ross, December 1996 - January 1997.
   Extended July 1997.
   
   Copyright (c) The Trustees of Columbia University in the City of New York.
*/

// The following include file is for qsort
#include <stdlib.h>

extern int gatts;

int distributive = 0;

char aggname[] ="Median and Quartiles";

// The code below is for a user to define his/her own nondistributive
// aggregate function(s).  A template for median plus quartiles is
// given below.  To use a user-defined function, copy this file to
// "libmfcube.C" and execute "make libmfcube.so".

int total_aggs()
{
  // Just return the number of aggregate columns in the cube output;
  // don't include the grouping columns.  Eg., for a simple median, just
  // include the code "return 1;"

  return 3;  // Change this command if there is a different number of
             // aggregate values
}  

static  int intcompare(const void *i, const void *j)
{
  if (*(int*)i > *(int*)j)
    return (1);
  if (*(int*)i < *(int*)j)
    return (-1);
  return (0);
}

int compute(int* first, int count, int* dest, int width)
{
  qsort((char *) first,count,sizeof(int)*width,intcompare);
  (*dest) = first[(count/4)]; // low quartile
  dest++;
  (*dest) = first[(count/2)]; // median (leans left for even cardinalities)
  dest++;
  (*dest) = first[(3*count/4)]; // high quartile

  return 1;  // Return 0 if you want this group to generate no output
}

// The following three routines are not called for nondistributive
// functions, but dummy interfaces are necessary to prevent linkage
// errors.

void agg_initialize(int* acc)
{
}

void combine(int* acc, int* curr)
{
}

void tconvert(int* acc, int*curr)
{
}
