/* Software for datacube computations.

   Written by Ken Ross, December 1996 - January 1997.
   Extended July 1997.
   
   Copyright (c) The Trustees of Columbia University in the City of New York.
*/

extern int gatts;

int distributive = 1;

char aggname[] ="Procedural sum and count";

// The code below is for a user to define his/her own distributive
// aggregate function(s).  A template for the combination of sum and
// count is given below.  To use a user-defined function, copy this
// file to "libmfcube.C" and execute "make libmfcube.so".

int total_aggs()
{
  // Just return the number of aggregate columns in the cube output;
  // don't include the grouping columns.  Eg., for a simple sum, just
  // include the code "return 1;"

  return 2;  // Change this command if there is a different
             // number of aggregate values
}  

void agg_initialize(int* acc)
{
  // This routine should initialize all aggregate columns.
  // Other initialization takes place elsewhere.
  // For example, a simple sum would have the value initialized
  // to zero.  acc is a pointer to the start of the grouping columns.
  // To get to the start of the aggregate columns, execute
  // "acc += gatts;" as below

  acc += gatts;

  (*acc) =0;  // Change this command for other aggregate functions.
  acc++;
  (*acc) =0;  // Change this command for other aggregate functions.
}

void combine(int* acc, int* curr)
{
  // This routine should combine the running aggregates in acc with a
  // new set of aggregate values from curr.  For example, a simple sum
  // would have the value in curr added to the value of acc.  acc and
  // curr are pointers to the start of the grouping columns.  To get
  // to the start of the aggregate columns, execute "acc += gatts;
  // curr += gatts;" as below

  acc+=gatts; curr+=gatts;

  (*acc) += (*curr); // Change this command for other aggregate functions
  acc++; curr++;
  (*acc) += (*curr); // Change this command for other aggregate functions
}

void tconvert(int* acc, int*curr)
{
  // This routine should convert an input tuple's measure columns into
  // aggregates of a singleton set containing that tuple.  acc points
  // to the beginning of the aggregate columns, and curr points to the
  // beginning of the measure columns of the input.  (For some
  // aggregates, there may be an unequal number of input columns and
  // aggregate columns.)  For a simple sum, the aggregate is
  // initialized to the input value; for count, the aggregate is
  // initialized to 1.

  (*acc) = (*curr);  // Change this command for other aggregate functions
  acc++; curr++;
  (*acc) = 1;        // Change this command for other aggregate functions
}

// The following routine is not called for distributive functions, but
// a dummy interface is necessary to prevent linkage errors.

int compute(int* first, int count, int* dest, int width)
{
return 0;
}
