/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.logging;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import orbital.util.logging.Filter;
import orbital.util.logging.Handler;
import orbital.util.logging.Level;
import orbital.util.logging.LogManager;
import orbital.util.logging.LogRecord;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager = LogManager.getLogManager();
    private String name;
    private ArrayList handlers;
    private String resourceBundleName;
    private boolean useParentHandlers = true;
    private Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static Object treeLock = new Object();
    private Logger parent;
    private ArrayList kids;
    private Level levelObject;
    private volatile int levelValue;
    public static final Logger global = Logger.getLogger("global");

    protected Logger(String name, String resourceBundleName) {
        if (resourceBundleName != null) {
            this.setupResourceInfo(resourceBundleName);
        }
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    public static synchronized Logger getLogger(String name) {
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.getLogger(name);
        if (result == null) {
            result = new Logger(name, null);
            manager.addLogger(result);
            result = manager.getLogger(name);
        }
        return result;
    }

    public static synchronized Logger getLogger(String name, String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.getLogger(name);
        if (result == null) {
            result = new Logger(name, resourceBundleName);
            manager.addLogger(result);
            result = manager.getLogger(name);
        }
        if (result.resourceBundleName == null) {
            result.setupResourceInfo(resourceBundleName);
        } else if (!result.resourceBundleName.equals(resourceBundleName)) {
            throw new IllegalArgumentException(result.resourceBundleName + " != " + resourceBundleName);
        }
        return result;
    }

    public static synchronized Logger getAnonymousLogger() {
        LogManager manager = LogManager.getLogManager();
        Logger result = new Logger(null, null);
        result.anonymous = true;
        Logger root = manager.getLogger("");
        result.doSetParent(root);
        return result;
    }

    public static synchronized Logger getAnonymousLogger(String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger result = new Logger(null, resourceBundleName);
        result.anonymous = true;
        Logger root = manager.getLogger("");
        result.doSetParent(root);
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName());
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.filter = newFilter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogRecord record) {
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        Logger logger = this;
        synchronized (logger) {
            if (this.filter != null && !this.filter.isLoggable(record)) {
                return;
            }
        }
        Logger logger2 = this;
        while (logger2 != null) {
            Handler[] targets = logger2.getHandlers();
            if (targets != null) {
                int i = 0;
                while (i < targets.length) {
                    targets[i].publish(record);
                    ++i;
                }
            }
            if (!logger2.getUseParentHandlers()) break;
            logger2 = logger2.getParent();
        }
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this.name);
        String ebname = this.getEffectiveResourceBundleName();
        if (ebname != null) {
            lr.setResourceBundleName(ebname);
            lr.setResourceBundle(this.findResourceBundle(ebname));
        }
        this.log(lr);
    }

    public void log(Level level, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.name);
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname));
        }
        this.log(lr);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr, bundleName);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String msg = "ENTRY";
        int i = 0;
        while (i < params.length) {
            msg = msg + " {" + i + "}";
            ++i;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{result};
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINER, "THROW");
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void severe(String msg) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level newLevel) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = newLevel;
            this.updateEffectiveLevel();
        }
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (handler == null) {
            throw new NullPointerException();
        }
        if (this.handlers == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public synchronized Handler[] getHandlers() {
        if (this.handlers == null) {
            return emptyHandlers;
        }
        Handler[] result = new Handler[this.handlers.size()];
        result = this.handlers.toArray(result);
        return result;
    }

    public synchronized void setUseParentHandlers(boolean useParentHandlers) {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.useParentHandlers = useParentHandlers;
    }

    public synchronized boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private synchronized ResourceBundle findResourceBundle(String name) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        if (this.catalog != null && currentLocale == this.catalogLocale && name == this.catalogName) {
            return this.catalog;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
            this.catalogName = name;
            this.catalogLocale = currentLocale;
            return this.catalog;
        }
        catch (MissingResourceException ex) {
            Class clz;
            int ix = 0;
            while ((clz = null) != null) {
                ClassLoader cl2 = clz.getClassLoader();
                if (cl2 == null) {
                    cl2 = ClassLoader.getSystemClassLoader();
                }
                if (cl != cl2) {
                    cl = cl2;
                    try {
                        this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
                        this.catalogName = name;
                        this.catalogLocale = currentLocale;
                        return this.catalog;
                    }
                    catch (MissingResourceException ex2) {
                        // empty catch block
                    }
                }
                ++ix;
            }
            if (name.equals(this.catalogName)) {
                return this.catalog;
            }
            return null;
        }
    }

    private synchronized void setupResourceInfo(String name) {
        if (name == null) {
            return;
        }
        ResourceBundle rb = this.findResourceBundle(name);
        if (rb == null) {
            throw new MissingResourceException("Can't find " + name + " bundle", name, "");
        }
        this.resourceBundleName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getParent() {
        Object object = treeLock;
        synchronized (object) {
            return this.parent;
        }
    }

    public void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.manager.checkAccess();
        this.doSetParent(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger newParent) {
        Object object = treeLock;
        synchronized (object) {
            if (this.parent != null) {
                Iterator iter = this.parent.kids.iterator();
                while (iter.hasNext()) {
                    WeakReference ref = (WeakReference)iter.next();
                    Logger kid = (Logger)ref.get();
                    if (kid != this) continue;
                    iter.remove();
                    break;
                }
            }
            this.parent = newParent;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            this.parent.kids.add(new WeakReference<Logger>(this));
            this.updateEffectiveLevel();
        }
    }

    private void updateEffectiveLevel() {
        int newLevelValue = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == newLevelValue) {
            return;
        }
        this.levelValue = newLevelValue;
        if (this.kids != null) {
            int i = 0;
            while (i < this.kids.size()) {
                WeakReference ref = (WeakReference)this.kids.get(i);
                Logger kid = (Logger)ref.get();
                if (kid != null) {
                    kid.updateEffectiveLevel();
                }
                ++i;
            }
        }
    }

    private String getEffectiveResourceBundleName() {
        Logger target = this;
        while (target != null) {
            String rbn = target.getResourceBundleName();
            if (rbn != null) {
                return rbn;
            }
            target = target.getParent();
        }
        return null;
    }
}

