/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import orbital.util.logging.Filter;
import orbital.util.logging.Formatter;
import orbital.util.logging.Handler;
import orbital.util.logging.Level;
import orbital.util.logging.LogRecord;
import orbital.util.logging.Logger;
import orbital.util.logging.LoggingPermission;

public class LogManager {
    private static LogManager manager;
    private static final Handler[] emptyHandlers;
    private Properties props = new Properties();
    private PropertyChangeSupport changes = new PropertyChangeSupport(class$orbital$util$logging$LogManager == null ? (class$orbital$util$logging$LogManager = LogManager.class$("orbital.util.logging.LogManager")) : class$orbital$util$logging$LogManager);
    private static final Level defaultLevel;
    private Hashtable loggers = new Hashtable();
    private LogNode root = new LogNode(null);
    private Logger rootLogger;
    private boolean initializedGlobalHandlers = true;
    private boolean deathImminent;
    private Permission ourPermission = new LoggingPermission("control", null);
    static /* synthetic */ Class class$orbital$util$logging$LogManager;

    protected LogManager() {
        Runtime.getRuntime().addShutdownHook(new Cleaner());
    }

    public static LogManager getLogManager() {
        return manager;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changes.removePropertyChangeListener(l);
    }

    public synchronized boolean addLogger(Logger logger) {
        int ix2;
        String name = logger.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        Logger old = (Logger)this.loggers.get(name);
        if (old != null) {
            return false;
        }
        this.loggers.put(name, logger);
        Level level = this.getLevelProperty(name + ".level", null);
        if (level != null) {
            LogManager.doSetLevel(logger, level);
        }
        int ix = 1;
        while ((ix2 = name.indexOf(".", ix)) >= 0) {
            String pname = name.substring(0, ix2);
            if (this.getProperty(pname + ".level") != null) {
                Logger plogger = Logger.getLogger(pname);
            }
            ix = ix2 + 1;
        }
        LogNode node = this.findNode(name);
        node.logger = logger;
        Logger parent = null;
        LogNode nodep = node.parent;
        while (nodep != null) {
            if (nodep.logger != null) {
                parent = nodep.logger;
                break;
            }
            nodep = nodep.parent;
        }
        if (parent != null) {
            LogManager.doSetParent(logger, parent);
        }
        node.walkAndSetParent(logger);
        return true;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger parent) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            logger.setParent(parent);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setParent(parent);
                return null;
            }
        });
    }

    private LogNode findNode(String name) {
        if (name == null || name.equals("")) {
            return this.root;
        }
        LogNode node = this.root;
        while (name.length() > 0) {
            LogNode child;
            String head;
            int ix = name.indexOf(".");
            if (ix > 0) {
                head = name.substring(0, ix);
                name = name.substring(ix + 1);
            } else {
                head = name;
                name = "";
            }
            if (node.children == null) {
                node.children = new HashMap();
            }
            if ((child = (LogNode)node.children.get(head)) == null) {
                child = new LogNode(node);
                node.children.put(head, child);
            }
            node = child;
        }
        return node;
    }

    public synchronized Logger getLogger(String name) {
        return (Logger)this.loggers.get(name);
    }

    public synchronized Enumeration getLoggerNames() {
        return this.loggers.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readConfiguration() throws IOException, SecurityException {
        String fname;
        this.checkAccess();
        String cname = System.getProperty("orbital.util.logging.config.class");
        if (cname != null) {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                clz.newInstance();
                return;
            }
            catch (Exception ex) {
                System.err.println("Logging configuration class \"" + cname + "\" failed");
                System.err.println("" + ex);
            }
        }
        if ((fname = System.getProperty("orbital.util.logging.config.file")) == null) {
            fname = System.getProperty("java.home");
            if (fname == null) {
                throw new Error("Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, "logging.properties");
            fname = f.getCanonicalPath();
        }
        FileInputStream in = new FileInputStream(fname);
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            this.readConfiguration(bin);
            Object var6_7 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (in == null) throw throwable;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkAccess();
        LogManager logManager = this;
        synchronized (logManager) {
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        Enumeration enumeration = this.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            this.resetLogger(name);
        }
    }

    private void resetLogger(String name) {
        Logger logger = this.getLogger(name);
        if (logger == null) {
            return;
        }
        Handler[] targets = logger.getHandlers();
        int i = 0;
        while (i < targets.length) {
            Handler h = targets[i];
            logger.removeHandler(h);
            try {
                h.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i;
        }
        if (name != null && name.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String propertyName) {
        String hands = this.getProperty(propertyName);
        if (hands == null) {
            return new String[0];
        }
        hands = hands.trim();
        int ix = 0;
        Vector<String> result = new Vector<String>();
        while (ix < hands.length()) {
            int end = ix;
            while (end < hands.length()) {
                if (Character.isWhitespace(hands.charAt(end)) || hands.charAt(end) == ',') break;
                ++end;
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.props.load(ins);
        String[] names = this.parseClassNames("config");
        int i = 0;
        while (i < names.length) {
            String word = names[i];
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(word);
                clz.newInstance();
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + word + "\"");
                System.err.println("" + ex);
            }
            ++i;
        }
        this.setLevelsOnExistingLoggers();
        this.changes.firePropertyChange(null, null, null);
        LogManager logManager = this;
        synchronized (logManager) {
            this.initializedGlobalHandlers = false;
        }
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception ex) {}
        return defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {}
        return defaultValue;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        if (this.deathImminent) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] names = LogManager.this.parseClassNames("handlers");
                int i = 0;
                while (i < names.length) {
                    String word = names[i];
                    try {
                        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(word);
                        Handler h = (Handler)clz.newInstance();
                        try {
                            String levs = LogManager.this.getProperty(word + ".level");
                            if (levs != null) {
                                h.setLevel(Level.parse(levs));
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("Can't set level for " + word);
                        }
                        LogManager.this.rootLogger.addHandler(h);
                    }
                    catch (Exception ex) {
                        System.err.println("Can't load log handler \"" + word + "\"");
                        System.err.println("" + ex);
                        ex.printStackTrace();
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(this.ourPermission);
    }

    private synchronized void setLevelsOnExistingLoggers() {
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.endsWith(".level")) continue;
            int ix = key.length() - 6;
            String name = key.substring(0, ix);
            Level level = this.getLevelProperty(key, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + key);
                continue;
            }
            Logger l = this.getLogger(name);
            if (l == null) continue;
            l.setLevel(level);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        emptyHandlers = new Handler[0];
        defaultLevel = Level.INFO;
        String cname = null;
        try {
            cname = System.getProperty("orbital.util.logging.manager");
            if (cname != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                manager = (LogManager)clz.newInstance();
            }
        }
        catch (Exception ex) {
            System.err.println("Could not load Logmanager \"" + cname + "\"");
            ex.printStackTrace();
        }
        if (manager == null) {
            manager = new LogManager();
        }
        LogManager logManager = manager;
        logManager.getClass();
        LogManager.manager.rootLogger = logManager.new RootLogger();
        manager.addLogger(LogManager.manager.rootLogger);
    }

    private class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null);
            this.setLevel(defaultLevel);
        }

        public void log(LogRecord record) {
            LogManager.this.initializeGlobalHandlers();
            super.log(record);
        }

        public void addHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(h);
        }

        public void removeHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(h);
        }

        public Handler[] getHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.getHandlers();
        }
    }

    private static class LogNode {
        HashMap children;
        Logger logger;
        LogNode parent;

        LogNode(LogNode parent) {
            this.parent = parent;
        }

        void walkAndSetParent(Logger parent) {
            if (this.children == null) {
                return;
            }
            Iterator values = this.children.values().iterator();
            while (values.hasNext()) {
                LogNode node = (LogNode)values.next();
                if (node.logger == null) {
                    node.walkAndSetParent(parent);
                    continue;
                }
                LogManager.doSetParent(node.logger, parent);
            }
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogManager logManager = LogManager.this;
            synchronized (logManager) {
                LogManager.this.deathImminent = true;
                LogManager.this.initializedGlobalHandlers = true;
            }
            LogManager.this.reset();
        }
    }
}

