/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.logging;

import java.io.UnsupportedEncodingException;
import orbital.util.logging.ErrorManager;
import orbital.util.logging.Filter;
import orbital.util.logging.Formatter;
import orbital.util.logging.Level;
import orbital.util.logging.LogManager;
import orbital.util.logging.LogRecord;
import sun.io.CharToByteConverter;

public abstract class Handler {
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager = LogManager.getLogManager();
    private Filter filter;
    private Formatter formatter;
    private Level logLevel = Level.ALL;
    private ErrorManager errorManager = new ErrorManager();
    private String encoding;
    boolean sealed = true;

    protected Handler() {
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public void setFormatter(Formatter newFormatter) throws SecurityException {
        this.checkAccess();
        newFormatter.getClass();
        this.formatter = newFormatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.checkAccess();
        if (encoding != null) {
            CharToByteConverter.getConverter((String)encoding);
        }
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.checkAccess();
        this.filter = newFilter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setErrorManager(ErrorManager em) {
        this.checkAccess();
        if (em == null) {
            throw new NullPointerException();
        }
        this.errorManager = em;
    }

    public ErrorManager getErrorManager() {
        this.checkAccess();
        return this.errorManager;
    }

    protected void reportError(String msg, Exception ex, int code) {
        try {
            this.errorManager.error(msg, ex, code);
        }
        catch (Exception ex2) {
            System.err.println("Handler.reportError caught:");
            ex2.printStackTrace();
        }
    }

    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        this.logLevel = newLevel;
    }

    public synchronized Level getLevel() {
        return this.logLevel;
    }

    public boolean isLoggable(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(record);
    }

    void checkAccess() throws SecurityException {
        if (this.sealed) {
            this.manager.checkAccess();
        }
    }
}

