/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import orbital.util.logging.Handler;
import orbital.util.logging.LogRecord;

public abstract class Formatter {
    protected Formatter() {
    }

    public abstract String format(LogRecord var1);

    public String getHead(Handler h) {
        return "";
    }

    public String getTail(Handler h) {
        return "";
    }

    public synchronized String formatMessage(LogRecord record) {
        String format = record.getMessage();
        ResourceBundle catalog = record.getResourceBundle();
        if (catalog != null) {
            try {
                format = catalog.getString(record.getMessage());
            }
            catch (MissingResourceException ex) {
                format = record.getMessage();
            }
        }
        try {
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                return format;
            }
            if (format.indexOf("{0") >= 0) {
                return MessageFormat.format(format, parameters);
            }
            return format;
        }
        catch (Exception ex) {
            return format;
        }
    }
}

