/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import orbital.util.KeyValuePair;
import orbital.util.graph.Graph;
import orbital.util.graph.IndirectIterator;
import orbital.util.graph.Node;

public class MatrixGraph
implements Graph {
    protected boolean[][] edges;
    protected List nodes;
    protected Set roots;
    private int size = 0;

    public MatrixGraph(int capacity) {
        this.edges = new boolean[capacity][capacity];
        this.nodes = new ArrayList(capacity);
        this.roots = new HashSet();
    }

    public Iterator getRoots() {
        return new IndirectIterator(this.roots.iterator(), this.nodes);
    }

    public boolean addRoot(Node root) {
        if (this.roots.contains(root)) {
            return false;
        }
        GraphNode gn = (GraphNode)root;
        gn.index = this.size++;
        this.nodes.add(gn.index, gn);
        this.roots.add(new Integer(gn.index));
        return true;
    }

    public boolean removeRoot(Node root) {
        Iterator i = this.roots.iterator();
        while (i.hasNext()) {
            int index = (Integer)i.next();
            if (!root.equals(this.nodes.get(index))) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public Node createNode() {
        return new GraphNode(null, null);
    }

    public class GraphNode
    extends KeyValuePair
    implements Node {
        protected int index = -1;

        public GraphNode(Object key, Object data) {
            super(key, data);
        }

        public boolean isLeaf() {
            return this.getEdgeCount() == 0;
        }

        public int getEdgeCount() {
            int count = 0;
            int j = 0;
            while (j < MatrixGraph.this.edges[this.index].length) {
                if (MatrixGraph.this.edges[this.index][j]) {
                    ++count;
                }
                ++j;
            }
            return count;
        }

        public Iterator edges() {
            return new Iterator(this){
                private int j;
                private final /* synthetic */ GraphNode this$1;
                {
                    this.this$1 = this$1;
                    this.j = 0;
                }

                public boolean hasNext() {
                    while (this.j < GraphNode.access$000((GraphNode)this.this$1).edges[this.this$1.index].length) {
                        if (GraphNode.access$000((GraphNode)this.this$1).edges[this.this$1.index][this.j]) {
                            return true;
                        }
                        ++this.j;
                    }
                    return false;
                }

                public Object next() {
                    while (this.j < GraphNode.access$000((GraphNode)this.this$1).edges[this.this$1.index].length) {
                        if (GraphNode.access$000((GraphNode)this.this$1).edges[this.this$1.index][this.j]) {
                            return GraphNode.access$000((GraphNode)this.this$1).nodes.get(this.j++);
                        }
                        ++this.j;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean add(Node n) {
            GraphNode gn = (GraphNode)n;
            if (gn.index < 0) {
                gn.index = MatrixGraph.this.size++;
            }
            boolean old = MatrixGraph.this.edges[this.index][gn.index];
            MatrixGraph.this.edges[this.index][gn.index] = true;
            if (!MatrixGraph.this.nodes.contains(n)) {
                MatrixGraph.this.nodes.add(n);
            }
            return !old;
        }

        public boolean remove(Node n) {
            GraphNode gn = (GraphNode)n;
            boolean old = MatrixGraph.this.edges[this.index][gn.index];
            MatrixGraph.this.edges[this.index][gn.index] = false;
            return old;
        }

        public Node min() {
            throw new UnsupportedOperationException();
        }

        public Node max() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ MatrixGraph access$000(GraphNode x0) {
            return x0.MatrixGraph.this;
        }
    }
}

