/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import orbital.logic.functor.Predicate;
import orbital.util.KeyValuePair;
import orbital.util.SuspiciousError;
import orbital.util.graph.Graph;
import orbital.util.graph.Node;

public class ListGraph
implements Graph {
    protected Set roots = new HashSet();
    static /* synthetic */ Class class$orbital$util$graph$ListGraph$GraphNode;

    public ListGraph(GraphNode root) {
        if (root != null) {
            this.addRoot(root);
        }
    }

    public Iterator getRoots() {
        return Collections.unmodifiableCollection(this.roots).iterator();
    }

    public boolean addRoot(Node root) {
        if (!(root instanceof GraphNode)) {
            throw new IllegalArgumentException("can only handle nodes of type " + (class$orbital$util$graph$ListGraph$GraphNode == null ? (class$orbital$util$graph$ListGraph$GraphNode = ListGraph.class$("orbital.util.graph.ListGraph$GraphNode")) : class$orbital$util$graph$ListGraph$GraphNode));
        }
        return this.roots.add((GraphNode)root);
    }

    public boolean removeRoot(Node root) {
        return this.roots.remove((GraphNode)root);
    }

    public void visit(Predicate predescend, Predicate ondescend, Predicate postdescend) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Node createNode() {
        return new GraphNode(null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GraphNode
    extends KeyValuePair
    implements Node {
        protected List children = new LinkedList();

        public GraphNode(Object key, Object data) {
            super(key, data);
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public int getEdgeCount() {
            return this.children.size();
        }

        public Iterator edges() {
            return this.children.iterator();
        }

        public boolean add(Node n) {
            return this.children.add(n);
        }

        public boolean remove(Node n) {
            return this.children.remove(n);
        }

        public Node min() {
            try {
                Node n = this;
                while (!n.isLeaf()) {
                    n = (Node)n.edges().next();
                }
                return n;
            }
            catch (ClassCastException oops) {
                throw new SuspiciousError("child is no Node: " + oops);
            }
        }

        public Node max() {
            try {
                Node n = this;
                while (!n.isLeaf()) {
                    n = (Node)n.children.get(n.children.size() - 1);
                }
                return n;
            }
            catch (ClassCastException oops) {
                throw new SuspiciousError("child is no node: " + oops);
            }
        }

        public String toString() {
            return super.toString() + this.children;
        }
    }
}

