/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.graph;

import java.util.Iterator;
import java.util.List;

class IndirectIterator
implements Iterator {
    private Iterator indices;
    private List lookup;
    private int lastIndex = -1;

    public IndirectIterator(Iterator indices, List lookup) {
        this.indices = indices;
        this.lookup = lookup;
    }

    public boolean hasNext() {
        return this.indices.hasNext();
    }

    public Object next() {
        this.lastIndex = (Integer)this.indices.next();
        return this.lookup.get(this.lastIndex);
    }

    public void remove() {
        Object backup;
        if (this.lastIndex < 0) {
            throw new IllegalStateException();
        }
        try {
            backup = this.lookup.remove(this.lastIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException(e.getMessage());
        }
        try {
            this.indices.remove();
        }
        catch (Exception failed) {
            this.lookup.add(this.lastIndex, backup);
            throw new UnsupportedOperationException("not supported by inner iterator");
        }
    }
}

