/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Predicate;
import orbital.math.MathUtilities;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.util.NaturalComparator;
import orbital.util.NotIteratableException;
import orbital.util.Setops;

public final class Utility {
    private static final int INTEGER_BITS = 32;
    public static final BinaryPredicate instanceOf = new BinaryPredicate(){

        public boolean apply(Object obj, Object clazz) {
            return ((Class)clazz).isInstance(obj);
        }
    };
    private static final Set generalizedIteratableTypes = new HashSet<Class>(Arrays.asList(class$java$util$Iterator == null ? (class$java$util$Iterator = Utility.class$("java.util.Iterator")) : class$java$util$Iterator, class$java$util$Collection == null ? (class$java$util$Collection = Utility.class$("java.util.Collection")) : class$java$util$Collection, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Utility.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$orbital$math$Tensor == null ? (class$orbital$math$Tensor = Utility.class$("orbital.math.Tensor")) : class$orbital$math$Tensor, class$orbital$math$Vector == null ? (class$orbital$math$Vector = Utility.class$("orbital.math.Vector")) : class$orbital$math$Vector, class$orbital$math$Matrix == null ? (class$orbital$math$Matrix = Utility.class$("orbital.math.Matrix")) : class$orbital$math$Matrix, array$$Ljava$lang$Object == null ? (array$$Ljava$lang$Object = Utility.class$("[[Ljava.lang.Object;")) : array$$Ljava$lang$Object, array$I == null ? (array$I = Utility.class$("[I")) : array$I, array$$D == null ? (array$$D = Utility.class$("[[D")) : array$$D, array$$D == null ? (array$$D = Utility.class$("[[D")) : array$$D, array$$$Ljava$lang$Object == null ? (array$$$Ljava$lang$Object = Utility.class$("[[[Ljava.lang.Object;")) : array$$$Ljava$lang$Object));
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$orbital$math$Tensor;
    static /* synthetic */ Class class$orbital$math$Vector;
    static /* synthetic */ Class class$orbital$math$Matrix;
    static /* synthetic */ Class array$$Ljava$lang$Object;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$$D;
    static /* synthetic */ Class array$$$Ljava$lang$Object;

    private Utility() {
    }

    public static void pre(boolean test, String description) {
        if (!test) {
            throw new IllegalArgumentException("prerequisite failed: '" + description + "'");
        }
    }

    public static final boolean containsIdenticalTo(Object[] a, Object x) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == x) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static final boolean equalsAll(Object a, Object b) {
        if (Utility.equals(a, b)) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            int len = Array.getLength(a);
            if (Array.getLength(b) != len) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (!Utility.equals(Array.get(a, i), Array.get(b, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final int hashCode(Object a) {
        return a == null ? 0 : a.hashCode();
    }

    public static final int compare(Object a, Object b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : ((Comparable)a).compareTo(b));
    }

    public static final int hashCodeAll(Object o) {
        if (o instanceof Object[]) {
            Object[] a = (Object[])o;
            int hash = 0;
            int i = 0;
            while (i < a.length) {
                int h = Utility.hashCodeAll(a[i]);
                hash ^= h << i | h >>> 32 - i;
                ++i;
            }
            return hash;
        }
        if (o != null && o.getClass().isArray()) {
            int len = Array.getLength(o);
            int hash = 0;
            int i = 0;
            while (i < len) {
                int h = Utility.hashCodeAll(Array.get(o, i));
                hash ^= h << i | h >>> 32 - i;
                ++i;
            }
            return hash;
        }
        return Utility.hashCode(o);
    }

    public static final int hashCodeSet(Object o) {
        if (o instanceof Object[]) {
            Object[] a = (Object[])o;
            int hash = 0;
            int i = 0;
            while (i < a.length) {
                int h = Utility.hashCodeSet(a[i]);
                hash ^= h;
                ++i;
            }
            return hash;
        }
        if (o != null && o.getClass().isArray()) {
            int len = Array.getLength(o);
            int hash = 0;
            int i = 0;
            while (i < len) {
                int h = Utility.hashCodeSet(Array.get(o, i));
                hash ^= h;
                ++i;
            }
            return hash;
        }
        return Utility.hashCode(o);
    }

    public static final boolean sorted(double[] a, boolean asc) {
        if (asc) {
            int i = 1;
            while (i < a.length) {
                if (a[i - 1] > a[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < a.length) {
                if (a[i - 1] < a[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static final boolean sorted(List a, Comparator cmp) {
        if (cmp == null) {
            cmp = new NaturalComparator();
        }
        if (a.isEmpty()) {
            return true;
        }
        Iterator i = a.iterator();
        Object last = i.next();
        while (i.hasNext()) {
            Object o = i.next();
            if (cmp.compare(last, o) > 0) {
                return false;
            }
            last = o;
        }
        return true;
    }

    public static final int rank(Object[] a) {
        int r = 1;
        while (a[0] instanceof Object[]) {
            a = (Object[])a[0];
            ++r;
        }
        return r;
    }

    public static final int rank(Object a) {
        int r = 0;
        while (a.getClass().isArray()) {
            a = Array.get(a, 0);
            ++r;
        }
        return r;
    }

    private static final Class getComponentType(Object a) {
        Class<?> component = a.getClass();
        while (a.getClass().isArray()) {
            component = a.getClass().getComponentType();
            a = Array.get(a, 0);
        }
        return component;
    }

    public static final int[] dimensions(Object[] a) {
        int[] dim = new int[Utility.rank(a)];
        int i = 0;
        while (i < dim.length - 1) {
            dim[i] = a.length;
            a = (Object[])a[0];
            ++i;
        }
        dim[dim.length - 1] = a.length;
        return dim;
    }

    public static final int[] dimensions(Object a) {
        int[] dim = new int[Utility.rank(a)];
        int i = 0;
        while (i < dim.length) {
            dim[i] = Array.getLength(a);
            a = Array.get(a, 0);
            ++i;
        }
        return dim;
    }

    public static Object getPart(Object[] a, int[] partSpecification) {
        Object o = a;
        int i = 0;
        while (i < partSpecification.length) {
            o = o[partSpecification[i]];
            ++i;
        }
        return o;
    }

    public static Object getPart(Object a, int[] partSpecification) {
        Object o = a;
        int i = 0;
        while (i < partSpecification.length) {
            o = Array.get(o, partSpecification[i]);
            ++i;
        }
        return o;
    }

    public static void setPart(Object[] a, int[] partSpecification, Object value) {
        Object[] o = a;
        int i = 0;
        while (i < partSpecification.length - 1) {
            o = (Object[])o[partSpecification[i]];
            ++i;
        }
        o[partSpecification[partSpecification.length - 1]] = value;
    }

    public static void setPart(Object a, int[] partSpecification, Object value) {
        Object o = a;
        int i = 0;
        while (i < partSpecification.length - 1) {
            o = Array.get(o, partSpecification[i]);
            ++i;
        }
        Array.set(o, partSpecification[partSpecification.length - 1], value);
    }

    public static boolean flip(Random r, double probability) {
        Utility.pre(MathUtilities.isProbability(probability), probability + " is a probability");
        return r.nextDouble() <= probability;
    }

    public static int matchingBrace(String text, int pos) {
        int level = 0;
        int i = pos;
        while (i < text.length()) {
            switch (text.charAt(i)) {
                case '(': {
                    ++level;
                    break;
                }
                case ')': {
                    --level;
                    break;
                }
            }
            if (level == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean forallPublicMembers(Object o, Predicate pred) throws IllegalAccessException {
        Class<?> cls = o.getClass();
        Field[] fields = cls.getFields();
        int i = 0;
        while (i < fields.length) {
            Object value = fields[i].get(o);
            if (!pred.apply(value)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forallMembers(Object o, Predicate pred) throws IllegalAccessException {
        Class<?> cls = o.getClass();
        while (cls != null) {
            Field[] fields = cls.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Object value;
                if (!fields[i].isAccessible()) {
                    fields[i].setAccessible(true);
                }
                if (!pred.apply(value = fields[i].get(o))) {
                    return false;
                }
                ++i;
            }
            cls = cls.getSuperclass();
        }
        return true;
    }

    public static Collection asCollection(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o instanceof Object[]) {
            return Arrays.asList((Object[])o);
        }
        return Collections.singletonList(o);
    }

    public static boolean isIteratable(Object a) {
        return a instanceof Iterator || a instanceof Collection || a instanceof Tensor || a.getClass().isArray();
    }

    public static Iterator asIterator(Object a) throws NotIteratableException {
        if (a == null) {
            return null;
        }
        if (a instanceof Iterator) {
            return (Iterator)a;
        }
        if (a instanceof Collection) {
            if (a instanceof List) {
                return ((List)a).listIterator();
            }
            return ((Collection)a).iterator();
        }
        if (a instanceof Tensor) {
            return ((Tensor)a).iterator();
        }
        if (a instanceof Object[] && !a.getClass().getComponentType().isArray()) {
            return Arrays.asList((Object[])a).listIterator();
        }
        if (a.getClass().isArray()) {
            return Values.getDefaultInstance().tensor(a).iterator();
        }
        throw new NotIteratableException(a.getClass(), generalizedIteratableTypes);
    }

    public static Object newIteratableLike(Object a) throws NotIteratableException {
        if (a == null) {
            return null;
        }
        if (a instanceof Iterator) {
            if (a instanceof ListIterator) {
                return new LinkedList().listIterator();
            }
            return new LinkedList().iterator();
        }
        if (a instanceof Collection) {
            return Setops.newCollectionLike((Collection)a);
        }
        if (a instanceof Tensor) {
            return Values.getDefaultInstance().tensor(((Tensor)a).dimensions());
        }
        if (a.getClass().isArray()) {
            return Array.newInstance(Utility.getComponentType(a), Utility.dimensions(a));
        }
        throw new NotIteratableException(a.getClass(), generalizedIteratableTypes);
    }

    public static final String format(String delimiter, Object iteratable) {
        StringBuffer sb = new StringBuffer();
        Iterator i = Utility.asIterator(iteratable);
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

