/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.util.Iterator;
import orbital.util.Callback;
import orbital.util.InquiringQueuedIterator;
import orbital.util.QueuedIterator;
import orbital.util.ResumingQueuedIterator;
import orbital.util.logging.Level;
import orbital.util.logging.Logger;

public abstract class StreamMethod
extends Thread
implements Callback {
    static final Logger logger = Logger.getLogger((class$orbital$util$StreamMethod == null ? (class$orbital$util$StreamMethod = StreamMethod.class$("orbital.util.StreamMethod")) : class$orbital$util$StreamMethod).getName());
    private static final ThreadGroup streamMethodCoroutines = new ThreadGroup("Stream method coroutines");
    private static int streamMethodInitNumber;
    private final boolean synchronousConnector;
    private QueuedIterator resultStream;
    private volatile boolean requested = false;
    private Object suspension = new Object();
    private volatile boolean suspended = false;
    static /* synthetic */ Class class$orbital$util$StreamMethod;

    private static synchronized int nextStreamMethodNum() {
        return streamMethodInitNumber++;
    }

    protected StreamMethod() {
        this(true);
    }

    protected StreamMethod(boolean synchronousConnector) {
        super(streamMethodCoroutines, "StreamMethod-" + StreamMethod.nextStreamMethodNum());
        this.setDaemon(true);
        this.synchronousConnector = synchronousConnector;
        this.resultStream = synchronousConnector ? new ResumingQueuedIterator(this) : new InquiringQueuedIterator(this);
    }

    public Iterator apply() {
        QueuedIterator moribund = this.resultStream;
        if (this.synchronousConnector) {
            this.safeSuspend();
        }
        this.start();
        return moribund;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumedReturn(Object ret) {
        StreamMethod streamMethod = this;
        synchronized (streamMethod) {
            this.resultStream.add(ret);
            this.requested = false;
            logger.log(Level.FINER, "< resumedReturn ", ret);
            this.notifyAll();
        }
        Thread.yield();
        if (this.synchronousConnector && !this.requested) {
            this.safeSuspend();
        }
        this.checkSuspend();
        logger.log(Level.FINER, "> resume ... ", ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void request() {
        if (!this.isAlive()) return;
        this.requested = true;
        if (this.isSuspended()) {
            this.safeResume();
        }
        try {
            while (this.resultStream != null) {
                if (!this.resultStream.isEmpty()) {
                    return;
                }
                StreamMethod streamMethod = this;
                synchronized (streamMethod) {
                    this.wait();
                }
            }
            return;
        }
        catch (InterruptedException irq) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    protected abstract void runStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.checkSuspend();
        this.runStream();
        logger.log(Level.FINEST, "< return and exit");
        StreamMethod streamMethod = this;
        synchronized (streamMethod) {
            this.resultStream = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void safeSuspend() {
        Object object = this.suspension;
        synchronized (object) {
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void safeResume() {
        Object object = this.suspension;
        synchronized (object) {
            if (!this.suspended) {
                return;
            }
            this.suspended = false;
            this.suspension.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isSuspended() {
        Object object = this.suspension;
        synchronized (object) {
            return this.suspended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkSuspend() {
        block6: {
            if (!this.suspended) break block6;
            try {
                Object object = this.suspension;
                synchronized (object) {
                    while (this.suspended) {
                        this.suspension.wait();
                    }
                }
            }
            catch (InterruptedException irq) {
                logger.log(Level.WARNING, "safeSuspend/resumedReturn() had wait interrupted", irq);
                Thread.currentThread().interrupt();
            }
        }
    }

    final void safeStop() {
        logger.log(Level.FINER, "stop coroutine");
        this.interrupt();
        Thread.yield();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        streamMethodCoroutines.setDaemon(false);
    }
}

