/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Function;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.Predicates;
import orbital.util.Filters;
import orbital.util.Pair;
import orbital.util.ReverseComparator;

public final class Setops {
    private static final Class randomAccessClass = Setops.possiblyClassForName("java.util.RandomAccess");

    private Setops() {
    }

    private static Class possiblyClassForName(String name) {
        try {
            return Class.forName("java.util.RandomAccess");
        }
        catch (ClassNotFoundException priorToJDK1_4) {
            return null;
        }
    }

    public static Object find(Collection coll, Predicate found) {
        return Setops.find(coll.iterator(), found);
    }

    public static Object find(Iterator i, Predicate found) {
        while (i.hasNext()) {
            Object o = i.next();
            if (!found.apply(o)) continue;
            return o;
        }
        return null;
    }

    public static int count(Collection coll, Predicate cond) {
        return Setops.count(coll.iterator(), cond);
    }

    public static int count(Iterator i, Predicate cond) {
        int count = 0;
        while (i.hasNext()) {
            Object o = i.next();
            if (!cond.apply(o)) continue;
            ++count;
        }
        return count;
    }

    public static boolean all(Collection coll, Predicate found) {
        return Setops.all(coll.iterator(), found);
    }

    public static boolean all(Iterator i, Predicate found) {
        while (i.hasNext()) {
            if (found.apply(i.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean all(Collection a, Collection b, BinaryPredicate found) {
        return a.size() == b.size() && Setops.all(a.iterator(), b.iterator(), found);
    }

    public static boolean all(Iterator i, Iterator j, BinaryPredicate found) {
        while (i.hasNext() && j.hasNext()) {
            if (found.apply(i.next(), j.next())) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    public static boolean some(Collection coll, Predicate found) {
        return Setops.some(coll.iterator(), found);
    }

    public static boolean some(Iterator i, Predicate found) {
        while (i.hasNext()) {
            if (!found.apply(i.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean some(Collection a, Collection b, BinaryPredicate found) {
        return Setops.some(a.iterator(), b.iterator(), found);
    }

    public static boolean some(Iterator i, Iterator j, BinaryPredicate found) {
        while (i.hasNext() && j.hasNext()) {
            if (!found.apply(i.next(), j.next())) continue;
            return true;
        }
        return false;
    }

    public static final Object argmin(Iterator choices, Function f) {
        Object best = choices.next();
        Comparable bestValue = (Comparable)f.apply(best);
        while (choices.hasNext()) {
            Object o = choices.next();
            Comparable value = (Comparable)f.apply(o);
            if (value.compareTo(bestValue) >= 0) continue;
            bestValue = value;
            best = o;
        }
        return best;
    }

    public static final Object argmax(Iterator choices, Function f) {
        Object best = choices.next();
        Comparable bestValue = (Comparable)f.apply(best);
        while (choices.hasNext()) {
            Object o = choices.next();
            Comparable value = (Comparable)f.apply(o);
            if (value.compareTo(bestValue) <= 0) continue;
            bestValue = value;
            best = o;
        }
        return best;
    }

    public static Collection union(Collection a, Collection b) {
        Collection c = Setops.newCollectionLike(a);
        c.addAll(a);
        c.addAll(b);
        return c;
    }

    public static Set union(Set a, Set b) {
        return (Set)Setops.union((Collection)a, (Collection)b);
    }

    public static SortedSet union(SortedSet a, SortedSet b) {
        return (SortedSet)Setops.union((Collection)a, (Collection)b);
    }

    public static Collection intersection(Collection a, Collection b) {
        Collection c = Setops.newCollectionLike(a);
        c.addAll(a);
        c.retainAll(b);
        return c;
    }

    public static Set intersection(Set a, Set b) {
        return (Set)Setops.intersection((Collection)a, (Collection)b);
    }

    public static SortedSet intersection(SortedSet a, SortedSet b) {
        return (SortedSet)Setops.intersection((Collection)a, (Collection)b);
    }

    public static Collection complement(Collection universal, Collection a) {
        Collection c = Setops.newCollectionLike(universal);
        c.addAll(universal);
        c.removeAll(a);
        return c;
    }

    public static Set complement(Set universal, Set a) {
        return (Set)Setops.complement((Collection)universal, (Collection)a);
    }

    public static SortedSet complement(SortedSet universal, SortedSet a) {
        return (SortedSet)Setops.complement((Collection)universal, (Collection)a);
    }

    public static final Collection difference(Collection a, Collection b) {
        return Setops.complement(a, b);
    }

    public static final Set difference(Set a, Set b) {
        return Setops.complement(a, b);
    }

    public static final SortedSet difference(SortedSet a, SortedSet b) {
        return Setops.complement(a, b);
    }

    public static Collection symmetricDifference(Collection a, Collection b) {
        return Setops.union(Setops.complement(a, b), Setops.complement(b, a));
    }

    public static Set symmetricDifference(Set a, Set b) {
        return Setops.union(Setops.complement(a, b), Setops.complement(b, a));
    }

    public static SortedSet symmetricDifference(SortedSet a, SortedSet b) {
        return Setops.union(Setops.complement(a, b), Setops.complement(b, a));
    }

    public static Collection cross(Collection a, Collection b) {
        ArrayList<Pair> r = new ArrayList<Pair>(a.size() * b.size());
        Iterator i = a.iterator();
        while (i.hasNext()) {
            Object e = i.next();
            Iterator j = b.iterator();
            while (j.hasNext()) {
                r.add(new Pair(e, j.next()));
            }
        }
        return r;
    }

    public static Iterator cross(Iterator a, Iterator b) {
        return Setops.cross(Setops.asList(a), Setops.asList(b)).iterator();
    }

    public static Collection cross(List a) {
        AbstractList r = new LinkedList<List>();
        r.add(Collections.EMPTY_LIST);
        Iterator i = a.iterator();
        while (i.hasNext()) {
            Collection options = (Collection)i.next();
            ArrayList r_ = new ArrayList(r.size() * options.size());
            Iterator k = r.iterator();
            while (k.hasNext()) {
                List x = (List)k.next();
                Iterator j = options.iterator();
                while (j.hasNext()) {
                    ArrayList x2 = new ArrayList(x.size() + 1);
                    x2.addAll(x);
                    x2.add(j.next());
                    r_.add(x2);
                }
            }
            r = r_;
        }
        return r;
    }

    public static Object any(Collection coll) {
        Iterator it = coll.iterator();
        return it.next();
    }

    public static List asList(Iterator it) {
        LinkedList r = new LinkedList();
        while (it.hasNext()) {
            r.add(it.next());
        }
        return r;
    }

    public static Collection newCollectionLike(Collection c) {
        try {
            if (!(c instanceof SortedSet)) {
                return (Collection)c.getClass().newInstance();
            }
        }
        catch (InstantiationException trial) {
        }
        catch (IllegalAccessException trial) {
            // empty catch block
        }
        if (c instanceof SortedSet) {
            return new TreeSet(((SortedSet)c).comparator());
        }
        if (c instanceof Set) {
            return new HashSet();
        }
        if (c instanceof List) {
            return randomAccessClass != null && randomAccessClass.isInstance(c) ? new ArrayList(c.size()) : new LinkedList();
        }
        throw new IllegalArgumentException("unknown collection type " + c.getClass() + " could not be instantiated");
    }

    public static Iterator unmodifiableIterator(final Iterator i) {
        return new Iterator(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return i.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ListIterator unmodifiableListIterator(final ListIterator i) {
        return new ListIterator(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            public Object next() {
                return i.next();
            }

            public Object previous() {
                return i.previous();
            }

            public int nextIndex() {
                return i.nextIndex();
            }

            public int previousIndex() {
                return i.previousIndex();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Collection unmodifiableCollectionLike(Collection c) {
        if (c instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)c);
        }
        if (c instanceof Set) {
            return Collections.unmodifiableSet((Set)c);
        }
        if (c instanceof List) {
            return Collections.unmodifiableList((List)c);
        }
        return Collections.unmodifiableCollection(c);
    }

    public static void copy(ListIterator dest, Iterator src) {
        while (src.hasNext()) {
            try {
                dest.next();
            }
            catch (NoSuchElementException ex) {
                throw new IndexOutOfBoundsException("destination ListIterator has less storage than source iterator");
            }
            dest.set(src.next());
        }
    }

    public static List merge(List x, List y, Comparator comp) {
        return Setops.merge(x.iterator(), y.iterator(), comp, new ArrayList(x.size() + y.size()));
    }

    public static List merge(Iterator x, Iterator y, Comparator comp) {
        return Setops.merge(x, y, comp, new LinkedList());
    }

    private static List merge(Iterator x, Iterator y, Comparator comp, List r) {
        block6: {
            if (x.hasNext() && y.hasNext()) {
                Object ox = x.next();
                Object oy = y.next();
                while (true) {
                    if (comp.compare(ox, oy) <= 0) {
                        r.add(ox);
                        if (x.hasNext()) {
                            ox = x.next();
                            continue;
                        }
                        r.add(oy);
                        break block6;
                    }
                    r.add(oy);
                    if (!y.hasNext()) break;
                    oy = y.next();
                }
                r.add(ox);
            }
        }
        while (x.hasNext()) {
            r.add(x.next());
        }
        while (y.hasNext()) {
            r.add(y.next());
        }
        return r;
    }

    public static final void insert(List l, Object object) {
        Comparable c = (Comparable)object;
        ListIterator<Comparable> i = l.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (c.compareTo(o) > 0) continue;
            i.previous();
            break;
        }
        i.add(c);
    }

    public static final Map asMap(Object[][] entries) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < entries.length) {
            map.put((String)entries[i][0], entries[i][1]);
            ++i;
        }
        return Collections.unmodifiableMap(map);
    }

    public static final Function createSelection(final Function what, final Predicate where, final Comparator orderBy, final boolean asc) {
        if (what == null) {
            return Setops.createSelection(Filters.all, where, orderBy, asc);
        }
        if (where == null) {
            return Setops.createSelection(what, Functionals.onVoid(Predicates.TRUE), orderBy, asc);
        }
        return new Function(){

            public Object apply(Object from) {
                LinkedList sel = new LinkedList();
                Iterator i = from instanceof Iterator ? (Iterator)from : ((Collection)from).iterator();
                while (i.hasNext()) {
                    Object el = i.next();
                    if (!where.apply(el)) continue;
                    sel.add(el);
                }
                if (orderBy != null) {
                    Collections.sort(sel, asc ? orderBy : new ReverseComparator(orderBy));
                }
                return what.apply(sel);
            }
        };
    }

    public static final Function createSelection(Predicate where) {
        return Setops.createSelection(null, where, null, true);
    }

    public static final Collection select(Function what, Collection from, Predicate where, Comparator orderBy, boolean asc) {
        return (Collection)Setops.createSelection(what, where, orderBy, asc).apply(from);
    }

    public static final Collection select(Function what, Collection from, Predicate where) {
        return Setops.select(what, from, where, null, true);
    }

    public static final Collection select(Function what, Collection from) {
        return Setops.select(what, from, (Predicate)null);
    }

    public static final Collection select(Function what, Collection from, Collection wherePredicates) {
        LinkedList sel = new LinkedList();
        Iterator i = from.iterator();
        Iterator c = wherePredicates.iterator();
        while (i.hasNext()) {
            Object el = i.next();
            Predicate where = (Predicate)c.next();
            if (where != null && !where.apply(el)) continue;
            sel.add(el);
        }
        return what == null ? sel : (Collection)what.apply(sel);
    }
}

