/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import orbital.util.Setops;

public class QueuedSequenceIterator
implements Iterator,
Serializable {
    private final List iterators;
    private Iterator current;
    private Iterator lastUsed;

    public QueuedSequenceIterator(Iterator iterators) {
        this(Setops.asList(iterators));
    }

    public QueuedSequenceIterator(List iterators) {
        this.iterators = iterators instanceof LinkedList ? iterators : new LinkedList(iterators);
    }

    public QueuedSequenceIterator(Iterator[] iterators) {
        this(Arrays.asList(iterators));
    }

    public boolean hasNext() {
        block2: {
            do {
                if (this.current != null && this.current.hasNext()) {
                    return true;
                }
                if (this.iterators.isEmpty()) break block2;
            } while ((this.current = (Iterator)this.iterators.remove(0)) != null);
            throw new NullPointerException("null is not an iterator");
        }
        return false;
    }

    public Object next() {
        block2: {
            do {
                if (this.current != null && this.current.hasNext()) {
                    this.lastUsed = this.current;
                    return this.current.next();
                }
                if (this.iterators.isEmpty()) break block2;
            } while ((this.current = (Iterator)this.iterators.remove(0)) != null);
            throw new NullPointerException("null is not an iterator");
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        if (this.lastUsed == null) {
            throw new IllegalStateException();
        }
        this.lastUsed.remove();
    }

    public boolean add(Object o) {
        return this.iterators.add(o);
    }

    public void add(int index, Object o) {
        this.iterators.add(index, o);
        if (index == 0) {
            this.iterators.add(1, this.current);
            this.current = (Iterator)o;
        }
    }
}

