/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import orbital.util.EventObjectListener;
import orbital.util.SuspiciousError;

public class EventCollector
implements KeyListener {
    protected Collection eventObjectListeners = new ArrayList();
    protected long event_mask;

    public EventCollector(long event_subscription_mask) {
        this.event_mask = event_subscription_mask;
    }

    public EventCollector() {
        this(Long.MAX_VALUE);
    }

    public void addEventObjectListener(EventObjectListener l) {
        this.eventObjectListeners.add(l);
    }

    public void removeEventObjectListener(EventObjectListener l) {
        this.eventObjectListeners.remove(l);
    }

    protected void multiplexEventObject(EventObject ev) {
        Iterator i = this.eventObjectListeners.iterator();
        while (i.hasNext()) {
            try {
                EventObjectListener l = (EventObjectListener)i.next();
                l.eventObjectOccured(ev);
            }
            catch (ClassCastException oops) {
                throw new SuspiciousError("invalid member: " + oops);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if ((this.event_mask & 8L) != 0L) {
            this.multiplexEventObject(e);
        }
    }

    public void keyTyped(KeyEvent e) {
        if ((this.event_mask & 8L) != 0L) {
            this.multiplexEventObject(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if ((this.event_mask & 8L) != 0L) {
            this.multiplexEventObject(e);
        }
    }
}

