/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

public class Buffer {
    protected int count;
    protected byte[] buf;

    public Buffer() {
        this(0);
    }

    public Buffer(int initialCapacity) {
        this.buf = new byte[initialCapacity];
        this.count = 0;
    }

    public Buffer(byte[] initialContent, int off, int len) {
        this.buf = new byte[len];
        System.arraycopy(initialContent, off, this.buf, 0, len);
        this.count = len;
    }

    public Buffer(byte[] initialContent) {
        this(initialContent, 0, initialContent.length);
    }

    public byte[] getBytes() {
        return this.getBytes(this.count);
    }

    public byte[] getBytes(int len) {
        return this.getBytes(0, len);
    }

    public byte[] getBytes(int off, int len) {
        byte[] buffer = new byte[len];
        this.getBytes(off, buffer, 0, len);
        return buffer;
    }

    public void getBytes(int srcOff, byte[] dst, int dstOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length negative");
        }
        if (len == 0) {
            return;
        }
        if (dst.length < len) {
            throw new IllegalArgumentException("byte-array too small");
        }
        if (srcOff + len > this.count) {
            throw new ArrayIndexOutOfBoundsException("get exceeds size");
        }
        System.arraycopy(this.buf, srcOff, dst, dstOff, len);
    }

    public synchronized void setBytes(byte[] part, int srcOff, int dstOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length negative");
        }
        if (len == 0) {
            return;
        }
        if (srcOff + len > this.count) {
            throw new ArrayIndexOutOfBoundsException("set exceeds size");
        }
        System.arraycopy(part, srcOff, this.buf, dstOff, len);
    }

    public void setBytes(byte[] part, int dstOff) {
        this.setBytes(part, 0, dstOff, part.length);
    }

    public final int size() {
        return this.count;
    }

    public final synchronized void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if (newSize > this.count) {
            this.ensureCapacity(newSize);
        }
        this.count = newSize;
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.buf.length;
        if (this.count < oldCapacity) {
            byte[] oldData = this.buf;
            this.buf = new byte[this.count];
            System.arraycopy(oldData, 0, this.buf, 0, this.count);
        }
    }

    public synchronized void ensureCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if (this.buf.length >= minCapacity) {
            return;
        }
        byte[] oldData = this.buf;
        this.buf = new byte[minCapacity];
        System.arraycopy(oldData, 0, this.buf, 0, this.count);
    }

    public void append(byte[] b) {
        this.append(b, 0, b.length);
    }

    public synchronized void append(byte[] b, int off, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length negative");
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public synchronized void append(int val, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length negative");
        }
        this.ensureCapacity(this.count + len);
        int i = 0;
        while (i < len) {
            this.buf[this.count + i] = (byte)val;
            ++i;
        }
        this.count += len;
    }

    public void remove(int len) {
        this.remove(0, len);
    }

    public synchronized void remove(int off, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("length negative");
        }
        if (len == 0) {
            this.buf = new byte[0];
            return;
        }
        if (off + len > this.count) {
            throw new ArrayIndexOutOfBoundsException("Remove exceeds end of buffer.");
        }
        if (off + len < this.count) {
            System.arraycopy(this.buf, off + len, this.buf, off, this.count - off - len);
        }
        this.count -= len;
    }

    public final byte[] getBuffer() {
        return this.buf;
    }

    public final synchronized void setBuffer(byte[] buffer) {
        this.ensureCapacity(buffer.length);
        System.arraycopy(buffer, 0, this.buf, 0, buffer.length);
    }
}

