/*
 * Decompiled with CFR 0.152.
 */
package orbital.math.functional;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import orbital.math.Arithmetic;
import orbital.math.functional.BinaryFunction;
import orbital.math.functional.Functionals;
import orbital.math.functional.MathFunctor;

abstract class PointwiseMethodFunction
implements BinaryFunction {
    private final Method elemental;

    protected PointwiseMethodFunction(Method elemental) {
        this.elemental = elemental;
    }

    public Object apply(Object x, Object y) {
        if (x instanceof Arithmetic && !(x instanceof MathFunctor) && y instanceof Arithmetic && !(y instanceof MathFunctor)) {
            try {
                return this.elemental.invoke(x, y);
            }
            catch (IllegalAccessException err) {
                throw new IllegalArgumentException("argument does not support invocation because of " + err);
            }
            catch (InvocationTargetException err) {
                throw new IllegalArgumentException("argument does not support invocation because of " + err + ": " + err.getTargetException());
            }
        }
        return Functionals.genericCompose(this, x, y);
    }
}

