/*
 * Decompiled with CFR 0.152.
 */
package orbital.math.functional;

import orbital.logic.sign.concrete.Notation;
import orbital.math.functional.BinaryFunction;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.MathFunctor_CompositeFunctor;
import orbital.math.functional.Operations;
import orbital.util.GeneralComplexionException;

class Compositions {
    static /* synthetic */ Class class$orbital$math$functional$BinaryFunction;

    private Compositions() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CompositeBinaryFunction
    extends MathFunctor_CompositeFunctor
    implements BinaryFunction.Composite {
        protected BinaryFunction outer;
        protected BinaryFunction left;
        protected BinaryFunction right;

        public CompositeBinaryFunction(BinaryFunction outer, BinaryFunction left, BinaryFunction right) {
            this(outer, left, right, null);
        }

        public CompositeBinaryFunction(BinaryFunction outer, BinaryFunction left, BinaryFunction right, Notation notation) {
            super(notation);
            this.outer = outer;
            this.left = left;
            this.right = right;
        }

        private CompositeBinaryFunction() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return new BinaryFunction[]{this.left, this.right};
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (BinaryFunction)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            BinaryFunction[] a = (BinaryFunction[])g;
            if (a.length != 2) {
                throw new IllegalArgumentException((class$orbital$math$functional$BinaryFunction == null ? (class$orbital$math$functional$BinaryFunction = Compositions.class$("orbital.math.functional.BinaryFunction")) : class$orbital$math$functional$BinaryFunction) + "[2] expected");
            }
            this.left = a[0];
            this.right = a[1];
        }

        public Object apply(Object x, Object y) {
            return this.outer.apply(this.left.apply(x, y), this.right.apply(x, y));
        }

        public BinaryFunction derive() {
            return Functionals.compose(Operations.times, Functionals.compose(this.outer.derive(), this.left, this.right), (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{this.left.derive(), this.right.derive()}})));
        }

        public BinaryFunction integrate(int i) {
            if (this.outer == Operations.plus) {
                return Functionals.compose(Operations.plus, this.left.integrate(i), this.right.integrate(i));
            }
            if (this.outer == Operations.subtract) {
                return Functionals.compose(Operations.subtract, this.left.integrate(i), this.right.integrate(i));
            }
            throw new GeneralComplexionException("integrating a composition would require integral substitution");
        }
    }

    static class CompositeFunction
    extends MathFunctor_CompositeFunctor
    implements Function.Composite {
        protected Function outer;
        protected Function inner;

        public CompositeFunction(Function f, Function g) {
            this(f, g, null);
        }

        public CompositeFunction(Function f, Function g, Notation notation) {
            super(notation);
            this.outer = f;
            this.inner = g;
        }

        private CompositeFunction() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return this.inner;
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (Function)f;
        }

        public void setComponent(Object g) throws ClassCastException {
            this.inner = (Function)g;
        }

        public Object apply(Object x) {
            return this.outer.apply(this.inner.apply(x));
        }

        public Function derive() {
            return Functionals.compose(Operations.times, Functionals.compose(this.outer.derive(), this.inner), this.inner.derive());
        }

        public Function integrate() {
            if (this.outer == Operations.minus) {
                return Functionals.compose(Operations.minus, this.inner.integrate());
            }
            if (this.outer == Functions.id) {
                return this.inner.integrate();
            }
            throw new GeneralComplexionException("integrating a composition would require integral substitution");
        }
    }
}

