/*
 * Decompiled with CFR 0.152.
 */
package orbital.math.functional;

import java.awt.Dimension;
import orbital.logic.sign.concrete.Notation;
import orbital.math.Arithmetic;
import orbital.math.Matrix;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.BinaryFunction;
import orbital.math.functional.Function;
import orbital.math.functional.MathFunctor_CompositeFunctor;

class ComponentCompositions {
    private ComponentCompositions() {
    }

    static class MatrixComponentCompositeBinaryFunction
    extends MathFunctor_CompositeFunctor
    implements BinaryFunction {
        private BinaryFunction[][] componentFunction;

        public MatrixComponentCompositeBinaryFunction(BinaryFunction[][] componentFunction) {
            this(componentFunction, null);
        }

        public MatrixComponentCompositeBinaryFunction(BinaryFunction[][] componentFunction, Notation notation) {
            super(notation);
            this.componentFunction = componentFunction;
        }

        public Dimension dimension() {
            return new Dimension(this.componentFunction[0].length, this.componentFunction.length);
        }

        public Object getCompositor() {
            return null;
        }

        public Object getComponent() {
            return this.componentFunction;
        }

        public void setCompositor(Object f) throws IllegalArgumentException {
            if (f != null) {
                throw new IllegalArgumentException("cannot set compositor");
            }
        }

        public void setComponent(Object g) throws ClassCastException {
            this.componentFunction = (BinaryFunction[][])g;
        }

        public Object apply(Object x, Object y) {
            Matrix ret = Values.getDefaultInstance().newInstance(this.dimension());
            int i = 0;
            while (i < this.dimension().height) {
                int j = 0;
                while (j < this.dimension().width) {
                    ret.set(i, j, (Arithmetic)this.componentFunction[i][j].apply(x, y));
                    ++j;
                }
                ++i;
            }
            return ret;
        }

        public BinaryFunction derive() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public BinaryFunction integrate(int i) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String toString() {
            String nl = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.dimension().height) {
                sb.append((i == 0 ? "" : nl) + '[');
                int j = 0;
                while (j < this.dimension().width) {
                    sb.append((j == 0 ? "" : ",\t") + this.componentFunction[i][j]);
                    ++j;
                }
                sb.append(']');
                ++i;
            }
            return sb.toString();
        }
    }

    static class MatrixComponentCompositeFunction
    extends MathFunctor_CompositeFunctor
    implements Function {
        private Function[][] componentFunction;

        public MatrixComponentCompositeFunction(Function[][] componentFunction) {
            this(componentFunction, null);
        }

        public MatrixComponentCompositeFunction(Function[][] componentFunction, Notation notation) {
            super(notation);
            this.componentFunction = componentFunction;
        }

        public Dimension dimension() {
            return new Dimension(this.componentFunction[0].length, this.componentFunction.length);
        }

        public Object getCompositor() {
            return null;
        }

        public Object getComponent() {
            return this.componentFunction;
        }

        public void setCompositor(Object f) throws IllegalArgumentException {
            if (f != null) {
                throw new IllegalArgumentException("cannot set compositor");
            }
        }

        public void setComponent(Object g) throws ClassCastException {
            this.componentFunction = (Function[][])g;
        }

        public Object apply(Object x) {
            Matrix ret = Values.getDefaultInstance().newInstance(this.dimension());
            int i = 0;
            while (i < this.dimension().height) {
                int j = 0;
                while (j < this.dimension().width) {
                    ret.set(i, j, (Arithmetic)this.componentFunction[i][j].apply(x));
                    ++j;
                }
                ++i;
            }
            return ret;
        }

        public Function derive() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public Function integrate() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public String toString() {
            String nl = System.getProperty("line.separator");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.dimension().height) {
                sb.append((i == 0 ? "" : nl) + '[');
                int j = 0;
                while (j < this.dimension().width) {
                    sb.append((j == 0 ? "" : ",\t") + this.componentFunction[i][j]);
                    ++j;
                }
                sb.append(']');
                ++i;
            }
            return sb.toString();
        }
    }

    static class ComponentCompositeFunction
    extends MathFunctor_CompositeFunctor
    implements Function {
        private Function[] componentFunction;

        public ComponentCompositeFunction(Function[] componentFunction) {
            this(componentFunction, null);
        }

        public ComponentCompositeFunction(Function[] componentFunction, Notation notation) {
            super(notation);
            this.componentFunction = componentFunction;
        }

        public int dimension() {
            return this.componentFunction.length;
        }

        public Object getCompositor() {
            return null;
        }

        public Object getComponent() {
            return this.componentFunction;
        }

        public void setCompositor(Object f) throws IllegalArgumentException {
            if (f != null) {
                throw new IllegalArgumentException("cannot set compositor");
            }
        }

        public void setComponent(Object g) throws ClassCastException {
            this.componentFunction = (Function[])g;
        }

        public Object apply(Object x) {
            Vector r = Values.getDefaultInstance().newInstance(this.dimension());
            int i = 0;
            while (i < r.dimension()) {
                r.set(i, (Arithmetic)this.componentFunction[i].apply(x));
                ++i;
            }
            return r;
        }

        public Function derive() {
            Function[] di = new Function[this.dimension()];
            int i = 0;
            while (i < di.length) {
                di[i] = this.componentFunction[i].derive();
                ++i;
            }
            return new ComponentCompositeFunction(di);
        }

        public Function integrate() {
            Function[] di = new Function[this.dimension()];
            int i = 0;
            while (i < di.length) {
                di[i] = this.componentFunction[i].integrate();
                ++i;
            }
            return new ComponentCompositeFunction(di);
        }
    }
}

