/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import orbital.logic.functor.BinaryFunction;
import orbital.math.Evaluations;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.functional.CoordinateCompositeFunction;
import orbital.util.Utility;

public final class Stat {
    private Stat() {
    }

    public static double arithmeticMean(double[] x) {
        return Evaluations.sum(x) / (double)x.length;
    }

    public static double geometricMean(double[] x) {
        return Math.pow(Functionals.foldRight((BinaryFunction)Operations.times, 1.0, x), 1.0 / (double)x.length);
    }

    public static double harmonicMean(double[] x) {
        return (double)x.length / Functionals.foldRight((BinaryFunction)Operations.plus, 0.0, Functionals.map((orbital.logic.functor.Function)Functions.reciprocal, x));
    }

    public static double mean(double[] x) {
        return Stat.arithmeticMean(x);
    }

    public static double average(double[] x) {
        return Stat.arithmeticMean(x);
    }

    public static double variance(double[] x) {
        double xm = Stat.mean(x);
        double s = 0.0;
        int i = 0;
        while (i < x.length) {
            s += (x[i] - xm) * (x[i] - xm);
            ++i;
        }
        return 1.0 / ((double)x.length - 1.0) * s;
    }

    public static double standardDeviation(double[] x) {
        return Math.sqrt(Stat.variance(x));
    }

    public static double coefficientOfVariation(double[] x) {
        return Stat.standardDeviation(x) / Stat.mean(x);
    }

    public static double median(double[] x) {
        Utility.pre(Utility.sorted(x, true), "sorted values");
        if (MathUtilities.odd(x.length)) {
            return x[(x.length - 1) / 2];
        }
        return (x[x.length / 2 - 1] + x[x.length / 2]) / 2.0;
    }

    public static double quantile(double[] x, double a) {
        Utility.pre(0.0 < a && a < 1.0, "quantile must be in the range of (0,1)");
        Utility.pre(Utility.sorted(x, true), "sorted values");
        int k = MathUtilities.gaussian((double)x.length * a);
        if (MathUtilities.equalsCa(MathUtilities.fract((double)x.length * a), 0.0)) {
            return x[k];
        }
        return (x[k - 1] + x[k]) / 2.0;
    }

    public static double trimmedMean(double[] x, double a) {
        Utility.pre(0.0 <= a && a < 0.5, "quantile must be in range of [0,0.5)");
        Utility.pre(Utility.sorted(x, true), "sorted values");
        int k = MathUtilities.gaussian((double)x.length * a);
        double s = 0.0;
        int i = k;
        while (i < x.length - k) {
            s += x[i];
            ++i;
        }
        return 1.0 / (double)(x.length - 2 * k) * s;
    }

    public static double meanDeviation(double[] x) {
        double xm = Stat.mean(x);
        double s = 0.0;
        int i = 0;
        while (i < x.length) {
            s += Math.abs(x[i] - xm);
            ++i;
        }
        return 1.0 / (double)x.length * s;
    }

    public static String statistics(double[] x) {
        return "min: " + MathUtilities.format(Evaluations.min(x)) + "\tmax: " + MathUtilities.format(Evaluations.max(x)) + "\tavg: " + MathUtilities.format(Stat.average(x)) + "\tstdDev: " + MathUtilities.format(Stat.standardDeviation(x));
    }

    public static double coefficientOfCorrelation(double[] x, double[] y) {
        Utility.pre(x.length == y.length, "double arrays representing pairs must have the same length");
        double xm = Stat.mean(x);
        double ym = Stat.mean(y);
        double s = 0.0;
        int i = 0;
        while (i < x.length) {
            s += (x[i] - xm) * (y[i] - ym);
            ++i;
        }
        return 1.0 / ((double)x.length - 1.0) * s / Stat.standardDeviation(x) / Stat.standardDeviation(y);
    }

    public static Function functionalRegression(Function composedFunc, Matrix experiment) {
        Function[] theories = new Function[]{composedFunc};
        Vector a = Stat.regression(theories, experiment);
        return (Function)Operations.times.apply(composedFunc, a);
    }

    public static Vector regression(Function[] funcs, Matrix experiment) {
        Utility.pre(experiment.dimension().width - 1 == funcs.length, "Experiments parametric data and linear combination of functions must fit");
        if (experiment.dimension().width != 2) {
            throw new UnsupportedOperationException("Regression with >2 parameters not yet supported by this method. Use regression(Vector,Matrix,Matrix) instead");
        }
        Values vf = Values.getDefaultInstance();
        int[] dimensions = new int[funcs.length];
        int v = 0;
        while (v < funcs.length) {
            dimensions[v] = funcs[v] instanceof CoordinateCompositeFunction ? ((CoordinateCompositeFunction)funcs[v]).dimension() : 1;
            ++v;
        }
        Matrix A = vf.newInstance(experiment.dimension().height, Evaluations.max(dimensions));
        if (A.dimension().width > A.dimension().height) {
            throw new ArithmeticException("linear coefficients exceed experiment datasets (" + A.dimension().width + ">" + A.dimension().height + ") the statistical solution is ambiguous and (n-m) parametric");
        }
        int v2 = 0;
        while (v2 < funcs.length) {
            int j = 0;
            while (j < experiment.dimension().height) {
                Vector arg = experiment.getRow(j);
                if ((arg = arg.remove(arg.dimension() - 1)).dimension() == 1) {
                    if (funcs[v2] instanceof CoordinateCompositeFunction) {
                        arg = vf.CONST(((CoordinateCompositeFunction)funcs[v2]).argumentDimension(), arg.get(0));
                    } else {
                        throw new UnsupportedOperationException("Supports only regression for single or full parameters. Use elementary regression(Vector, Matrix, Matrix) instead");
                    }
                }
                A.setRow(j, (Vector)funcs[v2].apply(arg));
                ++j;
            }
            ++v2;
        }
        Vector u = experiment.getColumn(experiment.dimension().width - 1);
        return Stat.regression(u, A, vf.IDENTITY(A.dimension().height, A.dimension().height));
    }

    public static Vector regression(Vector u, Matrix A, Matrix Cu) throws ArithmeticException {
        Utility.pre(u.dimension() == A.dimension().height, "Result Vector must have smae dimension as the height of the Matrix");
        if (A.dimension().width > A.dimension().height) {
            throw new ArithmeticException("linear coefficients exceed experiment datasets (" + A.dimension().width + ">" + A.dimension().height + ") the statistical solution is ambiguous and n-m parametric");
        }
        Matrix P = (Matrix)Cu.inverse();
        Matrix Ca_e = A.transpose().multiply(P).multiply(A);
        Matrix R = (Matrix)Ca_e.inverse().multiply(A.transpose()).multiply(P);
        return R.multiply(u);
    }
}

