/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.util.ListIterator;
import orbital.math.Arithmetic;
import orbital.math.Evaluations;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractMatrix;
import orbital.moon.math.functional.AbstractFunctor;
import orbital.util.Utility;
import orbital.util.logging.Level;
import orbital.util.logging.Logger;

public final class NumericalAlgorithms {
    private static final Logger logger = Logger.getLogger((class$orbital$math$NumericalAlgorithms == null ? (class$orbital$math$NumericalAlgorithms = NumericalAlgorithms.class$("orbital.math.NumericalAlgorithms")) : class$orbital$math$NumericalAlgorithms).getName());
    public static final int COMPLETE_SPLINE_INTERPOLATION = 1;
    public static final int NATURAL_SPLINE_INTERPOLATION = 2;
    public static final int PERIODICAL_SPLINE_INTERPOLATION = 3;
    static /* synthetic */ Class class$orbital$math$NumericalAlgorithms;

    private NumericalAlgorithms() {
    }

    public static Matrix decomposeCholesky(Matrix A) throws ArithmeticException {
        Utility.pre(A.isSymmetric() && A.isDefinite() > 0, "Only symmetric and positive-definite matrices can be Cholesky-decomposed");
        Values vf = Values.getDefaultInstance();
        AbstractMatrix A_ = (AbstractMatrix)A;
        AbstractMatrix L = (AbstractMatrix)vf.ZERO(A.dimension().width, A.dimension().width);
        int k = 0;
        while (k < A_.dimension().width) {
            double t = 0.0;
            int j = 0;
            while (j < k) {
                double L_kj = L.getDoubleValue(k, j);
                t += L_kj * L_kj;
                ++j;
            }
            L.set(k, k, (Arithmetic)vf.valueOf(Math.sqrt(A_.getDoubleValue(k, k) - t)));
            int i = k + 1;
            while (i < A_.dimension().height) {
                t = 0.0;
                int j2 = 0;
                while (j2 < k) {
                    t += L.getDoubleValue(i, j2) * L.getDoubleValue(k, j2);
                    ++j2;
                }
                L.set(i, k, (Arithmetic)vf.valueOf((A_.getDoubleValue(i, k) - t) / L.getDoubleValue(k, k)));
                ++i;
            }
            ++k;
        }
        return L;
    }

    public static Vector cgSolve(Matrix A, Vector x0, Vector b) {
        Vector x = (Vector)x0.clone();
        Vector r = b.subtract(A.multiply(x0));
        Vector p = (Vector)r.clone();
        Vector zero = Values.getDefaultInstance().ZERO(r.dimension());
        Real tolerance = Values.getDefaultInstance().valueOf(MathUtilities.getDefaultTolerance());
        int m = 0;
        while (m < A.dimension().width && !r.equals(zero, tolerance)) {
            Vector o_r = (Vector)r.clone();
            Vector a = A.multiply(p);
            Scalar alpha = (Scalar)((Scalar)Functions.square.apply(r.norm(2.0))).divide(a.multiply(p));
            x = x.add(p.scale(alpha));
            r = r.subtract(a.scale(alpha));
            Scalar beta = (Scalar)((Scalar)Functions.square.apply(r.norm(2.0))).divide((Scalar)Functions.square.apply(o_r.norm(2.0)));
            p = r.add(p.scale(beta));
            logger.log(Level.FINE, "cg-iteration {0}, a={1}\nalpha={2}\nx={3}\nr={4}\nbeta={5}\np={6}", new Object[]{new Integer(m), a, alpha, x, r, beta, p});
            ++m;
        }
        return x;
    }

    public static Function polynomialInterpolation(Matrix A) {
        Utility.pre(A.dimension().width == 2, "supporting nodes matrix 2 x m");
        return new PolynomialInterpolationFunction(MathUtilities.toDoubleArray(A.getColumn(0)), MathUtilities.toDoubleArray(A.getColumn(1)));
    }

    public static Function splineInterpolation(int k, Matrix A, int interpolationType) {
        if (interpolationType == 1) {
            throw new IllegalArgumentException("use NumericalAlgorithms.splineInterpolation(int,Matrix,int,Real,Real) for complete spline interpolation");
        }
        return NumericalAlgorithms.splineInterpolation(k, A, interpolationType, null);
    }

    public static Function splineInterpolation(int k, Matrix A, int interpolationType, Real fp_a, Real fp_b) {
        if (interpolationType != 1) {
            throw new IllegalArgumentException("use NumericalAlgorithms.splineInterpolation(int,Matrix,int) for natural and periodical spline interpolation");
        }
        return NumericalAlgorithms.splineInterpolation(k, A, interpolationType, new Number[]{new Double(fp_a.doubleValue()), new Double(fp_b.doubleValue())});
    }

    public static Function splineInterpolation(int k, Matrix A, int interpolationType, Object[] config) {
        if (k != 4) {
            throw new UnsupportedOperationException("spline interpolation not yet implemented for k!=4");
        }
        Utility.pre(A.dimension().width == 2, "supporting nodes matrix 2 x m");
        double[] t = MathUtilities.toDoubleArray(A.getColumn(0));
        double[] f = MathUtilities.toDoubleArray(A.getColumn(1));
        int l = t.length - 2;
        Values vf = Values.getDefaultInstance();
        double[] h = new double[t.length];
        int j = 1;
        while (j < t.length) {
            h[j] = t[j] - t[j - 1];
            ++j;
        }
        Matrix mom = vf.ZERO(l + 2, l + 2);
        Vector d = vf.newInstance(l + 2);
        int j2 = 0;
        while (j2 < mom.dimension().height) {
            mom.set(j2, j2, vf.valueOf(2));
            ++j2;
        }
        int j3 = 1;
        while (j3 <= l) {
            double lambdaj = h[j3 + 1] / (h[j3] + h[j3 + 1]);
            mom.set(j3, j3 + 1, vf.valueOf(lambdaj));
            mom.set(j3, j3 - 1, vf.valueOf(1.0 - lambdaj));
            d.set(j3, (Arithmetic)vf.valueOf(((f[j3 + 1] - f[j3]) / h[j3 + 1] - (f[j3] - f[j3 - 1]) / h[j3]) * 6.0 / (h[j3] + h[j3 + 1])));
            ++j3;
        }
        switch (interpolationType) {
            case 1: {
                double fda = ((Number)config[0]).doubleValue();
                double fdb = ((Number)config[1]).doubleValue();
                mom.set(0, 1, vf.valueOf(1));
                d.set(0, (Arithmetic)vf.valueOf(((f[1] - f[0]) / h[1] - fda) * 6.0 / h[1]));
                mom.set(l + 1, l, Values.ONE);
                d.set(l + 1, (Arithmetic)vf.valueOf((fdb - (f[l + 1] - f[1]) / h[l + 1]) * 6.0 / h[l + 1]));
                break;
            }
            case 2: {
                mom.set(0, 1, Values.ZERO);
                d.set(0, (Arithmetic)Values.ZERO);
                mom.set(l + 1, l, Values.ZERO);
                d.set(l + 1, (Arithmetic)Values.ZERO);
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("periodical spline interpolation not yet implemented");
            }
            default: {
                throw new IllegalArgumentException("no valid interpolation type: " + interpolationType);
            }
        }
        Vector solution = (Vector)mom.inverse().multiply(d);
        double[] m = MathUtilities.toDoubleArray(solution);
        double[][] coefficients = new double[l + 1][k];
        int j4 = 0;
        while (j4 < coefficients.length) {
            coefficients[j4][0] = f[j4];
            coefficients[j4][1] = (f[j4 + 1] - f[j4]) / h[j4 + 1] - (2.0 * m[j4] + m[j4 + 1]) * h[j4 + 1] / 6.0;
            coefficients[j4][2] = 0.5 * m[j4];
            coefficients[j4][3] = (m[j4 + 1] - m[j4]) / (6.0 * h[j4 + 1]);
            ++j4;
        }
        return new SplineInterpolationFunction(k, t, coefficients);
    }

    public static Function bezierCurve(double t0, double tz, Matrix bezierNodes) {
        Values vf = Values.getDefaultInstance();
        Vector[] bezier = new Vector[bezierNodes.dimension().height];
        int i = 0;
        ListIterator it = bezierNodes.getRows();
        while (it.hasNext()) {
            bezier[i++] = (Vector)it.next();
        }
        Function phi = (Function)Operations.times.apply(Functions.constant(vf.valueOf(1.0 / (tz - t0))), Functionals.bindSecond(Operations.subtract, (Object)vf.valueOf(t0)));
        Function[][] b = new Function[bezier.length][bezier.length];
        int i2 = 0;
        while (i2 < b.length) {
            b[i2][0] = Functions.constant(bezier[i2]);
            ++i2;
        }
        int k = 1;
        while (k < b.length) {
            int i3 = 0;
            while (i3 < b[k].length - k) {
                Function t = Functionals.compose(Operations.subtract, Functions.constant(Values.ONE), phi);
                b[i3][k] = (Function)Operations.plus.apply(Operations.times.apply(b[i3][k - 1], t), Operations.times.apply(b[i3 + 1][k - 1], phi));
                ++i3;
            }
            ++k;
        }
        return b[0][b[0].length - 1];
    }

    public static Arithmetic integrate(Function f, Arithmetic a, Arithmetic b) {
        double[] lambda = new double[]{0.07777777777777778, 0.35555555555555557, 0.13333333333333333, 0.35555555555555557, 0.07777777777777778};
        int n = lambda.length - 1;
        double h = ((Number)((Object)b.subtract(a))).doubleValue() / (double)n;
        Values vf = Values.getDefaultInstance();
        double[] array = new double[lambda.length];
        int k = 0;
        while (k < array.length) {
            array[k] = lambda[k] * ((Number)f.apply(a.add(vf.valueOf((double)k * h)))).doubleValue();
            ++k;
        }
        return b.subtract(a).scale(vf.valueOf(Evaluations.sum(array)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SplineInterpolationFunction
    extends AbstractFunctor
    implements Function {
        private final int order;
        private final double[] t;
        private final double[][] coefficients;

        public SplineInterpolationFunction(int order, double[] t, double[][] coefficients) {
            this.order = order;
            this.t = t;
            this.coefficients = coefficients;
        }

        public Object apply(Object arg) {
            double x = ((Number)arg).doubleValue();
            int j = 0;
            while (j + 1 < this.t.length) {
                if (x <= this.t[j + 1]) break;
                ++j;
            }
            if (x < this.t[0]) {
                j = 0;
            } else if (x > this.t[this.t.length - 1]) {
                j = this.coefficients.length - 1;
            }
            double r = 0.0;
            double partialExp = 1.0;
            int i = 0;
            while (i < this.coefficients[j].length) {
                r += this.coefficients[j][i] * partialExp;
                partialExp *= x - this.t[j];
                ++i;
            }
            return Values.getDefaultInstance().valueOf(r);
        }

        public Function derive() throws ArithmeticException {
            throw new UnsupportedOperationException("derivative of spline interpolation not yet implemented");
        }

        public Function integrate() throws ArithmeticException {
            throw new UnsupportedOperationException("integral of spline interpolation not yet implemented");
        }

        public String toString() {
            return "[spline" + this.order + "]";
        }
    }

    private static class PolynomialInterpolationFunction
    extends AbstractFunctor
    implements Function {
        private double[] t;
        private double[] f;
        private double[][] p;

        public PolynomialInterpolationFunction(double[] t, double[] f) {
            this.t = t;
            this.f = f;
            this.p = new double[t.length][t.length];
            int i = 0;
            while (i < f.length) {
                this.p[i][0] = f[i];
                ++i;
            }
        }

        public Object apply(Object arg) {
            double x = ((Number)arg).doubleValue();
            int k = 1;
            while (k < this.t.length) {
                int i = k;
                while (i < this.t.length) {
                    this.p[i][k] = this.p[i][k - 1] + (this.p[i][k - 1] - this.p[i - 1][k - 1]) * (x - this.t[i]) / (this.t[i] - this.t[i - k]);
                    ++i;
                }
                ++k;
            }
            return Values.getDefaultInstance().valueOf(this.p[this.t.length - 1][this.t.length - 1]);
        }

        public Function derive() throws ArithmeticException {
            throw new UnsupportedOperationException("derivative of polynomial interpolation not yet implemented");
        }

        public Function integrate() throws ArithmeticException {
            throw new UnsupportedOperationException("integral of polynomial interpolation not yet implemented");
        }

        public String toString() {
            return "P(f|" + MathUtilities.format(this.t) + ")";
        }
    }
}

